/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.util;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class JFreechartChartUtil {
    public static byte[] getPieChart(List<String> labels, List<String> values, String title, int width, int height) {
        DefaultPieDataset pieDataset = new DefaultPieDataset();
        for (int i = 0; i < labels.size(); ++i) {
            pieDataset.setValue((Comparable)((Object)(labels.get(i) + " (" + values.get(i) + ")")), Double.parseDouble(values.get(i)));
        }
        JFreeChart chart = ChartFactory.createPieChart((String)title, (PieDataset)pieDataset, (boolean)false, (boolean)false, (boolean)false);
        try {
            return ChartUtilities.encodeAsPNG((BufferedImage)chart.createBufferedImage(width, height));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static byte[] getBarChart(List<String> labels, List<String> values, String title, int width, int height) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int i = 0; i < labels.size(); ++i) {
            dataset.setValue(Double.parseDouble(values.get(i)), (Comparable)((Object)""), (Comparable)((Object)labels.get(i)));
        }
        JFreeChart chart = ChartFactory.createBarChart((String)title, (String)"", (String)"", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        chart.getTitle().setPaint((Paint)new Color(2894452));
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        BarRenderer r = (BarRenderer)plot.getRenderer();
        r.setShadowVisible(false);
        r.setSeriesPaint(0, (Paint)new Color(14584105));
        r.setBarPainter((BarPainter)new StandardBarPainter());
        try {
            return ChartUtilities.encodeAsPNG((BufferedImage)chart.createBufferedImage(width, height));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }
}

