/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.gis.location;

import com.gallatinsystems.gis.location.GeoLocationService;
import com.gallatinsystems.gis.location.GeoPlace;
import com.gallatinsystems.gis.location.GeoPlaces;
import com.gallatinsystems.gis.map.dao.OGRFeatureDao;
import com.gallatinsystems.gis.map.domain.Geometry;
import com.gallatinsystems.gis.map.domain.OGRFeature;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class GeoLocationServiceGeonamesImpl
implements GeoLocationService {
    private static final Logger log = Logger.getLogger(GeoLocationServiceGeonamesImpl.class.getName());
    private static final String PLACE_SERVICE_URL = "http://api.geonames.org/findNearbyPlaceName?username=akvo&";
    private static final String LAT_PARAM = "lat";
    private static final String LON_PARAM = "lng";
    private Map<String, Double[]> COUNTRY_MBR = new HashMap<String, Double[]>(){
        private static final long serialVersionUID = 9163559500580094769L;
        {
            this.put("GT", new Double[]{17.8152, -92.2414, 13.7373, -88.2232});
            this.put("HN", new Double[]{17.4505, -89.3508, 12.9824, -82.4995});
            this.put("DO", new Double[]{19.9298, -72.0035, 17.4693, -68.32});
            this.put("NI", new Double[]{15.0259, -87.6903, 10.7075, -82.5921});
            this.put("EC", new Double[]{1.6504, -92.0005, -4.9988, -75.1846});
            this.put("BO", new Double[]{-9.6806, -69.6408, -22.8961, -57.4581});
            this.put("PE", new Double[]{-0.013, -81.3267, -18.3497, -68.678});
            this.put("RW", new Double[]{-1.064, 28.871, -2.867, 30.97});
            this.put("MW", new Double[]{-9.3675, 32.674, -17.125, 35.9168});
            this.put("UG", new Double[]{4.2144, 29.5732, -1.484, 35.036});
            this.put("IN", new Double[]{36.2617, 68.0323, 6.7471, 97.403});
            this.put("LR", new Double[]{3.0, -14.7, 8.55179, -7.36511});
        }
    };
    private Map<String, String> COUNTRY_NAME = new HashMap<String, String>(){
        private static final long serialVersionUID = -6506773226209066480L;
        {
            this.put("GT", "Guatemala");
            this.put("HN", "Honduras");
            this.put("NI", "Nicaragua");
            this.put("DO", "Dominican Republic");
            this.put("EC", "Ecuador");
            this.put("BO", "Bolivia");
            this.put("PE", "Peru");
            this.put("RW", "Rwanda");
            this.put("MW", "Malawi");
            this.put("UG", "Uganda");
            this.put("IN", "India");
        }
    };

    @Override
    public String getCountryCodeForPoint(String lat, String lon) {
        OGRFeatureDao ogrFeatureDao = new OGRFeatureDao();
        List<OGRFeature> ogrList = ogrFeatureDao.listByExtentAndType(Double.parseDouble(lon), Double.parseDouble(lat), OGRFeature.FeatureType.COUNTRY, "x1", "asc", "all");
        String countryCode = null;
        for (OGRFeature item : ogrList) {
            Geometry geo = item.getGeometry();
            GeometryFactory geometryFactory = new GeometryFactory();
            WKTReader reader = new WKTReader(geometryFactory);
            Polygon shape = null;
            if (geo != null && geo.getType() != null) {
                try {
                    if (geo.getType().equals((Object)Geometry.GeometryType.POLYGON)) {
                        shape = (Polygon)reader.read(geo.getWktText());
                    } else if (geo.getType().equals((Object)Geometry.GeometryType.MULITPOLYGON)) {
                        shape = (MultiPolygon)reader.read(geo.getWktText());
                    }
                }
                catch (ParseException e) {
                    log.log(Level.SEVERE, e.getMessage());
                }
                Coordinate coord = new Coordinate(Double.parseDouble(lon), Double.parseDouble(lat));
                Point point = geometryFactory.createPoint(coord);
                if (shape == null || !shape.contains((com.vividsolutions.jts.geom.Geometry)point)) continue;
                countryCode = item.getCountryCode();
                break;
            }
            log.log(Level.INFO, item.getCountryCode() + " has a null geometry");
        }
        return countryCode;
    }

    @Override
    public GeoPlace findGeoPlace(String lat, String lon) {
        GeoPlaces places = this.parseXml(this.callApi(PLACE_SERVICE_URL, lat, lon, false));
        if (places != null && places.getGeoname() != null) {
            return places.getGeoname().get(0);
        }
        return this.manualLookup(lat, lon);
    }

    private String callApi(String base, String lat, String lon, boolean retry) {
        String result = null;
        try {
            result = this.invokeApi(base, lat, lon);
        }
        catch (IOException ie) {
            log.log(Level.WARNING, "Timeout for " + base, ie);
            if (retry) {
                try {
                    result = this.invokeApi(base, lat, lon);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Could not invoke geonames api via url " + base, e);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not invoke geonames api via url " + base, e);
        }
        return result;
    }

    private String invokeApi(String base, String lat, String lon) throws IOException, Exception {
        URL url = new URL(base + LAT_PARAM + "=" + lat + "&" + LON_PARAM + "=" + lon);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = null;
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        reader.close();
        return builder.toString();
    }

    private GeoPlaces parseXml(String xmlString) {
        GeoPlaces places = null;
        if (xmlString != null) {
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{GeoPlaces.class, GeoPlace.class});
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                StringReader sr = new StringReader(xmlString);
                places = (GeoPlaces)unmarshaller.unmarshal((Reader)sr);
            }
            catch (JAXBException e) {
                log.log(Level.SEVERE, "Could not parse api response", e);
            }
        } else {
            log.log(Level.SEVERE, "Geonames response xml was null");
        }
        return places;
    }

    private GeoPlace primitiveLookup(String latStr, String lonStr) {
        GeoPlace place;
        block4: {
            place = null;
            try {
                if (latStr != null && lonStr != null) {
                    double lat = Double.parseDouble(latStr);
                    double lon = Double.parseDouble(lonStr);
                    for (Map.Entry<String, Double[]> entry : this.COUNTRY_MBR.entrySet()) {
                        if (!(lat <= entry.getValue()[0]) || !(lat >= entry.getValue()[2]) || !(lon >= entry.getValue()[1]) || !(lon <= entry.getValue()[3])) continue;
                        place = new GeoPlace();
                        place.setCountryCode(entry.getKey());
                        place.setCountryName(this.COUNTRY_NAME.get(entry.getKey()));
                        break block4;
                    }
                    break block4;
                }
                log.log(Level.SEVERE, "Lat or lon is null");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Lat/Lon are non numeric: ", e);
            }
        }
        return place;
    }

    public GeoPlace manualLookup(String latStr, String lonStr) {
        return this.manualLookup(latStr, lonStr, OGRFeature.FeatureType.COUNTRY);
    }

    public GeoPlace manualLookup(String latStr, String lonStr, OGRFeature.FeatureType type) {
        log.log(Level.INFO, "Inside Manaual Lookup for " + latStr + ":" + lonStr + ":" + type.toString());
        GeoPlace place = null;
        OGRFeatureDao ogrFeatureDao = new OGRFeatureDao();
        List<OGRFeature> ogrList = ogrFeatureDao.listByExtentAndType(Double.parseDouble(lonStr), Double.parseDouble(latStr), type, "x1", "asc", "all");
        String countryCode = null;
        for (OGRFeature item : ogrList) {
            Geometry geo = item.getGeometry();
            GeometryFactory geometryFactory = new GeometryFactory();
            WKTReader reader = new WKTReader(geometryFactory);
            Polygon shape = null;
            if (geo != null && geo.getType() != null) {
                try {
                    if (geo.getType().equals((Object)Geometry.GeometryType.POLYGON)) {
                        shape = (Polygon)reader.read(geo.getWktText());
                    } else if (geo.getType().equals((Object)Geometry.GeometryType.MULITPOLYGON)) {
                        shape = (MultiPolygon)reader.read(geo.getWktText());
                    }
                }
                catch (ParseException e) {
                    log.log(Level.SEVERE, e.getMessage());
                }
                Coordinate coord = new Coordinate(Double.parseDouble(lonStr), Double.parseDouble(latStr));
                Point point = geometryFactory.createPoint(coord);
                Boolean containsFlag = false;
                if (shape == null) continue;
                for (int i = 0; i < shape.getNumGeometries(); ++i) {
                    if (!shape.getGeometryN(i).contains((com.vividsolutions.jts.geom.Geometry)point)) continue;
                    containsFlag = true;
                }
                if (!containsFlag.booleanValue()) continue;
                place = new GeoPlace();
                countryCode = item.getCountryCode();
                if (countryCode != null) {
                    place.setCountryCode(countryCode);
                    place.setCountryName(item.getName());
                }
                place.setSub1(item.getSub1());
                place.setSub2(item.getSub2());
                place.setSub3(item.getSub3());
                place.setSub4(item.getSub4());
                place.setSub5(item.getSub5());
                place.setSub6(item.getSub6());
                log.log(Level.INFO, "Found point inside " + item.getCountryCode() + " " + item.toString());
                continue;
            }
            log.log(Level.INFO, item.getCountryCode() + " has a null geometry");
        }
        if (place == null && type.equals((Object)OGRFeature.FeatureType.SUB_COUNTRY_OTHER)) {
            place = this.manualLookup(latStr, lonStr, OGRFeature.FeatureType.COUNTRY);
        }
        if (place == null) {
            place = this.primitiveLookup(latStr, lonStr);
        }
        return place;
    }

    public GeoPlace resolveSubCountry(String latStr, String lonStr, String countryCode) {
        GeoPlace place = null;
        if (countryCode != null && latStr != null && lonStr != null) {
            OGRFeatureDao ogrFeatureDao = new OGRFeatureDao();
            List<OGRFeature> ogrList = ogrFeatureDao.listByExtentTypeCountry(Double.parseDouble(lonStr), Double.parseDouble(latStr), countryCode, "x1", "asc", "all");
            for (OGRFeature item : ogrList) {
                Geometry geo = item.getGeometry();
                GeometryFactory geometryFactory = new GeometryFactory();
                WKTReader reader = new WKTReader(geometryFactory);
                Polygon shape = null;
                if (geo != null && geo.getType() != null) {
                    try {
                        if (geo.getType().equals((Object)Geometry.GeometryType.POLYGON)) {
                            shape = (Polygon)reader.read(geo.getWktText());
                        } else if (geo.getType().equals((Object)Geometry.GeometryType.MULITPOLYGON)) {
                            shape = (MultiPolygon)reader.read(geo.getWktText());
                        }
                    }
                    catch (ParseException e) {
                        log.log(Level.SEVERE, e.getMessage());
                    }
                    Coordinate coord = new Coordinate(Double.parseDouble(lonStr), Double.parseDouble(latStr));
                    Point point = geometryFactory.createPoint(coord);
                    if (shape == null || !shape.contains((com.vividsolutions.jts.geom.Geometry)point)) continue;
                    place = new GeoPlace();
                    countryCode = item.getCountryCode();
                    place.setCountryCode(countryCode);
                    place.setCountryName(item.getName());
                    place.setSub1(item.getSub1());
                    place.setSub2(item.getSub2());
                    place.setSub3(item.getSub3());
                    place.setSub4(item.getSub4());
                    place.setSub5(item.getSub5());
                    place.setSub6(item.getSub6());
                    log.log(Level.INFO, "Found point inside " + item.getCountryCode() + " " + item.toString());
                    continue;
                }
                log.log(Level.INFO, item.getCountryCode() + " has a null geometry");
            }
        }
        return place;
    }

    @Override
    public GeoPlace findDetailedGeoPlace(String lat, String lon) {
        GeoPlace gp = this.manualLookup(lat, lon, OGRFeature.FeatureType.SUB_COUNTRY_OTHER);
        if (gp == null) {
            gp = this.manualLookup(lat, lon);
        }
        if (gp == null) {
            gp = this.findGeoPlace(lat, lon);
        }
        return gp;
    }
}

