/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.framework.dao;

import com.gallatinsystems.framework.domain.BaseDomain;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.user.dao.UserAuthorizationDAO;
import com.gallatinsystems.user.dao.UserDao;
import com.gallatinsystems.user.domain.User;
import com.gallatinsystems.user.domain.UserAuthorization;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.datanucleus.query.JDOCursorHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import net.sf.jsr107cache.CacheException;
import org.akvo.flow.domain.SecuredObject;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class BaseDAO<T extends BaseDomain> {
    public static final int DEFAULT_RESULT_COUNT = 20;
    protected static final int RETRY_INTERVAL_MILLIS = 200;
    protected static final String STRING_TYPE = "String";
    protected static final String NOT_EQ_OP = "!=";
    protected static final String EQ_OP = " == ";
    protected static final String GTE_OP = " >= ";
    protected static final String LTE_OP = " <= ";
    protected static final String LT_OP = "<";
    private static final int MAX_ALLOWED_FILTERED_ITEMS = 30;
    private Class<T> concreteClass;
    protected Logger log;

    public BaseDAO(Class<T> e) {
        this.setDomainClass(e);
        this.log = Logger.getLogger(this.getClass().getName());
    }

    public void setDomainClass(Class<T> e) {
        this.concreteClass = e;
    }

    public <E extends BaseDomain> E save(E obj) {
        Object credentials;
        PersistenceManager pm = PersistenceFilter.getManager();
        Long who = 0L;
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && (credentials = SecurityContextHolder.getContext().getAuthentication().getCredentials()) instanceof Long) {
            who = (Long)credentials;
        }
        obj.setLastUpdateDateTime(new Date());
        obj.setLastUpdateUserId(who);
        if (obj.getCreatedDateTime() == null) {
            obj.setCreatedDateTime(obj.getLastUpdateDateTime());
            obj.setCreateUserId(who);
        }
        obj = (BaseDomain)pm.makePersistent(obj);
        return obj;
    }

    public <E extends BaseDomain> Collection<E> save(Collection<E> objList) {
        if (objList != null) {
            Object credentials;
            Long who = 0L;
            if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && (credentials = SecurityContextHolder.getContext().getAuthentication().getCredentials()) instanceof Long) {
                who = (Long)credentials;
            }
            for (BaseDomain item : objList) {
                item.setLastUpdateDateTime(new Date());
                item.setLastUpdateUserId(who);
                if (item.getCreatedDateTime() != null) continue;
                item.setCreatedDateTime(item.getLastUpdateDateTime());
                item.setCreateUserId(who);
            }
            PersistenceManager pm = PersistenceFilter.getManager();
            objList = pm.makePersistentAll(objList);
        }
        return objList;
    }

    public T getByKey(String keyString) {
        return this.getByKey(keyString, this.concreteClass);
    }

    public T getByKey(Key key) {
        return this.getByKey(key, this.concreteClass);
    }

    public <E extends BaseDomain> E getByKey(String keyString, Class<E> clazz) {
        PersistenceManager pm = PersistenceFilter.getManager();
        BaseDomain result = null;
        Key k = KeyFactory.stringToKey((String)keyString);
        try {
            result = (BaseDomain)pm.getObjectById(clazz, (Object)k);
        }
        catch (JDOObjectNotFoundException nfe) {
            this.log.warning("No " + clazz.getCanonicalName() + " found with key: " + k);
        }
        return (E)result;
    }

    public <E extends BaseDomain> E getByKey(Key key, Class<E> clazz) {
        PersistenceManager pm = PersistenceFilter.getManager();
        BaseDomain result = null;
        try {
            result = (BaseDomain)pm.getObjectById(clazz, (Object)key);
        }
        catch (JDOObjectNotFoundException nfe) {
            this.log.warning("No " + clazz.getCanonicalName() + " found with key: " + key);
        }
        return (E)result;
    }

    public T getByKey(Long id) {
        return this.getByKey(id, this.concreteClass);
    }

    public <E extends BaseDomain> E getByKey(Long id, Class<E> clazz) {
        PersistenceManager pm = PersistenceFilter.getManager();
        String itemKey = KeyFactory.createKeyString((String)clazz.getSimpleName(), (long)id);
        BaseDomain result = null;
        try {
            result = (BaseDomain)pm.getObjectById(clazz, (Object)itemKey);
        }
        catch (JDOObjectNotFoundException nfe) {
            this.log.warning("No " + clazz.getCanonicalName() + " found with id: " + id);
        }
        return (E)result;
    }

    public List<T> list(String cursorString, Integer pageSize) {
        return this.list(this.concreteClass, cursorString, pageSize);
    }

    public List<T> list(String cursorString) {
        return this.list(this.concreteClass, cursorString);
    }

    public <E extends BaseDomain> List<E> list(Class<E> c, String cursorString) {
        return this.list(c, cursorString, null);
    }

    public <E extends BaseDomain> List<E> list(Class<E> c, String cursorString, Integer pageSize) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query query = pm.newQuery(c);
        if (cursorString != null && !cursorString.trim().toLowerCase().equals("all")) {
            Cursor cursor = Cursor.fromWebSafeString((String)cursorString);
            HashMap<String, Cursor> extensionMap = new HashMap<String, Cursor>();
            extensionMap.put("gae.query.cursor", cursor);
            query.setExtensions(extensionMap);
        }
        List results = null;
        if (pageSize == null) {
            this.prepareCursor(cursorString, query);
        } else {
            this.prepareCursor(cursorString, pageSize, query);
        }
        results = (List)query.execute();
        return results;
    }

    public <E extends BaseDomain> List<E> filterByUserAuthorizationObjectId(List<E> allObjectsList, Long userId) {
        if (!this.concreteClass.isAssignableFrom(SurveyGroup.class) && !this.concreteClass.isAssignableFrom(Survey.class)) {
            throw new UnsupportedOperationException("Cannot filter " + this.concreteClass.getSimpleName());
        }
        UserDao userDAO = new UserDao();
        User user = (User)userDAO.getByKey(userId);
        if (user.isSuperAdmin().booleanValue()) {
            return allObjectsList;
        }
        UserAuthorizationDAO userAuthorizationDAO = new UserAuthorizationDAO();
        List<UserAuthorization> userAuthorizationList = userAuthorizationDAO.listByUser(userId);
        if (userAuthorizationList.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Long> securedObjectIds = new HashSet<Long>();
        for (UserAuthorization userAuthorization : userAuthorizationList) {
            if (userAuthorization.getSecuredObjectId() == null) continue;
            securedObjectIds.add(userAuthorization.getSecuredObjectId());
        }
        HashSet<Long> securedAncestorIds = new HashSet<Long>();
        for (Object obj : allObjectsList) {
            SecuredObject securedObject = (SecuredObject)obj;
            if (!securedObjectIds.contains(securedObject.getObjectId())) continue;
            securedAncestorIds.addAll(securedObject.listAncestorIds());
        }
        HashSet<BaseDomain> hashSet = new HashSet<BaseDomain>();
        if (this.concreteClass.isAssignableFrom(SurveyGroup.class)) {
            for (BaseDomain obj : allObjectsList) {
                SurveyGroup sg = (SurveyGroup)obj;
                Long sgId = sg.getKey().getId();
                if (!this.hasAuthorizedAncestors(sg.getAncestorIds(), securedObjectIds) && !securedObjectIds.contains(sgId) && !securedAncestorIds.contains(sgId)) continue;
                hashSet.add(obj);
            }
        } else {
            for (BaseDomain obj : allObjectsList) {
                Survey s = (Survey)obj;
                List<Long> ancestorIds = s.getAncestorIds();
                if (!this.hasAuthorizedAncestors(ancestorIds, securedObjectIds)) continue;
                hashSet.add(obj);
            }
        }
        ArrayList<BaseDomain> authorizedList = new ArrayList<BaseDomain>();
        authorizedList.addAll(hashSet);
        return authorizedList;
    }

    public <E extends BaseDomain> List<E> filterByUserAuthorizationObjectId(List<E> allObjectsList) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Long userId = (Long)authentication.getCredentials();
        return this.filterByUserAuthorizationObjectId(allObjectsList, userId);
    }

    private boolean hasAuthorizedAncestors(List<Long> ancestorIds, Set<Long> securedObjectIds) {
        ArrayList<Long> idsList = new ArrayList<Long>(ancestorIds);
        return idsList != null && idsList.removeAll(securedObjectIds);
    }

    protected T findByProperty(String propertyName, Object propertyValue, String propertyType) {
        BaseDomain result = null;
        List<T> results = this.listByProperty(propertyName, propertyValue, propertyType);
        if (results.size() > 0) {
            result = (BaseDomain)results.get(0);
        }
        return (T)result;
    }

    public List<T> listByKeys(Long[] ids) {
        if (ids == null) {
            return null;
        }
        return this.listByKeys(Arrays.asList(ids));
    }

    public List<T> listByKeys(List<Long> ids) {
        return this.listByKeys(ids, this.concreteClass);
    }

    public List<T> listByKeys(List<Long> idsList, Class<T> clazz) {
        if (idsList == null || idsList.isEmpty()) {
            return Collections.emptyList();
        }
        PersistenceManager pm = PersistenceFilter.getManager();
        ArrayList<Object> datastoreKeysList = new ArrayList<Object>();
        for (Long id : idsList) {
            Key key = KeyFactory.createKey((String)clazz.getSimpleName(), (long)id);
            Object objectId = pm.newObjectIdInstance(clazz, (Object)key);
            datastoreKeysList.add(objectId);
        }
        ArrayList resultsList = new ArrayList();
        try {
            resultsList.addAll(pm.getObjectsById(datastoreKeysList));
        }
        catch (NucleusObjectNotFoundException nfe) {
            this.log.warning(nfe.getMessage());
            return this.listByKeysIndividually(idsList);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            this.log.warning("Some entities were not found");
            return this.listByKeysIndividually(idsList);
        }
        return resultsList;
    }

    private List<T> listByKeysIndividually(List<Long> idsList) {
        ArrayList<T> resultsList = new ArrayList<T>();
        for (Long id : idsList) {
            T item = this.getByKey(id);
            if (item == null) continue;
            resultsList.add(item);
        }
        return resultsList;
    }

    protected List<T> listByProperty(String propertyName, Object propertyValue, String propertyType) {
        return this.listByProperty(propertyName, propertyValue, propertyType, null, null, EQ_OP, this.concreteClass);
    }

    protected <E extends BaseDomain> List<E> listByProperty(String propertyName, Object propertyValue, String propertyType, Class<E> clazz) {
        return this.listByProperty(propertyName, propertyValue, propertyType, null, null, EQ_OP, clazz);
    }

    protected <E extends BaseDomain> List<E> listByProperty(String propertyName, Object propertyValue, String propertyType, String orderBy, Class<E> clazz) {
        return this.listByProperty(propertyName, propertyValue, propertyType, orderBy, null, EQ_OP, clazz);
    }

    protected List<T> listByProperty(String propertyName, Object propertyValue, String propertyType, String orderByCol, String orderByDir) {
        return this.listByProperty(propertyName, propertyValue, propertyType, orderByCol, orderByDir, EQ_OP, this.concreteClass);
    }

    protected List<T> listByProperty(String propertyName, Object propertyValue, String propertyType, String orderByCol) {
        return this.listByProperty(propertyName, propertyValue, propertyType, orderByCol, null, EQ_OP, this.concreteClass);
    }

    protected <E extends BaseDomain> List<E> listByProperty(String propertyName, Object propertyValue, String propertyType, String orderByField, String orderByDir, String operator, Class<E> clazz) {
        PersistenceManager pm = PersistenceFilter.getManager();
        List results = null;
        String paramName = propertyName + "Param";
        if (paramName.contains(".")) {
            paramName = paramName.substring(paramName.indexOf(".") + 1);
        }
        javax.jdo.Query query = pm.newQuery(clazz);
        query.setFilter(propertyName + " " + operator + " " + paramName);
        if (orderByField != null) {
            query.setOrdering(orderByField + (orderByDir != null ? " " + orderByDir : ""));
        }
        query.declareParameters(propertyType + " " + paramName);
        if (propertyValue instanceof Date) {
            query.declareImports("import java.util.Date");
        }
        results = (List)query.execute(propertyValue);
        return results;
    }

    public <E extends BaseDomain> void delete(E obj) {
        PersistenceManager pm = PersistenceFilter.getManager();
        pm.deletePersistent(obj);
    }

    public <E extends BaseDomain> void delete(Collection<E> obj) {
        PersistenceManager pm = PersistenceFilter.getManager();
        pm.deletePersistentAll(obj);
    }

    public <E extends BaseDomain> void deleteByKey(Key k) {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        datastore.delete(new Key[]{k});
    }

    public <E extends BaseDomain> void deleteByKeys(Collection<Key> kList) {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        datastore.delete(kList);
    }

    protected void appendNonNullParam(String paramName, StringBuilder filter, StringBuilder param, String type, Object value, Map<String, Object> paramMap) {
        this.appendNonNullParam(paramName, filter, param, type, value, paramMap, EQ_OP);
    }

    protected void appendNonNullParam(String paramName, StringBuilder filter, StringBuilder param, String type, Object value, Map<String, Object> paramMap, String operator) {
        if (value != null) {
            if (paramMap.keySet().size() > 0) {
                filter.append(" && ");
                param.append(", ");
            }
            String paramValName = paramName + "Param" + paramMap.keySet().size();
            filter.append(paramName).append(" ").append(operator).append(" ").append(paramValName);
            param.append(type).append(" ").append(paramValName);
            paramMap.put(paramValName, value);
        }
    }

    public static String getCursor(List results) {
        if (results != null && results.size() > 0) {
            Cursor cursor = JDOCursorHelper.getCursor((List)results);
            if (cursor != null) {
                return cursor.toWebSafeString();
            }
            return null;
        }
        return null;
    }

    protected void prepareCursor(String cursorString, Integer pageSize, javax.jdo.Query query) {
        if (cursorString != null && !cursorString.trim().toLowerCase().equals("all")) {
            Cursor cursor = Cursor.fromWebSafeString((String)cursorString);
            HashMap<String, Cursor> extensionMap = new HashMap<String, Cursor>();
            extensionMap.put("gae.query.cursor", cursor);
            query.setExtensions(extensionMap);
        }
        if (cursorString == null || !cursorString.equals("all")) {
            if (pageSize == null) {
                query.setRange(0L, 20L);
            } else {
                query.setRange(0L, (long)pageSize.intValue());
            }
        }
    }

    public void flushBatch() {
        PersistenceManager pm = PersistenceFilter.getManager();
        pm.flush();
    }

    protected void prepareCursor(String cursorString, javax.jdo.Query query) {
        this.prepareCursor(cursorString, 20, query);
    }

    protected static void sleep() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getCacheKey(BaseDomain object) throws CacheException {
        if (object.getKey() == null) {
            throw new CacheException("Trying to get cache key from an unsaved object");
        }
        return object.getClass().getSimpleName() + "-" + object.getKey().getId();
    }

    public String getCacheKey(String objectId) throws CacheException {
        if (objectId == null) {
            throw new CacheException("Trying to get cache key from an unsaved object");
        }
        return this.concreteClass.getSimpleName() + "-" + objectId;
    }

    public List<T> fetchItemsByIdBatches(List<Long> idsList, String fieldName) {
        if (idsList == null || idsList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> fetchedItems = new ArrayList<T>();
        int idsListSize = idsList.size();
        int start = 0;
        int end = Math.min(30, idsListSize);
        int numberOfQueryRounds = (int)Math.ceil((double)idsListSize / 30.0);
        for (int i = 0; i < numberOfQueryRounds; ++i) {
            List<Long> idsToRetrieve = idsList.subList(start, end);
            fetchedItems.addAll(this.listValuesByIdsList(idsToRetrieve, fieldName));
            start = end;
            end = Math.min(end + 30, idsListSize);
        }
        return fetchedItems;
    }

    private List<T> listValuesByIdsList(List<Long> idsList, String fieldName) {
        if (idsList == null || idsList.isEmpty()) {
            return Collections.emptyList();
        }
        PersistenceManager pm = PersistenceFilter.getManager();
        String queryString = ":p1.contains(" + fieldName + ")";
        javax.jdo.Query query = pm.newQuery(this.concreteClass, queryString);
        List results = (List)query.execute(idsList);
        return results;
    }

    public long countFilteredByProperty(String property, Object value) {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        Query query = new Query(this.concreteClass.getSimpleName()).setKeysOnly();
        Query.FilterPredicate filter = new Query.FilterPredicate(property, Query.FilterOperator.EQUAL, value);
        query.setFilter((Query.Filter)filter);
        PreparedQuery preparedQuery = datastore.prepare(query);
        FetchOptions options = FetchOptions.Builder.withDefaults().prefetchSize(1000).chunkSize(1000);
        return preparedQuery.asList(options).size();
    }

    public static enum CURSOR_TYPE {
        all;

    }
}

