/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.framework.servlet;

import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.RetryOptions;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ExecuteRequestAsTaskFilter
implements Filter {
    private static Logger log = Logger.getLogger(ExecuteRequestAsTaskFilter.class.getName());
    private static final String RUN_AS_TASK_VALUE = "1";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (this.isQueuedTask(request) || !this.isTaskRequest(request)) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            this.addRequestToTaskQueue(new RequestToTaskMapper(request));
        }
    }

    public boolean isTaskRequest(HttpServletRequest request) {
        String runAsTaskParamValue = request.getParameter("runAsTask");
        return RUN_AS_TASK_VALUE.equals(runAsTaskParamValue);
    }

    public boolean isQueuedTask(HttpServletRequest request) {
        String isQueuedTaskHeaderValue = request.getHeader("X-Akvo-Queued-Task");
        return this.isTaskRequest(request) && RUN_AS_TASK_VALUE.equals(isQueuedTaskHeaderValue);
    }

    public void destroy() {
    }

    private void addRequestToTaskQueue(RequestToTaskMapper requestToTaskMapper) {
        Queue defaultQueue = QueueFactory.getDefaultQueue();
        defaultQueue.add(requestToTaskMapper.getTaskOptions());
    }

    class RequestToTaskMapper {
        private HttpServletRequest request;
        private TaskOptions taskOptions;

        public RequestToTaskMapper(HttpServletRequest req) {
            this.request = req;
            this.taskOptions = this.mapRequestToTaskOptions(this.request);
        }

        private TaskOptions mapRequestToTaskOptions(HttpServletRequest request) {
            TaskOptions options = TaskOptions.Builder.withDefaults();
            options.url(request.getRequestURI()).header("Content-Type", "application/x-www-form-urlencoded").header("X-Akvo-Queued-Task", ExecuteRequestAsTaskFilter.RUN_AS_TASK_VALUE).method(TaskOptions.Method.POST).retryOptions(RetryOptions.Builder.withTaskRetryLimit((int)5).minBackoffSeconds(5.0).maxBackoffSeconds(120.0).maxDoublings(5));
            Map paramMap = request.getParameterMap();
            for (Object k : paramMap.keySet()) {
                String key = (String)k;
                String[] paramValues = (String[])paramMap.get(key);
                for (int i = 0; i < paramValues.length; ++i) {
                    options.param(key, paramValues[i]);
                }
            }
            log.log(Level.FINE, "Query params: " + options.getStringParams());
            return options;
        }

        public TaskOptions getTaskOptions() {
            return this.taskOptions;
        }
    }
}

