/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.gis.coordinate.utilities;

import com.gallatinsystems.gis.coordinate.utilities.Coordinate;

public class CoordinateUtilities {
    static final Double polarAxis = 6356752.314;
    static final Integer equRad = 6378137;
    static final Double ecc = 0.081819191;
    static final Double e2 = 0.006739497;
    static final Double k0 = 0.9996;
    static final Double pi = Math.PI;
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    public static final double EARTH_RADIUS = 6371.0;

    public static void main(String[] args) {
        Integer x = Integer.parseInt(args[0]);
        Integer y = Integer.parseInt(args[1]);
        Integer zone = Integer.parseInt(args[2]);
        System.out.println("Converted Coordiantes: " + CoordinateUtilities.convertUTMtoLatLon(x, y, NSLatitude.SOUTH, zone));
    }

    public static Double computeDistance(Double startLat, Double startLon, Double endLat, Double endLon) {
        Double distance = null;
        double p1 = Math.cos(startLat) * Math.cos(startLon) * Math.cos(endLat) * Math.cos(endLat);
        double p2 = Math.cos(startLat) * Math.sin(startLon) * Math.cos(endLat) * Math.sin(endLon);
        double p3 = Math.sin(startLat) * Math.sin(endLat);
        distance = Math.acos(p1 + p2 + p3) * 6371.0;
        distance = distance * 1000.0;
        return distance;
    }

    public Coordinate computePointAlongBearingDistance(Coordinate startingPoint, Double distance, Double bearing) {
        Double lat1 = startingPoint.getLatitude() * (Math.PI / 180);
        Double lon1 = startingPoint.getLongitude() * (Math.PI / 180);
        bearing = bearing * (Math.PI / 180);
        Double lat2 = Math.asin(Math.sin(lat1) * Math.cos(distance / 6371.0) + Math.cos(lat1) * Math.sin(distance / 6371.0) * Math.cos(bearing));
        Double lon2 = lon1 + Math.atan2(Math.sin(bearing) * Math.sin(distance / 6371.0) * Math.cos(lat1), Math.cos(distance / 6371.0) - Math.sin(lat1) * Math.sin(lat2));
        lon2 = (lon2 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        lat2 = lat2 / (Math.PI / 180);
        lon2 = lon2 / (Math.PI / 180);
        Coordinate newPoint = new Coordinate(lat2, lon2);
        return newPoint;
    }

    public static Double computeDistanceInMiles(Double lat1, Double lon1, Double lat2, Double lon2) {
        double x = 69.1 * (lat2 - lat1);
        double y = 53.0 * (lon2 - lon1) * Math.cos(lat1 / 57.3);
        return Math.sqrt(x * x + y * y);
    }

    public String convertDecimalToDegrees(Double lat, Double lon) {
        String degrees = null;
        Long latDecimal = 0L;
        Long lonDecimal = 0L;
        latDecimal = lat.longValue();
        Double degreesLat = (lat - (double)latDecimal.longValue()) * 60.0;
        lonDecimal = lon.longValue();
        Double degreesLon = (lon - (double)lonDecimal.longValue()) * 60.0;
        degrees = "lat: " + latDecimal + " degrees " + degreesLat;
        degrees = degrees + "lon: " + lonDecimal + " degrees " + degreesLon;
        return degrees;
    }

    public static String convertUTMtoLatLon(Integer eastingCoor, Integer northingCoor, NSLatitude lat, Integer zone) {
        Integer zoneCentralLongitude = CoordinateUtilities.computeZoneCentralLongitude(zone);
        Double arcLength = (double)(10000000 - northingCoor) / k0;
        Double a1 = Math.pow(ecc, 2.0) / 4.0;
        Double a2 = 3.0 * (Math.pow(ecc, 4.0) / 64.0);
        Double a3 = 5.0 * (Math.pow(ecc, 6.0) / 256.0);
        Double a = 1.0 - a1 - a2 - a3;
        Double mu = arcLength / ((double)equRad.intValue() * a);
        Double a4 = Math.sqrt(1.0 - Math.pow(ecc, 2.0));
        Double e1 = (1.0 - a4) / (1.0 + a4);
        Double c1 = 3.0 * e1 / 2.0 - 27.0 * Math.pow(e1, 3.0) / 32.0;
        Double c2 = 21.0 * Math.pow(e1, 2.0) / 16.0 - 55.0 * Math.pow(e1, 4.0) / 32.0;
        Double c3 = 151.0 * Math.pow(e1, 3.0) / 96.0;
        Double c4 = 1097.0 * Math.pow(e1, 4.0) / 512.0;
        Double footprintLat = mu + c1 * Math.sin(2.0 * mu) + c2 * Math.sin(4.0 * mu) + c3 * Math.sin(6.0 * mu) + c4 * Math.sin(8.0 * mu);
        Double C1 = e2 * Math.pow(Math.cos(footprintLat), 2.0);
        Double T1 = Math.pow(Math.tan(footprintLat), 2.0);
        Double N1 = (double)equRad.intValue() / Math.sqrt(1.0 - Math.pow(ecc * Math.sin(footprintLat), 2.0));
        Double R1 = (double)equRad.intValue() * (1.0 - Math.pow(ecc, 2.0)) / Math.pow(1.0 - Math.pow(ecc * Math.sin(footprintLat), 2.0), 1.0);
        Double D = (double)(500000 - eastingCoor) / (N1 * k0);
        Double fact1 = N1 * Math.tan(footprintLat) / R1;
        Double fact2 = Math.pow(D, 2.0) / 2.0;
        Double fact3 = (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * Math.pow(C1, 2.0) - 9.0 * e2) * Math.pow(D, 4.0) / 24.0;
        Double fact4 = (61.0 + 90.0 * T1 + 298.0 * e2 + 45.0 * Math.pow(T1, 2.0) - 252.0 * e2 - 3.0 * Math.pow(C1, 2.0)) * Math.pow(D, 6.0) / 720.0;
        Double latitude = 180.0 * (footprintLat - fact1 * (fact2 + fact3 + fact4)) / pi;
        latitude = latitude * -1.0;
        Double Q5 = D;
        Double Q6 = (1.0 + 2.0 * T1 + C1) * Math.pow(D, 3.0) / 6.0;
        Double Q7 = (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * Math.pow(C1, 2.0) + 8.0 * e2 + 24.0 * Math.pow(T1, 2.0)) * Math.pow(D, 5.0) / 120.0;
        Double H20 = Q5 - Q6 + Q7 / Math.cos(footprintLat);
        Double E22 = H20 * 180.0 / pi;
        Double longitude = (double)zoneCentralLongitude.intValue() - E22;
        return latitude + ", " + longitude;
    }

    private static Integer computeZoneCentralLongitude(Integer zone) {
        Integer zcl = 0;
        if (zone > 0) {
            zcl = 6 * zone - 183;
        }
        return zcl;
    }

    public static enum NSLatitude {
        NORTH,
        SOUTH;

    }
}

