/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.surveyal.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class SurveyedLocaleDao
extends BaseDAO<SurveyedLocale> {
    public SurveyedLocaleDao() {
        super(SurveyedLocale.class);
    }

    public List<SurveyedLocale> listLocalesByCoordinates(String pointType, double lat, double lon, double tolerance) {
        return this.listLocalesByCoordinates(pointType, lat - tolerance, lon - tolerance, lat + tolerance, lon + tolerance, BaseDAO.CURSOR_TYPE.all.toString(), null);
    }

    public List<SurveyedLocale> listLocalesByGeocell(Long surveyId, List<String> geocells, int pageSize) {
        PersistenceManager pm = PersistenceFilter.getManager();
        String queryString = "surveyGroupId == :p1 && :p2.contains(geocells)";
        Query query = pm.newQuery(SurveyedLocale.class, queryString);
        this.prepareCursor(null, pageSize, query);
        List results = (List)query.execute((Object)surveyId, geocells);
        return results;
    }

    public List<SurveyedLocale> listAll(String cursor, Integer pageSize) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(SurveyedLocale.class);
        this.prepareCursor(cursor, pageSize, query);
        List results = (List)query.execute();
        return results;
    }

    public List<SurveyedLocale> listLocalesByCoordinates(String pointType, Double lat1, Double lon1, Double lat2, Double lon2, String cursor, Integer pageSize) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(SurveyedLocale.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("localeType", filterString, paramString, "String", pointType, paramMap);
        this.appendNonNullParam("latitude", filterString, paramString, "Double", lat1, paramMap, " >= ");
        this.appendNonNullParam("latitude", filterString, paramString, "Double", lat2, paramMap, " <= ");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursor, pageSize, query);
        List candidates = (List)query.executeWithMap(paramMap);
        ArrayList<SurveyedLocale> results = new ArrayList<SurveyedLocale>();
        if (candidates != null) {
            for (SurveyedLocale l : candidates) {
                if (!(l.getLongitude() > lon1) || !(l.getLongitude() < lon2)) continue;
                results.add(l);
            }
        }
        return results;
    }

    public List<SurveyedLocale> listBySubLevel(String countryCode, Integer level, String subValue, String type, String org, String cursor, Integer desiredResults) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(SurveyedLocale.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("localeType", filterString, paramString, "String", type, paramMap);
        this.appendNonNullParam("countryCode", filterString, paramString, "String", countryCode, paramMap);
        this.appendNonNullParam("organization", filterString, paramString, "String", org, paramMap);
        if (level != null && level > 0 && level <= 6) {
            this.appendNonNullParam("sublevel" + level, filterString, paramString, "String", subValue, paramMap);
        }
        query.setOrdering("createdDateTime desc");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursor, desiredResults, query);
        List results = (List)query.executeWithMap(paramMap);
        return results;
    }

    public List<SurveyedLocale> search(String country, Date collDateFrom, Date collDateTo, String type, String orderByField, String orderByDir, Integer pageSize, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(SurveyedLocale.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("countryCode", filterString, paramString, "String", country, paramMap);
        this.appendNonNullParam("localeType", filterString, paramString, "String", type, paramMap);
        this.appendNonNullParam("lastSurveyedDate", filterString, paramString, "Date", collDateFrom, paramMap, " >= ");
        this.appendNonNullParam("lastSurveyedDate", filterString, paramString, "Date", collDateTo, paramMap, " <= ");
        if (orderByField != null) {
            String ordering = orderByDir;
            if (ordering == null) {
                ordering = "asc";
            }
            query.setOrdering(orderByField + " " + ordering);
        }
        if (filterString.length() > 0) {
            query.setFilter(filterString.toString());
            query.declareParameters(paramString.toString());
        }
        this.prepareCursor(cursorString, pageSize, query);
        if (collDateFrom != null || collDateTo != null) {
            query.declareImports("import java.util.Date");
            if (orderByField != null && !orderByField.trim().equals("lastSurveyedDate")) {
                query.setOrdering("lastSurveyedDate " + (orderByDir != null ? orderByDir : "asc"));
            }
        }
        return (List)query.executeWithMap(paramMap);
    }

    public List<SurveyedLocale> listLocalesBySurveyGroupId(Long surveyGroupId) {
        List<SurveyedLocale> locales = this.listByProperty("surveyGroupId", surveyGroupId, "Long");
        return locales;
    }

    public List<SurveyedLocale> listSurveyedLocales(String cursor, Long surveyGroupId, String identifier, String displayName, String displayNamePrefix) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(SurveyedLocale.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("surveyGroupId", filterString, paramString, "Long", surveyGroupId, paramMap);
        this.appendNonNullParam("identifier", filterString, paramString, "String", identifier, paramMap);
        this.appendNonNullParam("displayName", filterString, paramString, "String", displayName, paramMap);
        if (displayNamePrefix != null && !"".equals(displayNamePrefix)) {
            String endString = displayNamePrefix + '\uffff';
            this.appendNonNullParam("displayName", filterString, paramString, "String", displayNamePrefix, paramMap, " >= ");
            this.appendNonNullParam("displayName", filterString, paramString, "String", endString, paramMap, "<");
            query.setOrdering("displayName asc");
        } else {
            query.setOrdering("lastUpdateDateTime desc");
        }
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        if (cursor != null && !"".equals(cursor)) {
            this.prepareCursor(cursor, query);
        }
        return (List)query.executeWithMap(paramMap);
    }

    public List<SurveyedLocale> listLocalesByDisplayName(String displayName) {
        List<SurveyedLocale> locales = this.listByProperty("displayName", displayName, "String");
        return locales;
    }

    public List<SurveyedLocale> listLocalesBySurveyGroupAndUpdateDate(Long surveyGroupId, Date lastUpdateTime, Integer pageSize) {
        return this.listLocalesBySurveyGroupAndUpdateDate(surveyGroupId, lastUpdateTime, null, pageSize);
    }

    public List<SurveyedLocale> listLocalesBySurveyGroupAndUpdateDate(Long surveyGroupId, Date lastUpdateTime, String cursor, Integer pageSize) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(SurveyedLocale.class);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        this.appendNonNullParam("surveyGroupId", filterString, paramString, "Long", surveyGroupId, paramMap);
        this.appendNonNullParam("lastUpdateDateTime", filterString, paramString, "Date", lastUpdateTime, paramMap, " >= ");
        query.setOrdering("lastUpdateDateTime asc");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        query.declareImports("import java.util.Date");
        this.prepareCursor(cursor, pageSize, query);
        return (List)query.executeWithMap(paramMap);
    }

    public SurveyedLocale getById(Long id) {
        SurveyedLocale sl = (SurveyedLocale)this.getByKey(id);
        return sl;
    }

    public SurveyedLocale getByIdentifier(String identifier) {
        return (SurveyedLocale)this.findByProperty("identifier", identifier, "String");
    }

    public List<SurveyedLocale> listLocalesByCreationSurvey(Long surveyId, String cursor, Integer pageSize) {
        PersistenceManager pm = PersistenceFilter.getManager();
        String queryString = "creationSurveyId == surveyIdParam";
        Query query = pm.newQuery(SurveyedLocale.class, queryString);
        query.declareParameters("Long surveyIdParam");
        this.prepareCursor(cursor, pageSize, query);
        List results = (List)query.execute((Object)surveyId);
        if (results != null && results.size() > 0) {
            return results;
        }
        return Collections.emptyList();
    }

    public void deleteSurveyedLocale(SurveyedLocale sl) {
        if (sl != null) {
            List<Object> siList = new ArrayList();
            SurveyInstanceDAO siDao = new SurveyInstanceDAO();
            siList = siDao.listInstancesByLocale(sl.getKey().getId(), null, null, null);
            ArrayList<Long> ids = new ArrayList<Long>();
            for (SurveyInstance surveyInstance : siList) {
                ids.add(surveyInstance.getSurveyId());
                siDao.deleteSurveyInstance(surveyInstance);
            }
            SurveyUtils.notifyReportService(ids, "invalidate");
        }
    }

    public long countBySurveyGroupId(long surveyGroupId) {
        return this.countFilteredByProperty("surveyGroupId", surveyGroupId);
    }
}

