/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.util;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectoryBase;
import com.drew.metadata.exif.GpsDirectory;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.akvo.flow.util.ExifTagInfo;
import org.springframework.web.multipart.MultipartFile;
import org.waterforpeople.mapping.domain.response.value.Location;

public class ExifTagExtractor {
    private static final Logger log = Logger.getLogger(ExifTagExtractor.class.getName());
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");

    public ExifTagInfo fetchExifTags(MultipartFile file) {
        try {
            Directory directory;
            InputStream s = file.getInputStream();
            Metadata metadata = JpegMetadataReader.readMetadata((InputStream)s);
            Directory directoryBase = metadata.getFirstDirectoryOfType(ExifDirectoryBase.class);
            Date parsedDate = null;
            if (directoryBase != null) {
                String timeStamp = directoryBase.getString(306);
                try {
                    parsedDate = this.dateFormat.parse(timeStamp);
                }
                catch (ParseException e) {
                    log.log(Level.WARNING, "Error parsing date", e);
                }
                log.finest("Timestamp: " + timeStamp);
            }
            if ((directory = metadata.getFirstDirectoryOfType(GpsDirectory.class)) == null) {
                log.warning("No gps directory data found");
                return new ExifTagInfo(parsedDate, null);
            }
            Double lat = this.getLatitude(directory);
            Double lon = this.getLongitude(directory);
            Double alt = this.getAltitude(directory);
            Float acc = this.getAccuracy(directory);
            Location location = null;
            if (lat != null && lon != null) {
                location = new Location();
                location.setLatitude(lat);
                location.setLongitude(lon);
                location.setAccuracy(acc.floatValue());
                location.setAltitude(alt);
            }
            return new ExifTagInfo(parsedDate, location);
        }
        catch (JpegProcessingException | IOException e) {
            log.log(Level.SEVERE, "Error extracting exif information", e);
            return null;
        }
    }

    private Double getLongitude(Directory directory) {
        Rational[] lonTag = directory.getRationalArray(4);
        if (lonTag != null) {
            String lonRefTag = directory.getString(3);
            double longitude = lonTag[0].doubleValue() + lonTag[1].doubleValue() / 60.0 + lonTag[2].doubleValue() / 3600.0;
            if (lonRefTag != null && lonRefTag.contentEquals("W")) {
                longitude = -longitude;
            }
            return longitude;
        }
        return null;
    }

    private Double getLatitude(Directory directory) {
        Rational[] latTag = directory.getRationalArray(2);
        if (latTag != null) {
            String latRefTag = directory.getString(1);
            double latitude = latTag[0].doubleValue() + latTag[1].doubleValue() / 60.0 + latTag[2].doubleValue() / 3600.0;
            if (latRefTag != null && latRefTag.contentEquals("S")) {
                latitude = -latitude;
            }
            return latitude;
        }
        return null;
    }

    private Float getAccuracy(Directory directory) {
        Rational[] accTag = directory.getRationalArray(31);
        float accuracy = accTag != null ? accTag[0].floatValue() : 0.0f;
        return Float.valueOf(accuracy);
    }

    private Double getAltitude(Directory directory) {
        Rational[] altTag = directory.getRationalArray(6);
        Integer altRefTag = directory.getInteger(5);
        double altitude = altTag != null ? altTag[0].doubleValue() : 0.0;
        if (altRefTag != null && altRefTag.equals(1)) {
            altitude = -altitude;
        }
        return altitude;
    }
}

