/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.survey.dao.DataPointApprovalDAO;
import com.gallatinsystems.survey.domain.DataPointApproval;
import com.gallatinsystems.user.domain.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.web.CurrentUserServlet;
import org.waterforpeople.mapping.app.web.dto.DataPointApprovalDTO;
import org.waterforpeople.mapping.app.web.rest.dto.DataPointApprovalPayload;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/data_point_approvals"})
public class DataPointApprovalRestService {
    private DataPointApprovalDAO dataPointApprovalDao = new DataPointApprovalDAO();

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> createDataPointApproval(@RequestBody DataPointApprovalPayload dataPointApprovalPayload) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto status = new RestStatusDto();
        DataPointApproval approval = dataPointApprovalPayload.getData_point_approval().getDataPointApproval();
        approval.setApprovalDate(new Date());
        User currentUser = CurrentUserServlet.getCurrentUser();
        approval.setApproverUserId(currentUser.getKey().getId());
        approval.setApproverUserName(currentUser.getEmailUserName());
        response.put("data_point_approval", new DataPointApprovalDTO(this.dataPointApprovalDao.save(approval)));
        response.put("meta", status);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Map<String, List<DataPointApprovalDTO>> listDataPointApprovals(@RequestParam(value="surveyedLocaleId[]", required=false) List<Long> surveyedLocaleIds, @RequestParam(value="surveyedLocaleId", required=false) Long surveyedLocaleId) {
        HashMap<String, List<DataPointApprovalDTO>> response = new HashMap<String, List<DataPointApprovalDTO>>();
        ArrayList<DataPointApproval> approvals = new ArrayList<DataPointApproval>();
        if (surveyedLocaleIds != null) {
            approvals.addAll(this.dataPointApprovalDao.listBySurveyedLocaleIds(surveyedLocaleIds));
        } else if (surveyedLocaleId != null) {
            approvals.addAll(this.dataPointApprovalDao.listBySurveyedLocaleId(surveyedLocaleId));
        }
        ArrayList<DataPointApprovalDTO> approvalsResponseList = new ArrayList<DataPointApprovalDTO>();
        for (DataPointApproval approval : approvals) {
            approvalsResponseList.add(new DataPointApprovalDTO(approval));
        }
        response.put("data_point_approvals", approvalsResponseList);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{dataPointApprovalId}"})
    @ResponseBody
    public Map<String, Object> updateDataPointApproval(@RequestBody DataPointApprovalPayload dataPointApprovalPayload, @PathVariable Long dataPointApprovalId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto status = new RestStatusDto();
        DataPointApproval updatedApproval = dataPointApprovalPayload.getData_point_approval().getDataPointApproval();
        DataPointApproval storedApproval = (DataPointApproval)this.dataPointApprovalDao.getByKey(dataPointApprovalId);
        if (storedApproval != null) {
            storedApproval.setApprovalDate(new Date());
            storedApproval.setStatus(updatedApproval.getStatus());
            storedApproval.setComment(updatedApproval.getComment());
            response.put("data_point_approval", new DataPointApprovalDTO(this.dataPointApprovalDao.save(storedApproval)));
        }
        response.put("meta", status);
        return response;
    }
}

