/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.survey.dao.QuestionOptionDao;
import com.gallatinsystems.survey.domain.QuestionOption;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionOptionDto;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.rest.dto.QuestionOptionPayload;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/question_options"})
public class QuestionOptionRestService {
    private QuestionOptionDao questionOptionDao = new QuestionOptionDao();

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, QuestionOptionDto> findQuestionOption(@PathVariable(value="id") Long id) {
        HashMap<String, QuestionOptionDto> response = new HashMap<String, QuestionOptionDto>();
        QuestionOption qo = (QuestionOption)this.questionOptionDao.getByKey(id);
        QuestionOptionDto dto = null;
        if (qo != null) {
            dto = new QuestionOptionDto();
            DtoMarshaller.copyToDto(qo, dto);
        }
        response.put("question_option", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteQuestionOptionById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        QuestionOption qo = (QuestionOption)this.questionOptionDao.getByKey(id);
        RestStatusDto statusDto = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (qo != null) {
            this.questionOptionDao.delete(qo);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingQuestionOption(@RequestBody QuestionOptionPayload payLoad) {
        QuestionOption qo;
        Long keyId;
        QuestionOptionDto questionOptionDto = payLoad.getQuestion_option();
        HashMap<String, Object> response = new HashMap<String, Object>();
        QuestionOptionDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (questionOptionDto != null && (keyId = questionOptionDto.getKeyId()) != null && (qo = (QuestionOption)this.questionOptionDao.getByKey(keyId)) != null) {
            BeanUtils.copyProperties((Object)questionOptionDto, (Object)qo);
            qo = this.questionOptionDao.save(qo);
            dto = new QuestionOptionDto();
            DtoMarshaller.copyToDto(qo, dto);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("question_option", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewQuestionOption(@RequestBody QuestionOptionPayload payLoad) {
        QuestionOptionDto questionOptionDto = payLoad.getQuestion_option();
        HashMap<String, Object> response = new HashMap<String, Object>();
        QuestionOptionDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (questionOptionDto != null) {
            QuestionOption qo = new QuestionOption();
            BeanUtils.copyProperties((Object)questionOptionDto, (Object)qo);
            qo = this.questionOptionDao.save(qo);
            dto = new QuestionOptionDto();
            DtoMarshaller.copyToDto(qo, dto);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("question_option", dto);
        return response;
    }
}

