/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.user.app.gwt.client.UserDto;
import com.gallatinsystems.user.dao.UserDao;
import com.gallatinsystems.user.domain.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.akvo.flow.rest.security.AppRole;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.web.CurrentUserServlet;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;
import org.waterforpeople.mapping.app.web.rest.dto.UserPayload;

@Controller
@RequestMapping(value={"/users"})
public class UserRestService {
    private UserDao userDao = new UserDao();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listUsers(@RequestParam(value="currUser", defaultValue="false") String returnOnlyCurrentUser) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<UserDto> results = new ArrayList<UserDto>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("");
        statusDto.setMessage("");
        response.put("users", results);
        response.put("meta", statusDto);
        User currentUser = CurrentUserServlet.getCurrentUser();
        if (!this.isSuperAdminRole(currentUser)) {
            UserDto currentUserDto = new UserDto();
            BeanUtils.copyProperties((Object)currentUser, (Object)currentUserDto, (String[])new String[]{"config"});
            if (currentUser.getKey() != null) {
                currentUserDto.setKeyId(currentUser.getKey().getId());
            }
            results.add(currentUserDto);
        }
        if ("true".equals(returnOnlyCurrentUser) || !this.isUserAdminRole(currentUser)) {
            return response;
        }
        List users = this.userDao.list("all");
        if (users != null) {
            for (User u : users) {
                if (u.getKey().equals((Object)currentUser.getKey()) || this.isSuperAdminRole(u)) continue;
                UserDto dto = new UserDto();
                BeanUtils.copyProperties((Object)u, (Object)dto, (String[])new String[]{"config"});
                if (u.getKey() != null) {
                    dto.setKeyId(u.getKey().getId());
                }
                results.add(dto);
            }
        }
        return response;
    }

    private boolean isUserAdminRole(User user) {
        return user.getPermissionList().equals(Integer.toString(AppRole.ROLE_ADMIN.getLevel())) || user.getPermissionList().equals(Integer.toString(AppRole.ROLE_SUPER_ADMIN.getLevel()));
    }

    private boolean isSuperAdminRole(User user) {
        return user.isSuperAdmin() != false || user.getPermissionList().equals(Integer.toString(AppRole.ROLE_SUPER_ADMIN.getLevel()));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, UserDto> findUser(@PathVariable(value="id") Long id) {
        HashMap<String, UserDto> response = new HashMap<String, UserDto>();
        User u = (User)this.userDao.getByKey(id);
        UserDto dto = null;
        if (u != null) {
            dto = new UserDto();
            BeanUtils.copyProperties((Object)u, (Object)dto, (String[])new String[]{"config"});
            if (u.getKey() != null) {
                dto.setKeyId(u.getKey().getId());
            }
        }
        response.put("user", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteUserById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        User u = (User)this.userDao.getByKey(id);
        RestStatusDto statusDto = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (u != null) {
            this.userDao.delete(u);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingUser(@RequestBody UserPayload payLoad) {
        User u;
        Long keyId;
        UserDto userDto = payLoad.getUser();
        HashMap<String, Object> response = new HashMap<String, Object>();
        UserDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (userDto != null && (keyId = userDto.getKeyId()) != null && (u = (User)this.userDao.getByKey(keyId)) != null) {
            BeanUtils.copyProperties((Object)userDto, (Object)u, (String[])new String[]{"createdDateTime", "config"});
            if (u.getPermissionList().equals(String.valueOf(AppRole.ROLE_SUPER_ADMIN.getLevel()))) {
                u.setPermissionList(String.valueOf(AppRole.ROLE_USER.getLevel()));
            }
            u = this.userDao.save(u);
            dto = new UserDto();
            BeanUtils.copyProperties((Object)u, (Object)dto, (String[])new String[]{"config"});
            if (u.getKey() != null) {
                dto.setKeyId(u.getKey().getId());
            }
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("user", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewUser(@RequestBody UserPayload payLoad) {
        UserDto userDto = payLoad.getUser();
        HashMap<String, Object> response = new HashMap<String, Object>();
        UserDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (userDto != null) {
            User u = new User();
            BeanUtils.copyProperties((Object)userDto, (Object)u, (String[])new String[]{"createdDateTime", "config"});
            if (u.getPermissionList().equals(String.valueOf(AppRole.ROLE_SUPER_ADMIN.getLevel()))) {
                u.setPermissionList(String.valueOf(AppRole.ROLE_USER.getLevel()));
            }
            u = this.userDao.save(u);
            dto = new UserDto();
            BeanUtils.copyProperties((Object)u, (Object)dto, (String[])new String[]{"config"});
            if (u.getKey() != null) {
                dto.setKeyId(u.getKey().getId());
            }
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("user", dto);
        return response;
    }
}

