/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.gis.geography.domain.Country;
import java.util.List;
import org.waterforpeople.mapping.domain.Community;

public class CommunityDao
extends BaseDAO<Community> {
    public CommunityDao() {
        super(Community.class);
    }

    public Community findCommunityByName(String name) {
        return (Community)this.findByProperty("name", name, "String");
    }

    public Country findCountryByCommunity(String communityCode) {
        Community comm = this.findCommunityByCode(communityCode);
        if (comm != null) {
            return this.findCountryByCode(comm.getCountryCode());
        }
        return null;
    }

    public Community findCommunityByCode(String communityCode) {
        return (Community)this.findByProperty("communityCode", communityCode, "String");
    }

    public Country findCountryByCode(String code) {
        if (code != null) {
            List<Country> cList = this.listByProperty("isoAlpha2Code", (Object)code, "String", Country.class);
            if (cList != null && cList.size() > 0) {
                return cList.get(0);
            }
            return null;
        }
        return null;
    }

    public List<Country> listMapCountries(MAP_TYPE type) {
        if (type == MAP_TYPE.PUBLIC) {
            return this.listByProperty("includeInExternal", (Object)true, "Boolean", Country.class);
        }
        return this.listByProperty("includeInKMZ", (Object)true, "Boolean", Country.class);
    }

    public List<Community> listCommunityByCountry(String countryCode) {
        return this.listByProperty("countryCode", countryCode, "String");
    }

    public static enum MAP_TYPE {
        PUBLIC,
        KMZ;

    }
}

