/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import com.gallatinsystems.framework.dataexport.applet.AbstractDataExporter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.SurveyInstanceDto;
import org.waterforpeople.mapping.dataexport.service.BulkDataServiceClient;

public class RawDataExporter
extends AbstractDataExporter {
    private static final Logger log = Logger.getLogger(RawDataExporter.class.getName());
    private static final String IMAGE_PREFIX = "http://waterforpeople.s3.amazonaws.com/images/";
    private String serverBase;
    private String surveyId;
    private String imgPrefix = null;
    private String apiKey;
    public static final String SURVEY_ID = "surveyId";
    private Map<String, QuestionDto> questionMap;
    private List<String> keyList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(Map<String, String> criteria, File fileName, String serverBase, Map<String, String> options) {
        this.serverBase = serverBase;
        this.surveyId = criteria.get(SURVEY_ID);
        this.imgPrefix = options.get("imgPrefix");
        this.apiKey = criteria.get("apiKey");
        Writer pw = null;
        log.finest("In CSV exporter");
        String apiKey = criteria.get("apiKey");
        try {
            Object[] results = BulkDataServiceClient.loadQuestions(this.surveyId, serverBase, apiKey);
            if (results != null) {
                this.keyList = (List)results[0];
                this.questionMap = (Map)results[1];
                pw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF8"));
                this.writeHeader(pw, this.questionMap);
                this.exportInstances(pw, this.keyList);
            } else {
                log.severe("Error getting questions");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error exporting CSV:" + e.getMessage(), e);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Could not close writer: " + e.getMessage(), e);
                }
            }
        }
    }

    public void export(String serverBase, Long surveyIdentifier, Writer pw) {
        try {
            this.surveyId = surveyIdentifier.toString();
            this.serverBase = serverBase;
            Object[] results = BulkDataServiceClient.loadQuestions(this.surveyId, serverBase, this.apiKey);
            if (results != null) {
                this.keyList = (List)results[0];
                this.questionMap = (Map)results[1];
                this.writeHeader(pw, this.questionMap);
                this.exportInstances(pw, this.keyList);
            } else {
                log.severe("Error getting questions");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error exporting: " + e.getMessage(), e);
        }
    }

    private void writeHeader(Writer pw, Map<String, QuestionDto> questions) throws Exception {
        pw.write("Instance\tSubmission Date\tSubmitter\tDuration");
        if (this.keyList != null) {
            for (String key : this.keyList) {
                pw.write("\t");
                if (questions.get(key).getType() != null && QuestionDto.QuestionType.GEO == questions.get(key).getType()) {
                    pw.write(key + "|Latitude\t--GEOLON--|Longitude\t--GEOELE--|Elevation\t--GEOCODE--|Geo Code");
                    continue;
                }
                String questionText = questions.get(key).getText().replaceAll("\n", " ").trim();
                questionText = questionText.replaceAll("\r", " ").trim();
                pw.write(key + "|" + questionText);
            }
        }
        pw.write("\n");
    }

    private void exportInstances(Writer pw, List<String> idList) throws Exception {
        Map<String, String> instances = BulkDataServiceClient.fetchInstanceIds(this.surveyId, this.serverBase, this.apiKey, false, null, null, null);
        if (instances != null) {
            String imagePrefix;
            String string = imagePrefix = this.imgPrefix != null ? this.imgPrefix : IMAGE_PREFIX;
            if (imagePrefix != null && !imagePrefix.endsWith("/")) {
                imagePrefix = imagePrefix + "/";
            }
            int i = 0;
            for (Map.Entry<String, String> instanceEntry : instances.entrySet()) {
                String instanceId = instanceEntry.getKey();
                String dateString = instanceEntry.getValue();
                if (instanceId == null || instanceId.trim().length() <= 0) continue;
                try {
                    HashMap responses = new HashMap();
                    if (responses == null || responses.size() <= 0) continue;
                    pw.write(instanceId);
                    pw.write("\t");
                    pw.write(dateString);
                    pw.write("\t");
                    SurveyInstanceDto dto = BulkDataServiceClient.findSurveyInstance(Long.parseLong(instanceId.trim()), this.serverBase, this.apiKey);
                    if (dto != null) {
                        String name = dto.getSubmitterName();
                        if (name != null) {
                            pw.write(dto.getSubmitterName().replaceAll("\n", " ").replaceAll("\t", " ").trim());
                        }
                        pw.write("\t");
                        Long duration = dto.getSurveyalTime();
                        if (duration != null) {
                            try {
                                SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
                                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                                pw.write(df.format(duration * 1000L));
                            }
                            catch (Exception e) {
                                pw.write("");
                            }
                        }
                    }
                    for (String key : idList) {
                        int filenameIndex;
                        QuestionDto qdto;
                        String val = (String)responses.get(key);
                        pw.write("\t");
                        if (val == null) continue;
                        QuestionDto questionDto = qdto = this.questionMap != null ? this.questionMap.get(key) : null;
                        if (qdto != null && QuestionDto.QuestionType.GEO == qdto.getType()) {
                            String[] geoParts = val.split("\\|");
                            int count = 0;
                            for (count = 0; count < Math.min(geoParts.length, 3); ++count) {
                                if (count > 0) {
                                    pw.write("\t");
                                }
                                pw.write(geoParts[count]);
                            }
                            for (int j = count; j < 3; ++j) {
                                pw.write("\t");
                            }
                            continue;
                        }
                        if (qdto != null && (QuestionDto.QuestionType.PHOTO == qdto.getType() || QuestionDto.QuestionType.VIDEO == qdto.getType()) && (filenameIndex = val.lastIndexOf("/") + 1) > 0 && filenameIndex < val.length()) {
                            val = imagePrefix + val.substring(filenameIndex);
                        }
                        pw.write(val.replaceAll("\n", " ").trim());
                    }
                    pw.write("\n");
                    pw.flush();
                    log.finest("Row: " + ++i);
                    responses = null;
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Swallow the exception for now and continue", ex);
                }
            }
        }
    }

    public static void main(String[] args) {
        RawDataExporter exporter = new RawDataExporter();
        HashMap<String, String> criteria = new HashMap<String, String>();
        HashMap<String, String> options = new HashMap<String, String>();
        criteria.put(SURVEY_ID, args[2]);
        criteria.put("apiKey", args[3]);
        exporter.export(criteria, new File(args[0]), args[1], options);
    }
}

