/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.survey.dao.CascadeResourceDao;
import com.gallatinsystems.survey.domain.CascadeResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.survey.CascadeResourceDto;
import org.waterforpeople.mapping.app.web.rest.dto.CascadeResourcePayload;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/cascade_resources"})
public class CascadeResourceRestService {
    private CascadeResourceDao cascadeResourceDao = new CascadeResourceDao();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, List<CascadeResourceDto>> listCascadeResources() {
        HashMap<String, List<CascadeResourceDto>> response = new HashMap<String, List<CascadeResourceDto>>();
        ArrayList<CascadeResourceDto> results = new ArrayList<CascadeResourceDto>();
        List crList = this.cascadeResourceDao.list("all");
        if (crList != null) {
            for (CascadeResource cr : crList) {
                CascadeResourceDto dto = new CascadeResourceDto();
                BeanUtils.copyProperties((Object)cr, (Object)dto);
                dto.setLevelNames(cr.getLevelNames());
                if (cr.getKey() != null) {
                    dto.setKeyId(cr.getKey().getId());
                }
                results.add(dto);
            }
        }
        response.put("cascade_resources", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteCascadeResourceById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        CascadeResource cr = (CascadeResource)this.cascadeResourceDao.getByKey(id);
        RestStatusDto statusDto = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (cr != null) {
            this.cascadeResourceDao.delete(cr);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingCascadeResource(@RequestBody CascadeResourcePayload payLoad) {
        CascadeResource cr;
        Long keyId;
        CascadeResourceDto cascadeResourceDto = payLoad.getCascade_resource();
        HashMap<String, Object> response = new HashMap<String, Object>();
        CascadeResourceDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (cascadeResourceDto != null && (keyId = cascadeResourceDto.getKeyId()) != null && (cr = (CascadeResource)this.cascadeResourceDao.getByKey(keyId)) != null) {
            BeanUtils.copyProperties((Object)cascadeResourceDto, (Object)cr, (String[])new String[]{"createdDateTime"});
            cr.setLevelNames(cascadeResourceDto.getLevelNames());
            cr = this.cascadeResourceDao.save(cr);
            dto = new CascadeResourceDto();
            BeanUtils.copyProperties((Object)cr, (Object)dto);
            dto.setLevelNames(cr.getLevelNames());
            if (cr.getKey() != null) {
                dto.setKeyId(cr.getKey().getId());
            }
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("cascade_resource", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewCascadeResource(@RequestBody CascadeResourcePayload payLoad) {
        CascadeResourceDto cascadeResourceDto = payLoad.getCascade_resource();
        HashMap<String, Object> response = new HashMap<String, Object>();
        CascadeResourceDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (cascadeResourceDto != null) {
            CascadeResource cr = new CascadeResource();
            BeanUtils.copyProperties((Object)cascadeResourceDto, (Object)cr, (String[])new String[]{"createdDateTime"});
            cr.setLevelNames(cascadeResourceDto.getLevelNames());
            cr = this.cascadeResourceDao.save(cr);
            dto = new CascadeResourceDto();
            BeanUtils.copyProperties((Object)cr, (Object)dto);
            dto.setLevelNames(cr.getLevelNames());
            if (cr.getKey() != null) {
                dto.setKeyId(cr.getKey().getId());
            }
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("cascade_resource", dto);
        return response;
    }
}

