/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest;

import com.gallatinsystems.common.domain.UploadStatusContainer;
import com.gallatinsystems.common.util.S3Util;
import com.gallatinsystems.common.util.ZipUtil;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.survey.domain.WebForm;
import com.google.appengine.api.utils.SystemProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.akvo.flow.xml.PublishedForm;
import org.akvo.flow.xml.XmlForm;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/form_assembly"})
public class FormAssemblyRestService {
    private static final Logger log = Logger.getLogger(FormAssemblyRestService.class.getName());
    private static final String SURVEY_UPLOAD_DIR = "surveyuploaddir";
    private static final String SURVEY_UPLOAD_URL = "surveyuploadurl";

    @PostMapping(consumes={"application/json"})
    @ResponseBody
    public String assembleForm(@RequestBody Survey form) {
        Properties props = System.getProperties();
        String alias = props.getProperty("alias");
        SurveyGroup survey = (SurveyGroup)new SurveyGroupDAO().getByKey(form.getSurveyGroupId());
        long formId = form.getObjectId();
        String xmlAppId = props.getProperty("xmlAppId");
        String appStr = xmlAppId != null && !xmlAppId.isEmpty() ? xmlAppId : SystemProperty.applicationId.get();
        XmlForm jacksonForm = new XmlForm(form, appStr, alias, survey.getCode());
        try {
            String formXML = PublishedForm.generate(jacksonForm);
            log.info("Uploading " + formId);
            UploadStatusContainer uc = this.uploadFormXML(Long.toString(formId), formId + "v" + form.getVersion(), formXML);
            if (uc.getUploadedZip1().booleanValue() && uc.getUploadedZip2().booleanValue()) {
                log.info("Finishing assembly of " + formId);
                form.setStatus(Survey.Status.PUBLISHED);
                if (form.getWebForm().booleanValue()) {
                    boolean webForm = WebForm.validWebForm(survey, form, this.getQuestionList((List)form.getQuestionGroupMap().values()));
                    form.setWebForm(webForm);
                }
                new SurveyDAO().save(form);
                ArrayList<Long> ids = new ArrayList<Long>();
                ids.add(formId);
                SurveyUtils.notifyReportService(ids, "invalidate");
                log.info("Completed form assembly for " + formId);
                return "OK";
            }
            log.warning("Failed to upload assembled form, id " + formId + "\n" + uc.getMessage());
            return "Error";
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to convert form to XML: " + e.getMessage());
            return "Error";
        }
    }

    private List<Question> getQuestionList(List<QuestionGroup> values) {
        return values.stream().map(it -> (List)it.getQuestionMap().values()).collect(Collectors.toList()).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public UploadStatusContainer uploadFormXML(String fileName1, String fileName2, String formXML) {
        Properties props = System.getProperties();
        String bucketName = props.getProperty("s3bucket");
        String directory = props.getProperty(SURVEY_UPLOAD_DIR);
        UploadStatusContainer uc = new UploadStatusContainer();
        uc.setUploadedZip1(this.uploadZippedXml(formXML, bucketName, directory, fileName1));
        uc.setUploadedZip2(this.uploadZippedXml(formXML, bucketName, directory, fileName2));
        uc.setUrl(props.getProperty(SURVEY_UPLOAD_URL) + props.getProperty(SURVEY_UPLOAD_DIR) + "/" + fileName1 + ".zip");
        return uc;
    }

    private boolean uploadZippedXml(String content, String bucketName, String directory, String fileName) {
        ByteArrayOutputStream os2 = ZipUtil.generateZip(content, fileName + ".xml");
        try {
            return S3Util.put(bucketName, directory + "/" + fileName + ".zip", os2.toByteArray(), "application/zip", true);
        }
        catch (IOException e) {
            log.severe("Error uploading zipfile: " + e.toString());
            return false;
        }
    }
}

