/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest;

import com.gallatinsystems.common.domain.UploadStatusContainer;
import com.gallatinsystems.common.util.S3Util;
import com.gallatinsystems.common.util.ZipUtil;
import com.gallatinsystems.survey.dao.CascadeResourceDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.dao.TranslationDao;
import com.gallatinsystems.survey.domain.CascadeResource;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.QuestionOption;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.survey.domain.Translation;
import com.gallatinsystems.survey.domain.WebForm;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.utils.SystemProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.akvo.flow.xml.PublishedForm;
import org.akvo.flow.xml.XmlForm;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionOptionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;

@Controller
@RequestMapping(value={"/form_publish"})
public class FormAssemblyRestService {
    private static final Logger log = Logger.getLogger(FormAssemblyRestService.class.getName());
    private static final String SURVEY_UPLOAD_DIR = "surveyuploaddir";
    private static final String SURVEY_UPLOAD_URL = "surveyuploadurl";
    public static final String BUCKET = "s3bucket";

    @PostMapping(consumes={"application/json"})
    @ResponseBody
    public String publishForm(@RequestBody SurveyDto surveyDto) {
        SurveyGroup survey = (SurveyGroup)new SurveyGroupDAO().getByKey(surveyDto.getSurveyGroupId());
        long formId = surveyDto.getKeyId();
        Survey form = this.assembleForm(surveyDto);
        FormUploadXml formUploadXml = this.assembleXmlForm(survey, form);
        if (!formUploadXml.getXmlContent().isEmpty()) {
            log.info("Uploading " + formId);
            UploadStatusContainer uc = this.uploadFormXML(formUploadXml.getFormIdFilename(), formUploadXml.getFormIdVersionFilename(), formUploadXml.getXmlContent());
            if (uc.getUploadedZip1().booleanValue() && uc.getUploadedZip2().booleanValue()) {
                this.formUploadSuccess(survey, form);
                log.info("Completed form assembly for " + formId);
                return "OK";
            }
            log.severe("Failed to upload assembled form, id " + formId + "\n" + uc.getMessage());
            return "Error";
        }
        return "Error";
    }

    @Nonnull
    private FormUploadXml assembleXmlForm(SurveyGroup survey, Survey form) {
        Properties props = System.getProperties();
        String alias = props.getProperty("alias");
        String xmlAppId = props.getProperty("xmlAppId");
        String appStr = xmlAppId != null && !xmlAppId.isEmpty() ? xmlAppId : SystemProperty.applicationId.get();
        XmlForm jacksonForm = new XmlForm(form, survey, appStr, alias);
        try {
            Long formId = form.getObjectId();
            return new FormUploadXml(Long.toString(formId), formId + "v" + form.getVersion(), PublishedForm.generate(jacksonForm));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to convert form to XML: " + e.getMessage());
            return new FormUploadXml("", "", "");
        }
    }

    private Survey assembleForm(SurveyDto surveyDto) {
        Survey form = this.getFormFromDto(surveyDto);
        this.attachFormTranslations(form);
        List<Question> questions = this.getQuestionList(form.getQuestionGroupMap());
        this.attachCascadeResources(questions);
        return form;
    }

    private void formUploadSuccess(SurveyGroup survey, Survey form) {
        List<Question> questions = this.getQuestionList(form.getQuestionGroupMap());
        form.setStatus(Survey.Status.PUBLISHED);
        if (form.getWebForm().booleanValue()) {
            boolean webForm = WebForm.validWebForm(survey, form, questions);
            form.setWebForm(webForm);
        }
        new SurveyDAO().save(form);
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(form.getObjectId());
        SurveyUtils.notifyReportService(ids, "invalidate");
    }

    private Survey getFormFromDto(SurveyDto surveyDto) {
        Survey form = new Survey();
        form.setKey(KeyFactory.createKey((String)"Survey", (long)surveyDto.getKeyId()));
        form.setCode(surveyDto.getCode());
        form.setName(surveyDto.getName());
        form.setVersion(Double.parseDouble(surveyDto.getVersion()));
        form.setDesc(surveyDto.getDescription());
        form.setStatus(Survey.Status.NOT_PUBLISHED);
        form.setPath(surveyDto.getPath());
        form.setSurveyGroupId(surveyDto.getSurveyGroupId());
        form.setDefaultLanguageCode(surveyDto.getDefaultLanguageCode());
        form.setRequireApproval(surveyDto.getRequireApproval());
        form.setCreatedDateTime(surveyDto.getCreatedDateTime());
        form.setLastUpdateDateTime(surveyDto.getLastUpdateDateTime());
        form.setAncestorIds(surveyDto.getAncestorIds());
        TreeMap<Integer, QuestionGroup> groupMap = this.getGroupMap(surveyDto);
        form.setQuestionGroupMap(groupMap);
        return form;
    }

    @Nonnull
    private TreeMap<Integer, QuestionGroup> getGroupMap(SurveyDto surveyDto) {
        TreeMap<Integer, QuestionGroup> groupMap = new TreeMap<Integer, QuestionGroup>();
        List<QuestionGroupDto> groupDtos = surveyDto.getQuestionGroupList();
        if (groupDtos != null) {
            int i = 1;
            for (QuestionGroupDto groupDto : groupDtos) {
                QuestionGroup group = this.mapToGroup(groupDto);
                if (groupMap.containsKey(groupDto.getOrder())) {
                    groupMap.put(i, group);
                    groupDto.setOrder(i);
                } else {
                    int order = groupDto.getOrder() != null ? groupDto.getOrder() : i;
                    groupMap.put(order, group);
                }
                ++i;
            }
        }
        return groupMap;
    }

    private QuestionGroup mapToGroup(QuestionGroupDto groupDto) {
        QuestionGroup group = new QuestionGroup();
        group.setKey(KeyFactory.createKey((String)"QuestionGroup", (long)groupDto.getKeyId()));
        group.setCode(groupDto.getCode());
        group.setSurveyId(groupDto.getSurveyId());
        group.setOrder(groupDto.getOrder());
        group.setPath(groupDto.getPath());
        group.setName(groupDto.getName());
        group.setRepeatable(groupDto.getRepeatable());
        group.setStatus(QuestionGroup.Status.valueOf(groupDto.getStatus()));
        group.setImmutable(groupDto.getImmutable());
        group.setQuestionMap(this.mapQuestions(groupDto));
        return group;
    }

    @Nonnull
    private TreeMap<Integer, Question> mapQuestions(QuestionGroupDto groupDto) {
        TreeMap<Integer, Question> mappedQuestions = new TreeMap<Integer, Question>();
        List<QuestionDto> questionList = groupDto.getQuestionList();
        if (questionList != null) {
            for (QuestionDto questionDto : questionList) {
                mappedQuestions.put(questionDto.getOrder(), this.mapToQuestion(questionDto));
            }
        }
        return mappedQuestions;
    }

    private Question mapToQuestion(QuestionDto questionDto) {
        Question question = new Question();
        question.setKey(KeyFactory.createKey((String)"Question", (long)questionDto.getKeyId()));
        question.setType(Question.Type.valueOf(questionDto.getType().toString()));
        question.setTip(questionDto.getTip());
        question.setText(questionDto.getText());
        question.setDependentFlag(questionDto.getDependentFlag());
        question.setAllowMultipleFlag(questionDto.getAllowMultipleFlag());
        question.setAllowOtherFlag(questionDto.getAllowOtherFlag());
        question.setCollapseable(questionDto.getCollapseable());
        question.setGeoLocked(questionDto.getGeoLocked());
        question.setRequireDoubleEntry(questionDto.getRequireDoubleEntry());
        question.setImmutable(questionDto.getImmutable());
        question.setDependentQuestionId(questionDto.getDependentQuestionId());
        question.setDependentQuestionAnswer(questionDto.getDependentQuestionAnswer());
        question.setCascadeResourceId(questionDto.getCascadeResourceId());
        question.setCaddisflyResourceUuid(questionDto.getCaddisflyResourceUuid());
        question.setQuestionGroupId(question.getQuestionGroupId());
        question.setSurveyId(questionDto.getSurveyId());
        question.setVariableName(questionDto.getVariableName());
        question.setOrder(questionDto.getOrder());
        question.setMandatoryFlag(questionDto.getMandatoryFlag());
        question.setPath(questionDto.getPath());
        question.setAllowDecimal(questionDto.getAllowDecimal());
        question.setAllowSign(questionDto.getAllowSign());
        question.setMinVal(questionDto.getMinVal());
        question.setMaxVal(question.getMaxVal());
        question.setAllowExternalSources(questionDto.getAllowExternalSources());
        question.setLocaleNameFlag(questionDto.getLocaleNameFlag());
        question.setLocaleLocationFlag(questionDto.getLocaleLocationFlag());
        question.setPersonalData(questionDto.getPersonalData());
        question.setAllowPoints(questionDto.getAllowPoints());
        question.setAllowLine(questionDto.getAllowLine());
        question.setAllowPolygon(questionDto.getAllowPolygon());
        question.setSourceQuestionId(questionDto.getSourceId());
        question.setQuestionOptionMap(this.mapToOptions(questionDto));
        return question;
    }

    @Nonnull
    private TreeMap<Integer, QuestionOption> mapToOptions(QuestionDto questionDto) {
        TreeMap<Integer, QuestionOption> mappedOptions = new TreeMap<Integer, QuestionOption>();
        List<QuestionOptionDto> dtoList = questionDto.getOptionList();
        if (dtoList != null) {
            for (QuestionOptionDto questionOptionDto : dtoList) {
                mappedOptions.put(questionOptionDto.getOrder(), this.mapToQuestionOption(questionOptionDto));
            }
        }
        return mappedOptions;
    }

    private QuestionOption mapToQuestionOption(QuestionOptionDto questionOptionDto) {
        QuestionOption questionOption = new QuestionOption();
        questionOption.setKey(KeyFactory.createKey((String)"QuestionOption", (long)questionOptionDto.getKeyId()));
        questionOption.setText(questionOptionDto.getText());
        questionOption.setCode(questionOptionDto.getCode());
        questionOption.setOrder(questionOptionDto.getOrder());
        questionOption.setQuestionId(questionOptionDto.getQuestionId());
        return questionOption;
    }

    private void attachCascadeResources(List<Question> questions) {
        CascadeResourceDao cascadeResourceDao = new CascadeResourceDao();
        for (Question question : questions) {
            CascadeResource cascadeResource;
            if (!Question.Type.CASCADE.equals((Object)question.getType()) || (cascadeResource = (CascadeResource)cascadeResourceDao.getByKey(question.getCascadeResourceId())) == null) continue;
            question.setCascadeResource(cascadeResource.getResourceId());
            question.setLevelNames(cascadeResource.getLevelNames());
        }
    }

    private void attachFormTranslations(Survey form) {
        TreeMap<Integer, QuestionGroup> questionGroupMap;
        Map<Long, List<Translation>> translations = new TranslationDao().mappedTranslationsByParentId(form.getObjectId());
        HashMap<String, Translation> formTranslationMap = this.getMappedTranslationsForParent(translations, form.getObjectId());
        if (formTranslationMap.size() > 0) {
            form.setTranslationMap(formTranslationMap);
        }
        if ((questionGroupMap = form.getQuestionGroupMap()) != null) {
            ArrayList<QuestionGroup> groups = new ArrayList<QuestionGroup>(questionGroupMap.values());
            for (QuestionGroup group : groups) {
                TreeMap<Integer, Question> questionMap;
                HashMap<String, Translation> map = this.getMappedTranslationsForParent(translations, group.getKey().getId());
                if (map.size() > 0) {
                    group.setTranslations(map);
                }
                if ((questionMap = group.getQuestionMap()) == null) continue;
                ArrayList<Question> questions = new ArrayList<Question>(questionMap.values());
                for (Question question : questions) {
                    TreeMap<Integer, QuestionOption> questionOptionMap;
                    List<Translation> questionTranslations = translations.get(question.getKey().getId());
                    if (questionTranslations.size() > 0) {
                        question.setTranslations(questionTranslations);
                    }
                    if ((questionOptionMap = question.getQuestionOptionMap()) == null) continue;
                    ArrayList<QuestionOption> options = new ArrayList<QuestionOption>(questionOptionMap.values());
                    for (QuestionOption option : options) {
                        HashMap<String, Translation> optionTranslationsMap = this.getMappedTranslationsForParent(translations, option.getKey().getId());
                        if (optionTranslationsMap.size() <= 0) continue;
                        option.setTranslationMap(optionTranslationsMap);
                    }
                }
            }
        }
    }

    private HashMap<String, Translation> getMappedTranslationsForParent(Map<Long, List<Translation>> translations, Long parentId) {
        List<Translation> translationsForForm = translations.get(parentId);
        return this.mapTranslations(translationsForForm);
    }

    private HashMap<String, Translation> mapTranslations(@Nullable List<Translation> translations) {
        HashMap<String, Translation> mappedTranslations = new HashMap<String, Translation>();
        if (translations != null) {
            for (Translation t : translations) {
                mappedTranslations.put(t.getLanguageCode(), t);
            }
        }
        return mappedTranslations;
    }

    @Nonnull
    private List<Question> getQuestionList(@Nullable TreeMap<Integer, QuestionGroup> questionGroupTreeMap) {
        if (questionGroupTreeMap != null) {
            ArrayList<QuestionGroup> groups = new ArrayList<QuestionGroup>(questionGroupTreeMap.values());
            return groups.stream().filter(it -> it.getQuestionMap() != null).map(this::getValues).collect(Collectors.toList()).stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<Question> getValues(QuestionGroup questionGroup) {
        TreeMap<Integer, Question> questionMap = questionGroup.getQuestionMap();
        if (questionMap == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Question>(questionMap.values());
    }

    public UploadStatusContainer uploadFormXML(String fileName1, String fileName2, String formXML) {
        Properties props = System.getProperties();
        String bucketName = props.getProperty(BUCKET);
        String directory = props.getProperty(SURVEY_UPLOAD_DIR);
        String uploadUrl = props.getProperty(SURVEY_UPLOAD_URL);
        UploadStatusContainer uc = new UploadStatusContainer();
        uc.setUploadedZip1(this.uploadZippedXml(formXML, bucketName, directory, fileName1));
        uc.setUploadedZip2(this.uploadZippedXml(formXML, bucketName, directory, fileName2));
        uc.setUrl(uploadUrl + directory + "/" + fileName1 + ".zip");
        return uc;
    }

    private boolean uploadZippedXml(String content, String bucketName, String directory, String fileName) {
        ByteArrayOutputStream os2 = ZipUtil.generateZip(content, fileName + ".xml");
        try {
            return S3Util.put(bucketName, directory + "/" + fileName + ".zip", os2.toByteArray(), "application/zip", true);
        }
        catch (IOException e) {
            log.severe("Error uploading zip file: " + e.toString());
            return false;
        }
    }

    public static class FormUploadXml {
        private final String formIdFilename;
        private final String formIdVersionFilename;
        private final String xmlContent;

        public FormUploadXml(String formIdFilename, String formIdVersionFilename, String xmlContent) {
            this.formIdFilename = formIdFilename;
            this.formIdVersionFilename = formIdVersionFilename;
            this.xmlContent = xmlContent;
        }

        public String getFormIdFilename() {
            return this.formIdFilename;
        }

        public String getFormIdVersionFilename() {
            return this.formIdVersionFilename;
        }

        public String getXmlContent() {
            return this.xmlContent;
        }
    }
}

