/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest.form;

import com.gallatinsystems.survey.dao.TranslationDao;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.QuestionOption;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.Translation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class TranslationsDtoMapper {
    void attachFormTranslations(Survey form) {
        TreeMap<Integer, QuestionGroup> questionGroupMap;
        Long formId = form.getObjectId();
        Map<Long, List<Translation>> translations = new TranslationDao().mappedTranslationsByParentId(formId);
        HashMap<String, Translation> formTranslationMap = this.getMappedTranslationsForParent(translations, formId);
        if (formTranslationMap.size() > 0) {
            form.setTranslationMap(formTranslationMap);
        }
        if ((questionGroupMap = form.getQuestionGroupMap()) != null) {
            ArrayList<QuestionGroup> groups = new ArrayList<QuestionGroup>(questionGroupMap.values());
            for (QuestionGroup group : groups) {
                TreeMap<Integer, Question> questionMap;
                HashMap<String, Translation> map = this.getMappedTranslationsForParent(translations, group.getKey().getId());
                if (map.size() > 0) {
                    group.setTranslations(map);
                }
                if ((questionMap = group.getQuestionMap()) == null) continue;
                ArrayList<Question> questions = new ArrayList<Question>(questionMap.values());
                for (Question question : questions) {
                    TreeMap<Integer, QuestionOption> questionOptionMap;
                    List<Translation> questionTranslations = translations.get(question.getKey().getId());
                    if (questionTranslations.size() > 0) {
                        question.setTranslations(questionTranslations);
                    }
                    if ((questionOptionMap = question.getQuestionOptionMap()) == null) continue;
                    ArrayList<QuestionOption> options = new ArrayList<QuestionOption>(questionOptionMap.values());
                    for (QuestionOption option : options) {
                        HashMap<String, Translation> optionTranslationsMap = this.getMappedTranslationsForParent(translations, option.getKey().getId());
                        if (optionTranslationsMap.size() <= 0) continue;
                        option.setTranslationMap(optionTranslationsMap);
                    }
                }
            }
        }
    }

    HashMap<String, Translation> getMappedTranslationsForParent(Map<Long, List<Translation>> translations, Long parentId) {
        List<Translation> translationsForForm = translations.get(parentId);
        return this.mapTranslations(translationsForForm);
    }

    HashMap<String, Translation> mapTranslations(@Nullable List<Translation> translations) {
        HashMap<String, Translation> mappedTranslations = new HashMap<String, Translation>();
        if (translations != null) {
            for (Translation t : translations) {
                mappedTranslations.put(t.getLanguageCode(), t);
            }
        }
        return mappedTranslations;
    }
}

