/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dao;

import com.gallatinsystems.common.util.MemCacheUtils;
import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.domain.BaseDomain;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;

public class QuestionAnswerStoreDao
extends BaseDAO<QuestionAnswerStore> {
    private Cache cache = MemCacheUtils.initCache(14400);

    public QuestionAnswerStoreDao() {
        super(QuestionAnswerStore.class);
    }

    public List<QuestionAnswerStore> listBySurvey(Long surveyId) {
        return super.listByProperty("surveyId", surveyId, "Long");
    }

    public List<QuestionAnswerStore> listByQuestion(Long questionId) {
        return super.listByProperty("questionID", (Object)questionId.toString(), "String", "createdDateTime");
    }

    public List<QuestionAnswerStore> listByQuestion(Long questionId, String cursor, Integer pageSize) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(QuestionAnswerStore.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("questionID", filterString, paramString, "String", String.valueOf(questionId), paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        query.setOrdering("createdDateTime");
        this.prepareCursor(cursor, pageSize, query);
        return (List)query.executeWithMap(paramMap);
    }

    public List<QuestionAnswerStore> listByTypeAndDate(String type, Long surveyId, Date sinceDate, String cursor, Integer pageSize) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(QuestionAnswerStore.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("type", filterString, paramString, "String", type, paramMap);
        this.appendNonNullParam("surveyId", filterString, paramString, "Long", surveyId, paramMap);
        this.appendNonNullParam("lastUpdateDateTime", filterString, paramString, "Date", sinceDate, paramMap, " >= ");
        if (sinceDate != null) {
            query.declareImports("import java.util.Date");
        }
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursor, pageSize, query);
        return (List)query.executeWithMap(paramMap);
    }

    public List<QuestionAnswerStore> listByTypeValue(String type, String value) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(QuestionAnswerStore.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("type", filterString, paramString, "String", type, paramMap);
        this.appendNonNullParam("value", filterString, paramString, "String", value, paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        return (List)query.executeWithMap(paramMap);
    }

    public List<QuestionAnswerStore> listByNotNullCollectionDateBefore(Date sinceDate, String cursor, Integer pageSize) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(QuestionAnswerStore.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("collectionDate", filterString, paramString, "Date", sinceDate, paramMap, " <= ");
        if (sinceDate != null) {
            query.declareImports("import java.util.Date");
        }
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursor, pageSize, query);
        return (List)query.executeWithMap(paramMap);
    }

    public List<QuestionAnswerStore> listByNotNullCollectionDateAfter(Date sinceDate, String cursor, Integer pageSize) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(QuestionAnswerStore.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("collectionDate", filterString, paramString, "Date", sinceDate, paramMap, " >= ");
        if (sinceDate != null) {
            query.declareImports("import java.util.Date");
        }
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.log.log(Level.INFO, query.toString());
        return (List)query.executeWithMap(paramMap);
    }

    public List<QuestionAnswerStore> listByExactDateString() {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery("select from " + QuestionAnswerStore.class.getName() + " where collectionDate == 5674906531303000000");
        this.log.log(Level.INFO, query.toString());
        return (List)query.execute();
    }

    public List<QuestionAnswerStore> listBySurveyInstance(Long surveyInstanceId) {
        List<QuestionAnswerStore> responses = super.listByProperty("surveyInstanceId", surveyInstanceId, "Long");
        this.cache(responses);
        return responses;
    }

    public Map<Long, Map<Integer, QuestionAnswerStore>> mapByQuestionIdAndIteration(List<QuestionAnswerStore> qasList) {
        HashMap<Long, Map<Integer, QuestionAnswerStore>> responseMap = new HashMap<Long, Map<Integer, QuestionAnswerStore>>();
        for (QuestionAnswerStore a : qasList) {
            Long questionId = Long.parseLong(a.getQuestionID());
            Integer iteration = a.getIteration();
            iteration = iteration == null ? 0 : iteration;
            HashMap<Integer, QuestionAnswerStore> iterationMap = (HashMap<Integer, QuestionAnswerStore>)responseMap.get(questionId);
            if (iterationMap == null) {
                iterationMap = new HashMap<Integer, QuestionAnswerStore>();
                responseMap.put(questionId, iterationMap);
            }
            iterationMap.put(iteration, a);
        }
        return responseMap;
    }

    public Map<Long, QuestionAnswerStore> mapByQuestionId(List<QuestionAnswerStore> qasList) {
        HashMap<Long, QuestionAnswerStore> qasMap = new HashMap<Long, QuestionAnswerStore>();
        try {
            for (QuestionAnswerStore a : qasList) {
                if (a.getQuestionID() == null) continue;
                qasMap.put(Long.parseLong(a.getQuestionID()), a);
            }
            return qasMap;
        }
        catch (NumberFormatException e) {
            return Collections.emptyMap();
        }
    }

    public List<QuestionAnswerStore> listByQuestionAndSurveyInstance(Long questionId, Long surveyInstanceId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(QuestionAnswerStore.class);
        query.setFilter("surveyInstanceId == surveyInstanceIdParam && questionID == questionIdParam");
        query.declareParameters("Long surveyInstanceIdParam, String questionIdParam");
        return (List)query.execute((Object)surveyInstanceId, (Object)questionId.toString());
    }

    public QuestionAnswerStore getByQuestionAndSurveyInstance(Long questionId, Long surveyInstanceId) {
        try {
            String cacheKey = this.getCacheKey(surveyInstanceId + "-" + questionId);
            if (MemCacheUtils.containsKey(this.cache, cacheKey)) {
                return (QuestionAnswerStore)this.cache.get((Object)cacheKey);
            }
        }
        catch (CacheException e) {
            this.log.log(Level.WARNING, e.getMessage());
        }
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(QuestionAnswerStore.class);
        query.setFilter("surveyInstanceId == surveyInstanceIdParam && questionID == questionIdParam");
        query.declareParameters("Long surveyInstanceIdParam, String questionIdParam");
        List results = (List)query.execute((Object)surveyInstanceId, (Object)questionId.toString());
        if (results != null && results.size() > 0) {
            return (QuestionAnswerStore)results.get(0);
        }
        return null;
    }

    public boolean isCached(Long questionId, Long surveyInstanceId) {
        try {
            return MemCacheUtils.containsKey(this.cache, this.getCacheKey(surveyInstanceId + "-" + questionId));
        }
        catch (CacheException cacheException) {
            return false;
        }
    }

    @Override
    public QuestionAnswerStore save(QuestionAnswerStore reponse) {
        QuestionAnswerStore savedResponse = super.save(reponse);
        this.cache(Arrays.asList(savedResponse));
        return savedResponse;
    }

    @Override
    public List<QuestionAnswerStore> save(List<QuestionAnswerStore> responseList) {
        List savedResponses = (List)super.save(responseList);
        this.cache(savedResponses);
        return savedResponses;
    }

    @Override
    public void delete(QuestionAnswerStore response) {
        this.uncache(Arrays.asList(response));
        super.delete(response);
    }

    @Override
    public void delete(List<QuestionAnswerStore> responsesList) {
        this.uncache(responsesList);
        super.delete(responsesList);
    }

    private void cache(List<QuestionAnswerStore> responseList) {
        if (responseList == null || responseList.isEmpty()) {
            return;
        }
        HashMap<Object, Object> cacheMap = new HashMap<Object, Object>();
        for (QuestionAnswerStore response : responseList) {
            if (response == null) continue;
            String cacheKey = null;
            try {
                cacheKey = this.getCacheKey(response);
                cacheMap.put(cacheKey, response);
            }
            catch (CacheException e) {
                this.log.log(Level.WARNING, e.getMessage());
            }
        }
        MemCacheUtils.putObjects(this.cache, cacheMap);
    }

    private void uncache(List<QuestionAnswerStore> responsesList) {
        if (responsesList == null || responsesList.isEmpty()) {
            return;
        }
        for (QuestionAnswerStore response : responsesList) {
            if (response == null) continue;
            String cacheKey = null;
            try {
                cacheKey = this.getCacheKey(response);
                if (!MemCacheUtils.containsKey(this.cache, cacheKey)) continue;
                this.cache.remove((Object)cacheKey);
            }
            catch (CacheException e) {
                this.log.log(Level.WARNING, e.getMessage());
            }
        }
    }

    @Override
    public String getCacheKey(BaseDomain object) throws CacheException {
        QuestionAnswerStore response = (QuestionAnswerStore)object;
        if (response.getSurveyInstanceId() == null || response.getQuestionID() == null) {
            throw new CacheException("Cannnot create cache key without surveyInstanceId and questionId");
        }
        return response.getClass().getSimpleName() + "-" + response.getSurveyInstanceId() + "-" + response.getQuestionID();
    }
}

