/*
 * Decompiled with CFR 0.152.
 */
package com.beoui.geocell;

import com.beoui.geocell.model.Point;

public final class GeocellUtils {
    public static final float MIN_LONGITUDE = -180.0f;
    public static final float MAX_LONGITUDE = 180.0f;
    public static final float MIN_LATITUDE = -90.0f;
    public static final float MAX_LATITUDE = 90.0f;
    public static final int GEOCELL_GRID_SIZE = 4;
    private static final String GEOCELL_ALPHABET = "0123456789abcdef";

    private GeocellUtils() {
    }

    public static String compute(Point point, int resolution) {
        float north = 90.0f;
        float south = -90.0f;
        float east = 180.0f;
        float west = -180.0f;
        StringBuilder cell = new StringBuilder();
        while (cell.length() < resolution) {
            float subcellLonSpan = (east - west) / 4.0f;
            float subcellLatSpan = (north - south) / 4.0f;
            int x = Math.min((int)(4.0 * (point.getLon() - (double)west) / (double)(east - west)), 3);
            int y = Math.min((int)(4.0 * (point.getLat() - (double)south) / (double)(north - south)), 3);
            int[] l = new int[]{x, y};
            cell.append(GeocellUtils.subdivChar(l));
            north = (south += subcellLatSpan * (float)y) + subcellLatSpan;
            east = (west += subcellLonSpan * (float)x) + subcellLonSpan;
        }
        return cell.toString();
    }

    public static char subdivChar(int[] pos) {
        return GEOCELL_ALPHABET.charAt((pos[1] & 2) << 2 | (pos[0] & 2) << 1 | (pos[1] & 1) << 1 | (pos[0] & 1) << 0);
    }
}

