/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.common.util;

import com.gallatinsystems.common.util.MappableField;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassAttributeUtil {
    private static HashMap<String, TreeMap<String, String>> classAttributeMap = new HashMap();
    private static final Logger logger = Logger.getLogger(ClassAttributeUtil.class.getName());

    public static TreeMap<String, String> listObjectAttributes(String className) {
        TreeMap<String, String> attributesList = classAttributeMap.get(className);
        if (attributesList == null) {
            attributesList = new TreeMap();
            Class<?> cls = null;
            try {
                cls = Class.forName(className);
                for (Field item : cls.getDeclaredFields()) {
                    if (item.getName().contains("jdo") || item.getName().equals("serialVersionUID") || item.getName().equals("geoCells")) continue;
                    String displayName = null;
                    if (item.getAnnotation(MappableField.class) != null) {
                        displayName = item.getAnnotation(MappableField.class).displayName();
                    }
                    attributesList.put(item.getName(), displayName);
                }
                classAttributeMap.put(className, attributesList);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.SEVERE, "Class not found: " + className, e);
            }
        }
        return attributesList;
    }
}

