/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.akvo.flow.domain.Message;
import org.akvo.flow.domain.persistent.Report;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class ReportDao
extends BaseDAO<Report> {
    public ReportDao() {
        super(Report.class);
    }

    public List<Report> listByUserAndType(long user, @Nullable String reportType) {
        if (reportType == null) {
            return this.listByProperty("user", (Object)user, "Long", Report.class);
        }
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(Message.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("user", filterString, paramString, "Long", user, paramMap);
        this.appendNonNullParam("reportType", filterString, paramString, "String", reportType, paramMap);
        if (filterString.toString().trim().length() > 0) {
            query.setFilter(filterString.toString());
            query.declareParameters(paramString.toString());
        }
        return (List)query.executeWithMap(paramMap);
    }

    public List<Report> listAllByCurrentUserAndType(@Nullable String reportType) {
        return this.listByUserAndType(this.currentUserId(), reportType);
    }

    public List<Report> listAllCreatedBefore(Date date) {
        return this.listByProperty("createdDateTime", date, "Date", "createdDateTime", null, " <= ", Report.class);
    }

    public long currentUserId() {
        SecurityContext c = SecurityContextHolder.getContext();
        if (c == null) {
            return 0L;
        }
        Authentication a = c.getAuthentication();
        if (a == null) {
            return 0L;
        }
        if (a.getCredentials() instanceof Long) {
            return (Long)a.getCredentials();
        }
        return 0L;
    }
}

