/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.notification;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.waterforpeople.mapping.dataexport.RawDataExporter;
import org.waterforpeople.mapping.notification.AbstractReportNotificationHandler;

public class RawDataReportNotificationHandler
extends AbstractReportNotificationHandler {
    public static final String TYPE = "rawDataReport";
    private static final String EMAIL_TITLE = "FLOW Raw Data Report for survey: ";
    private static final String EMAIL_BODY = "Please see the latest raw data report here (Recommend you open in Microsoft Excel) for Survey : ";
    private DateFormat df = new SimpleDateFormat("MMddyyyy");
    private static final Logger log = Logger.getLogger(RawDataReportNotificationHandler.class.getName());

    @Override
    protected void writeReport(Long entityId, String serverBase, PrintWriter pw) {
        RawDataExporter exporter = new RawDataExporter();
        exporter.export(serverBase, entityId, pw);
        pw.flush();
    }

    @Override
    protected String getEmailBody() {
        return EMAIL_BODY;
    }

    @Override
    protected String getEmailSubject() {
        return EMAIL_TITLE;
    }

    @Override
    protected String getFileName(String entityId) {
        return "rawDataReport-" + entityId + "-" + this.df.format(new Date()) + ".txt";
    }
}

