/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.dto;

import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class RawDataImportRequest
extends RestRequest {
    private static final Logger log = Logger.getLogger("RawDataImportRequest");
    private static final long serialVersionUID = 3792808180110794885L;
    private static final ThreadLocal<DateFormat> IN_FMT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss z");
        }
    };
    public static final String SURVEY_INSTANCE_ID_PARAM = "surveyInstanceId";
    public static final String COLLECTION_DATE_PARAM = "collectionDate";
    public static final String QUESTION_ID_PARAM = "questionId";
    public static final String SURVEY_ID_PARAM = "surveyId";
    public static final String SUBMITTER_PARAM = "submitter";
    public static final String FIXED_FIELD_VALUE_PARAM = "values";
    public static final String LOCALE_ID_PARAM = "surveyedLocale";
    public static final String DURATION_PARAM = "duration";
    public static final String FORM_VER_PARAM = "formVersion";
    public static final String SAVE_SURVEY_INSTANCE_ACTION = "saveSurveyInstance";
    public static final String RESET_SURVEY_INSTANCE_ACTION = "resetSurveyInstance";
    public static final String SAVE_FIXED_FIELD_SURVEY_INSTANCE_ACTION = "ingestFixedFormat";
    public static final String UPDATE_SUMMARIES_ACTION = "updateSummaries";
    public static final String SAVE_MESSAGE_ACTION = "saveMessage";
    public static final String FIELD_VAL_DELIMITER = ";;";
    private Long surveyId;
    private Long surveyedLocaleId;
    private Long surveyInstanceId = null;
    private Long duration = null;
    private Date collectionDate = null;
    private String submitter = null;
    private Double formVersion = null;
    private Map<Long, Map<Integer, String[]>> responseMap = new HashMap<Long, Map<Integer, String[]>>();
    private List<String> fixedFieldValues;
    private SurveyInstanceDAO instanceDao = new SurveyInstanceDAO();
    private SurveyDAO sDao = new SurveyDAO();
    private SurveyGroupDAO sgDao = new SurveyGroupDAO();
    private SurveyedLocaleDao slDao = new SurveyedLocaleDao();
    private SurveyedLocale dataPoint;
    private SurveyInstance formInstance;
    private Survey form;
    private SurveyGroup survey;
    private String type;

    public Survey getForm() {
        return this.form;
    }

    public SurveyGroup getSurvey() {
        return this.survey;
    }

    public SurveyInstance getFormInstance() {
        return this.formInstance;
    }

    public SurveyedLocale getDataPoint() {
        return this.dataPoint;
    }

    public boolean isNewFormInstance() {
        return this.surveyInstanceId == null;
    }

    public boolean isMonitoringForm() {
        return this.survey != null && this.form != null && this.survey.getMonitoringGroup() != false && !this.survey.getNewLocaleSurveyId().equals(this.form.getKey().getId());
    }

    public boolean isRegistrationForm() {
        return this.survey != null && this.form != null && this.survey.getMonitoringGroup() != false && this.survey.getNewLocaleSurveyId().equals(this.form.getKey().getId());
    }

    public List<String> getFixedFieldValues() {
        return this.fixedFieldValues;
    }

    public void setFixedFieldValues(List<String> fixedFieldValues) {
        this.fixedFieldValues = fixedFieldValues;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getSurveyId() {
        return this.surveyId;
    }

    public void setSurveyId(Long surveyId) {
        this.surveyId = surveyId;
    }

    public Long getSurveyInstanceId() {
        return this.surveyInstanceId;
    }

    public void setSurveyInstanceId(Long surveyInstanceId) {
        this.surveyInstanceId = surveyInstanceId;
    }

    public Date getCollectionDate() {
        return this.collectionDate;
    }

    public void setCollectionDate(Date collectionDate) {
        this.collectionDate = collectionDate;
    }

    public Map<Long, Map<Integer, String[]>> getResponseMap() {
        return this.responseMap;
    }

    public void putResponse(Long questionId, Integer iteration, String value, String type) {
        Map<Integer, String[]> iterationMap = this.responseMap.get(questionId);
        if (iterationMap == null) {
            iterationMap = new HashMap<Integer, String[]>();
            this.responseMap.put(questionId, iterationMap);
        }
        iterationMap.put(iteration, new String[]{value, type != null ? type : "VALUE"});
    }

    @Override
    protected void populateErrors() {
        List<String> errors = this.validateRequest();
        for (String error : errors) {
            this.addError(new RestError("5001", error, this.surveyInstanceId.toString()));
        }
    }

    public List<String> validateRequest() {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (SAVE_SURVEY_INSTANCE_ACTION.equals(this.getAction())) {
            validationErrors.addAll(this.validateSaveSurveyInstanceRequest());
        }
        return validationErrors;
    }

    private List<String> validateSaveSurveyInstanceRequest() {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.surveyInstanceId != null) {
            this.formInstance = (SurveyInstance)this.instanceDao.getByKey(this.surveyInstanceId);
            if (this.formInstance == null) {
                validationErrors.add("Form instance [id=" + this.surveyInstanceId + "] not found");
            }
        }
        if (this.surveyId != null) {
            this.form = (Survey)this.sDao.getByKey(this.surveyId);
            if (this.form == null) {
                validationErrors.add("Form [id=" + this.surveyId + "] not found");
            }
        }
        if (this.form != null) {
            this.survey = (SurveyGroup)this.sgDao.getByKey(this.form.getSurveyGroupId());
            if (this.survey == null) {
                validationErrors.add("Survey [id=" + this.form.getSurveyGroupId() + "] not found");
            }
        }
        if (this.isMonitoringForm()) {
            validationErrors.add("Importing new data into a monitoring form is not supported at the moment");
        }
        if (this.formInstance != null && this.surveyId != null && !this.formInstance.getSurveyId().equals(this.surveyId)) {
            validationErrors.add("Wrong survey selected when importing instance [id=" + this.surveyInstanceId + "]");
        }
        if (this.formInstance != null && this.survey != null && this.survey.getMonitoringGroup().booleanValue()) {
            if (this.formInstance.getSurveyedLocaleId() == null) {
                validationErrors.add("Form instance [id=" + this.surveyInstanceId + "] does not have an associated datapoint");
            } else {
                this.dataPoint = (SurveyedLocale)this.slDao.getByKey(this.formInstance.getSurveyedLocaleId());
                if (this.dataPoint == null) {
                    validationErrors.add("Associated datapoint is missing [ datapoint id = " + this.formInstance.getSurveyedLocaleId() + "]");
                }
            }
        }
        return validationErrors;
    }

    @Override
    protected void populateFields(HttpServletRequest req) throws Exception {
        if (req.getParameter(LOCALE_ID_PARAM) != null) {
            try {
                this.setSurveyedLocaleId(new Long(req.getParameter(LOCALE_ID_PARAM)));
            }
            catch (Exception e) {
                log.info("surveyedLocale is missing");
            }
        }
        if (req.getParameter(SURVEY_INSTANCE_ID_PARAM) != null) {
            try {
                this.setSurveyInstanceId(new Long(req.getParameter(SURVEY_INSTANCE_ID_PARAM)));
            }
            catch (Exception e) {
                log.info("surveyInstanceId is missing");
            }
        }
        if (req.getParameter(FIXED_FIELD_VALUE_PARAM) != null) {
            this.fixedFieldValues = new ArrayList<String>();
            String[] vals = URLDecoder.decode(req.getParameter(FIXED_FIELD_VALUE_PARAM), "UTF-8").split(FIELD_VAL_DELIMITER);
            for (int i = 0; i < vals.length; ++i) {
                this.fixedFieldValues.add(vals[i]);
            }
        }
        if (req.getParameter(QUESTION_ID_PARAM) != null) {
            this.handleQuestionIdParam(req.getParameterValues(QUESTION_ID_PARAM));
        } else {
            log.warning("No question answers to import");
        }
        if (req.getParameter(SURVEY_ID_PARAM) != null) {
            this.surveyId = new Long(req.getParameter(SURVEY_ID_PARAM).trim());
        } else {
            log.warning("surveyId is missing");
        }
        if (req.getParameter(COLLECTION_DATE_PARAM) != null && req.getParameter(COLLECTION_DATE_PARAM).trim().length() > 0) {
            String colDate = req.getParameter(COLLECTION_DATE_PARAM).trim();
            if (colDate.contains("%") || colDate.contains("+")) {
                colDate = URLDecoder.decode(colDate, "UTF-8");
            }
            this.collectionDate = IN_FMT.get().parse(colDate);
        }
        if (req.getParameter(SUBMITTER_PARAM) != null) {
            this.setSubmitter(URLDecoder.decode(req.getParameter(SUBMITTER_PARAM), "UTF-8"));
        }
        if (req.getParameter(DURATION_PARAM) != null) {
            try {
                this.setSurveyDuration(Long.valueOf(req.getParameter(DURATION_PARAM)));
            }
            catch (NumberFormatException e) {
                log.warning("Could not parse duration: " + req.getParameter(DURATION_PARAM));
                this.setSurveyDuration(0L);
            }
        }
        if (req.getParameter(FORM_VER_PARAM) != null) {
            try {
                this.setFormVersion(Double.valueOf(req.getParameter(FORM_VER_PARAM)));
            }
            catch (NumberFormatException e) {
                log.warning("Could not parse formVersion: " + req.getParameter(FORM_VER_PARAM));
                this.setFormVersion(0.0);
            }
        }
    }

    private void handleQuestionIdParam(String[] answers) throws UnsupportedEncodingException {
        if (answers != null) {
            for (String answer : answers) {
                String[] parts = URLDecoder.decode(answer, "UTF-8").split("\\|");
                HashMap<Integer, String> iterations = new HashMap<Integer, String>();
                Long questionId = Long.valueOf(parts[0]);
                String type = null;
                block7: for (int i = 1; i < parts.length; ++i) {
                    String part = parts[i];
                    String[] keyValue = part.split("=");
                    if (keyValue.length != 2) continue;
                    String key = keyValue[0];
                    String val = keyValue[1];
                    switch (key) {
                        case "type": {
                            type = val;
                            continue block7;
                        }
                        default: {
                            iterations.put(Integer.valueOf(key), URLDecoder.decode(val, "UTF-8"));
                        }
                    }
                }
                if (questionId != null && type != null) {
                    for (Map.Entry iterationEntry : iterations.entrySet()) {
                        this.putResponse(questionId, (Integer)iterationEntry.getKey(), (String)iterationEntry.getValue(), type);
                    }
                    continue;
                }
                log.log(Level.WARNING, "Could not parse \"" + answer + "\" as RawDataImportRequest");
            }
        }
    }

    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public Long getSurveyedLocaleId() {
        return this.surveyedLocaleId;
    }

    public void setSurveyedLocaleId(Long surveyedLocaleId) {
        this.surveyedLocaleId = surveyedLocaleId;
    }

    public void setSurveyDuration(Long duration) {
        this.duration = duration;
    }

    public Long getSurveyDuration() {
        return this.duration;
    }

    public Double getFormVersion() {
        return this.formVersion;
    }

    public void setFormVersion(Double formVersion) {
        this.formVersion = formVersion;
    }
}

