/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest;

import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.device.domain.DeviceSurveyJobQueue;
import com.gallatinsystems.survey.dao.DeviceSurveyJobQueueDAO;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.domain.Survey;
import com.google.appengine.api.datastore.KeyFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.akvo.flow.dao.DataPointAssignmentDao;
import org.akvo.flow.dao.SurveyAssignmentDao;
import org.akvo.flow.domain.persistent.DataPointAssignment;
import org.akvo.flow.domain.persistent.SurveyAssignment;
import org.akvo.flow.rest.dto.SurveyAssignmentDto;
import org.akvo.flow.rest.dto.SurveyAssignmentPayload;
import org.springframework.beans.BeanUtils;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.web.rest.ResourceNotFoundException;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/survey_assignments"})
public class SurveyAssignmentRestService {
    private SurveyAssignmentDao surveyAssignmentDao = new SurveyAssignmentDao();
    private DeviceDAO deviceDao = new DeviceDAO();
    private SurveyDAO surveyDao = new SurveyDAO();
    private DeviceSurveyJobQueueDAO deviceSurveyJobQueueDAO = new DeviceSurveyJobQueueDAO();
    private DataPointAssignmentDao dataPointAssignmentDao = new DataPointAssignmentDao();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, List<SurveyAssignmentDto>> listAll() {
        HashMap<String, List<SurveyAssignmentDto>> response = new HashMap<String, List<SurveyAssignmentDto>>();
        ArrayList<SurveyAssignmentDto> results = new ArrayList<SurveyAssignmentDto>();
        for (SurveyAssignment sa : this.surveyAssignmentDao.list("all")) {
            results.add(this.marshallToDto(sa));
        }
        response.put("survey_assignments", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, SurveyAssignmentDto> getById(@PathVariable(value="id") Long id) {
        HashMap<String, SurveyAssignmentDto> response = new HashMap<String, SurveyAssignmentDto>();
        SurveyAssignment sa = (SurveyAssignment)this.surveyAssignmentDao.getByKey(id);
        if (sa == null) {
            throw new ResourceNotFoundException("Survey Assignment with id: " + id + " not found");
        }
        response.put("survey_assignment", this.marshallToDto(sa));
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        SurveyAssignment sa = (SurveyAssignment)this.surveyAssignmentDao.getByKey(id);
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (sa != null) {
            this.deleteExistingDeviceSurveyJobQueueItems(sa);
            this.deleteExistingDatapointAssignments(sa);
            this.surveyAssignmentDao.delete(sa);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, SurveyAssignmentDto> updateSurveyAssignment(@PathVariable(value="id") Long id, @RequestBody SurveyAssignmentPayload payload) {
        SurveyAssignmentDto dto = payload.getSurvey_assignment();
        if (!id.equals(dto.getKeyId())) {
            throw new HttpMessageNotReadableException("Ids don't match: " + id + " <> " + dto.getKeyId());
        }
        SurveyAssignment assignment = (SurveyAssignment)this.surveyAssignmentDao.getByKey(dto.getKeyId());
        if (assignment == null) {
            throw new ResourceNotFoundException("Survey Assignment with id: " + dto.getKeyId() + " not found");
        }
        this.deleteExistingDeviceSurveyJobQueueItems(assignment);
        SurveyAssignment sa = this.marshallToDomain(dto);
        this.surveyAssignmentDao.save(sa);
        List<DeviceSurveyJobQueue> deviceSurveyJobQueues = this.generateDeviceSurveyJobQueueItems(sa);
        this.deviceSurveyJobQueueDAO.save(deviceSurveyJobQueues);
        HashMap<String, SurveyAssignmentDto> response = new HashMap<String, SurveyAssignmentDto>();
        response.put("survey_assignment", this.marshallToDto(sa));
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> newSurveyAssignment(@RequestBody SurveyAssignmentPayload payload) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        statusDto.setMessage("missing required parameters");
        SurveyAssignment sa = this.marshallToDomain(payload.getSurvey_assignment());
        if (sa != null && sa.getDeviceIds() != null && sa.getSurveyId() != null) {
            this.surveyAssignmentDao.save(sa);
            List<DeviceSurveyJobQueue> deviceSurveyJobQueues = this.generateDeviceSurveyJobQueueItems(sa);
            this.deviceSurveyJobQueueDAO.save(deviceSurveyJobQueues);
            response.put("survey_assignment", this.marshallToDto(sa));
            statusDto.setStatus("ok");
            statusDto.setMessage("");
        }
        response.put("meta", statusDto);
        return response;
    }

    private SurveyAssignmentDto marshallToDto(SurveyAssignment sa) {
        SurveyAssignmentDto dto = new SurveyAssignmentDto();
        BeanUtils.copyProperties((Object)sa, (Object)dto);
        if (sa.getKey() != null) {
            dto.setKeyId(sa.getKey().getId());
        }
        dto.setDeviceIds(sa.getDeviceIds());
        dto.setFormIds(sa.getFormIds());
        return dto;
    }

    private SurveyAssignment marshallToDomain(SurveyAssignmentDto dto) {
        SurveyAssignment sa = new SurveyAssignment();
        BeanUtils.copyProperties((Object)dto, (Object)sa);
        if (dto.getKeyId() != null) {
            sa.setKey(KeyFactory.createKey((String)"SurveyAssignment", (long)dto.getKeyId()));
        }
        sa.setDeviceIds(dto.getDeviceIds());
        sa.setFormIds(dto.getFormIds());
        return sa;
    }

    private void deleteExistingDeviceSurveyJobQueueItems(SurveyAssignment assignment) {
        List<DeviceSurveyJobQueue> deviceAssignmentsToDelete = this.deviceSurveyJobQueueDAO.listJobByAssignment(assignment.getKey().getId());
        this.deviceSurveyJobQueueDAO.delete(deviceAssignmentsToDelete);
    }

    private void deleteExistingDatapointAssignments(SurveyAssignment assignment) {
        List<DataPointAssignment> dataPointAssignments = this.dataPointAssignmentDao.listBySurveyAssignment(assignment.getKey().getId());
        this.dataPointAssignmentDao.delete(dataPointAssignments);
    }

    private List<DeviceSurveyJobQueue> generateDeviceSurveyJobQueueItems(SurveyAssignment assignment) {
        ArrayList<DeviceSurveyJobQueue> deviceSurveyJobQueues = new ArrayList<DeviceSurveyJobQueue>();
        List forms = this.surveyDao.listByKeys(assignment.getFormIds());
        List devices = this.deviceDao.listByKeys(assignment.getDeviceIds());
        for (Survey form : forms) {
            for (Device device : devices) {
                deviceSurveyJobQueues.add(this.constructQueueObject(device, form, assignment));
            }
        }
        return deviceSurveyJobQueues;
    }

    private DeviceSurveyJobQueue constructQueueObject(Device d, Survey survey, SurveyAssignment assignment) {
        DeviceSurveyJobQueue queueItem = new DeviceSurveyJobQueue();
        queueItem.setDevicePhoneNumber(d.getPhoneNumber());
        queueItem.setEffectiveStartDate(assignment.getStartDate());
        queueItem.setEffectiveEndDate(assignment.getEndDate());
        queueItem.setSurveyID(survey.getKey().getId());
        queueItem.setName(survey.getName());
        queueItem.setLanguage(assignment.getLanguage());
        queueItem.setAssignmentId(assignment.getKey().getId());
        queueItem.setSurveyDistributionStatus(DeviceSurveyJobQueue.DistributionStatus.UNSENT);
        queueItem.setImei(d.getEsn());
        queueItem.setAndroidId(d.getAndroidId());
        return queueItem;
    }
}

