/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest.form;

import com.gallatinsystems.survey.dao.CascadeResourceDao;
import com.gallatinsystems.survey.domain.CascadeResource;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.Survey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.akvo.flow.rest.form.FormMapper;
import org.akvo.flow.rest.form.TranslationsAppender;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;

public class FormAssembler {
    private final FormMapper formMapper;
    private final TranslationsAppender translationsAppender;

    public FormAssembler(FormMapper formMapper, TranslationsAppender translationsAppender) {
        this.formMapper = formMapper;
        this.translationsAppender = translationsAppender;
    }

    Survey assembleForm(SurveyDto surveyDto) {
        Survey form = this.formMapper.mapFormFromDto(surveyDto);
        this.translationsAppender.attachFormTranslations(form);
        List<Question> questions = this.getQuestionList(form.getQuestionGroupMap());
        this.attachCascadeResources(questions);
        return form;
    }

    private void attachCascadeResources(List<Question> questions) {
        CascadeResourceDao cascadeResourceDao = new CascadeResourceDao();
        for (Question question : questions) {
            CascadeResource cascadeResource;
            if (!Question.Type.CASCADE.equals((Object)question.getType()) || (cascadeResource = (CascadeResource)cascadeResourceDao.getByKey(question.getCascadeResourceId())) == null) continue;
            question.setCascadeResource(cascadeResource.getResourceId());
            question.setLevelNames(cascadeResource.getLevelNames());
        }
    }

    @Nonnull
    List<Question> getQuestionList(@Nullable TreeMap<Integer, QuestionGroup> questionGroupTreeMap) {
        if (questionGroupTreeMap != null) {
            ArrayList<QuestionGroup> groups = new ArrayList<QuestionGroup>(questionGroupTreeMap.values());
            return groups.stream().filter(it -> it.getQuestionMap() != null).map(this::getListOfQuestions).collect(Collectors.toList()).stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<Question> getListOfQuestions(QuestionGroup questionGroup) {
        TreeMap<Integer, Question> questionMap = questionGroup.getQuestionMap();
        if (questionMap == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Question>(questionMap.values());
    }
}

