/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.domain.DeviceFiles;
import com.gallatinsystems.device.domain.DeviceSurveyJobQueue;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.DeviceSurveyJobQueueDAO;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyContainer;
import com.gallatinsystems.survey.domain.SurveyGroup;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.waterforpeople.mapping.app.web.dto.SurveyManagerRequest;
import org.waterforpeople.mapping.dao.DeviceFilesDao;
import org.waterforpeople.mapping.dao.SurveyContainerDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class SurveyManagerServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(SurveyManagerServlet.class.getName());
    private static final long serialVersionUID = 4400244780977729721L;
    private DeviceDAO deviceDao = new DeviceDAO();

    public SurveyManagerServlet() {
        this.setMode("XML");
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        SurveyManagerRequest restRequest = new SurveyManagerRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        DeviceFilesDao dfDao;
        List<DeviceFiles> dfList;
        SurveyManagerRequest mgrReq = (SurveyManagerRequest)req;
        RestResponse resp = new RestResponse();
        if (mgrReq.getAction() == null) {
            if (mgrReq.getSurveyDoc() == null) {
                if (mgrReq.getSurveyInstanceId() != null) {
                    SurveyInstanceDAO siDAO = new SurveyInstanceDAO();
                    SurveyInstance si = (SurveyInstance)siDAO.getByKey(mgrReq.getSurveyInstanceId());
                    if (si != null) {
                        resp.setMessage(si.toString());
                    } else {
                        resp.setMessage("No Survey Instance Found");
                    }
                } else if (mgrReq.getSurveyId() != null) {
                    SurveyContainerDao scDao = new SurveyContainerDao();
                    SurveyContainer container = scDao.findBySurveyId(mgrReq.getSurveyId());
                    if (container != null) {
                        resp.setMessage(container.getSurveyDocument().getValue());
                    } else {
                        resp.setMessage("No Survey Found");
                    }
                }
            }
        } else if ("getAvailableSurveysDevice".equalsIgnoreCase(req.getAction())) {
            if (mgrReq.getPhoneNumber() != null || mgrReq.getImei() != null) {
                resp.setMessage(this.getSurveyForPhone(mgrReq.getPhoneNumber(), mgrReq.getImei(), mgrReq.getAndroidId()));
                this.deviceDao.updateDevice(mgrReq.getPhoneNumber(), null, null, null, mgrReq.getVersion(), mgrReq.getDeviceId(), mgrReq.getImei(), null, mgrReq.getAndroidId());
            }
        } else if ("getAvailableSurveyGroupsDevice".equalsIgnoreCase(req.getAction())) {
            if (mgrReq.getPhoneNumber() != null || mgrReq.getImei() != null) {
                resp.setMessage(this.getSurveyGroupsForPhone(mgrReq.getPhoneNumber(), mgrReq.getImei(), mgrReq.getAndroidId()));
            }
        } else if ("getSurveyHeader".equalsIgnoreCase(req.getAction())) {
            if (mgrReq.getSurveyId() != null) {
                SurveyDAO surveyDao = new SurveyDAO();
                SurveyGroupDAO sgDao = new SurveyGroupDAO();
                Survey survey = surveyDao.getById(mgrReq.getSurveyId());
                String sgName = null;
                Boolean isInMonitoringGroup = false;
                String newLocaleSurveyId = "null";
                if (survey != null) {
                    SurveyGroup sg = (SurveyGroup)sgDao.getByKey(survey.getSurveyGroupId());
                    if (sg != null) {
                        sgName = sg.getCode();
                        isInMonitoringGroup = sg.getMonitoringGroup() != null ? sg.getMonitoringGroup() : false;
                        newLocaleSurveyId = sg.getNewLocaleSurveyId() != null ? sg.getNewLocaleSurveyId().toString() : "null";
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(survey.getKey().getId() + ",").append(survey.getName() != null ? survey.getName() : "Survey " + survey.getKey().getId()).append(",").append(survey.getDefaultLanguageCode() != null ? survey.getDefaultLanguageCode() : "en").append(",").append(survey.getVersion() != null ? survey.getVersion() : "1").append(",").append(survey.getSurveyGroupId().toString()).append(",").append(sgName != null ? sgName : "null").append(",").append(isInMonitoringGroup).append(",").append(newLocaleSurveyId);
                    resp.setMessage(sb.toString());
                }
            }
            this.deviceDao.updateDevice(mgrReq.getPhoneNumber(), null, null, null, mgrReq.getVersion(), mgrReq.getDeviceId(), mgrReq.getImei(), null, mgrReq.getAndroidId());
        } else if ("getZipFileUrls".equalsIgnoreCase(req.getAction()) && (dfList = (dfDao = new DeviceFilesDao()).listDeviceFilesByDate(mgrReq.getStartDate(), "all")) != null) {
            HashSet<String> uxUrlList = new HashSet<String>();
            for (DeviceFiles df : dfList) {
                uxUrlList.add(df.getURI());
            }
            StringBuilder sb = new StringBuilder();
            for (String item : uxUrlList) {
                sb.append(item + "\n");
            }
            resp.setMessage(sb.toString());
        }
        return resp;
    }

    private String getSurveyForPhone(String devicePhoneNumber, String imei, String androidId) {
        DeviceSurveyJobQueueDAO dsjqDAO = new DeviceSurveyJobQueueDAO();
        SurveyDAO surveyDao = new SurveyDAO();
        SurveyGroupDAO sgDao = new SurveyGroupDAO();
        StringBuilder sb = new StringBuilder();
        for (DeviceSurveyJobQueue dsjq : dsjqDAO.get(devicePhoneNumber, imei, androidId)) {
            String newLocaleSurveyId;
            SurveyGroup sg;
            Survey s = surveyDao.getById(dsjq.getSurveyID());
            SurveyGroup surveyGroup = sg = s != null && s.getSurveyGroupId() != null ? (SurveyGroup)sgDao.getByKey(s.getSurveyGroupId()) : null;
            if (s == null || sg == null) continue;
            Double ver = s.getVersion();
            String surveyName = s.getName();
            String sgName = sg.getCode() != null ? sg.getCode() : "unknown";
            Boolean isInMonitoringGroup = sg.getMonitoringGroup() != null ? sg.getMonitoringGroup() : false;
            String string = newLocaleSurveyId = sg.getNewLocaleSurveyId() != null ? sg.getNewLocaleSurveyId().toString() : "null";
            if (ver == null) {
                ver = new Double(1.0);
            }
            sb.append(devicePhoneNumber + "," + dsjq.getSurveyID() + "," + surveyName + "," + dsjq.getLanguage() + "," + ver + "," + s.getSurveyGroupId() + "," + sgName + "," + isInMonitoringGroup + "," + newLocaleSurveyId + "\n");
        }
        return sb.toString();
    }

    private String getSurveyGroupsForPhone(String devicePhoneNumber, String imei, String androidId) {
        DeviceSurveyJobQueueDAO dsjqDAO = new DeviceSurveyJobQueueDAO();
        SurveyDAO surveyDao = new SurveyDAO();
        SurveyGroupDAO sgDao = new SurveyGroupDAO();
        HashMap<Long, Boolean> includeGroupMap = new HashMap<Long, Boolean>();
        for (DeviceSurveyJobQueue dsjq : dsjqDAO.get(devicePhoneNumber, imei, androidId)) {
            Survey s = surveyDao.getById(dsjq.getSurveyID());
            if (s == null) continue;
            includeGroupMap.put(s.getSurveyGroupId(), true);
        }
        StringBuilder sb = new StringBuilder();
        for (SurveyGroup sg : sgDao.list("all")) {
            if (includeGroupMap.get(sg.getKey().getId()) == null) continue;
            sb.append(sg.getKey().getId()).append(",").append(sg.getCode()).append(",").append((Object)(sg.getMonitoringGroup() != null ? sg.getMonitoringGroup() : false)).append(",").append(sg.getNewLocaleSurveyId()).append("\n");
        }
        return sb.toString();
    }

    @Override
    protected void writeOkResponse(RestResponse response) throws Exception {
        try {
            HttpServletResponse resp = this.getResponse();
            resp.setStatus(200);
            resp.getWriter().print(response.getMessage());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not write survey manager response to http output stream", e);
        }
    }
}

