/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.gallatinsystems.common.util.StringUtil;
import com.gallatinsystems.common.util.ZipUtil;
import com.gallatinsystems.survey.dao.CaddisflyResourceDao;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import org.akvo.flow.domain.DataUtils;
import org.akvo.flow.util.FlowJsonObjectReader;
import org.akvo.flow.util.JFreechartChartUtil;
import org.akvo.flow.xml.PublishedForm;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.waterforpeople.mapping.app.gwt.client.survey.OptionContainerDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionOptionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyGroupDto;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.SurveyInstanceDto;
import org.waterforpeople.mapping.app.web.dto.InstanceDataDto;
import org.waterforpeople.mapping.dataexport.ExportImportUtils;
import org.waterforpeople.mapping.dataexport.InstanceData;
import org.waterforpeople.mapping.dataexport.SurveySummaryExporter;
import org.waterforpeople.mapping.dataexport.service.BulkDataServiceClient;
import org.waterforpeople.mapping.domain.CaddisflyResource;
import org.waterforpeople.mapping.domain.CaddisflyResult;
import org.waterforpeople.mapping.domain.response.value.Media;
import org.waterforpeople.mapping.serialization.response.MediaResponse;

public class GraphicalSurveySummaryExporter
extends SurveySummaryExporter {
    private static final Logger log = Logger.getLogger(GraphicalSurveySummaryExporter.class.getName());
    private static final String IMAGE_PREFIX_OPT = "imgPrefix";
    private static final String TYPE_OPT = "exportMode";
    private static final String DATA_CLEANING_TYPE = "DATA_CLEANING";
    private static final String DATA_ANALYSIS_TYPE = "DATA_ANALYSIS";
    private static final String COMPREHENSIVE_TYPE = "COMPREHENSIVE";
    private static final String LAST_COLLECTION_OPT = "lastCollection";
    private static final String MAX_ROWS_OPT = "maxDataReportRows";
    private static final String FROM_OPT = "from";
    private static final String TO_OPT = "to";
    private static final String EMAIL_OPT = "email";
    private static final String UPLOAD_URL_OPT = "uploadUrl";
    private static final String UPLOAD_DIR_OPT = "uploadDir";
    private static final String PUBLISHED_OPT = "use PublishedForm";
    private static final String CADDISFLY_TESTS_FILE_URL_OPT = "caddisflyTestsFileUrl";
    private static final String DEFAULT_IMAGE_PREFIX = "http://waterforpeople.s3.amazonaws.com/images/";
    private static final String DIGEST_COLUMN = "NO_TITLE_DIGEST_COLUMN";
    private static final String REPORT_HEADER = "Survey Summary Report";
    private static final String FREQ_LABEL = "Frequency";
    private static final String PCT_LABEL = "Percent";
    private static final String SUMMARY_LABEL = "Summary";
    private static final String RAW_DATA_LABEL = "Raw Data";
    private static final String MEAN_LABEL = "Mean";
    private static final String MEDIAN_LABEL = "Median";
    private static final String MIN_LABEL = "Min";
    private static final String MAX_LABEL = "Max";
    private static final String VAR_LABEL = "Variance";
    private static final String STD_E_LABEL = "Std Error";
    private static final String STD_D_LABEL = "Std Deviation";
    private static final String TOTAL_LABEL = "Total";
    private static final String RANGE_LABEL = "Range";
    private static final int WORKBOOK_WINDOW = 100;
    private static final int CHART_WIDTH = 600;
    private static final int CHART_HEIGHT = 400;
    private static final int CHART_CELL_WIDTH = 10;
    private static final int CHART_CELL_HEIGHT = 22;
    private static final NumberFormat PCT_FMT = DecimalFormat.getPercentInstance();
    private static final int GEO_COLUMN_COUNT = 3;
    private CellStyle headerStyle;
    private CellStyle textStyle;
    private String imagePrefix;
    private String serverBase;
    private boolean includeSummarySheet;
    private boolean performGeoRollup;
    private boolean generateCharts;
    private boolean variableNamesInHeaders;
    private boolean splitIntoColumns;
    private boolean separateSheetsForRepeatableGroups;
    private boolean justCodes;
    private boolean doGroupHeaders;
    private boolean usePublishedForm = true;
    private Map<Long, QuestionDto> questionsById;
    private SurveyGroupDto surveyGroupDto;
    private boolean lastCollection = false;
    private CaddisflyResourceDao caddisflyResourceDao = new CaddisflyResourceDao();
    private String caddisflyTestsFileUrl;
    private String selectionFrom = null;
    private String selectionTo = null;
    private String selectionLimit = null;
    private String reportType = null;
    private Map<Long, Boolean> hasImageMap = new HashMap<Long, Boolean>();
    private Map<Long, List<Integer>> resultIdMap = new HashMap<Long, List<Integer>>();
    private Map<Long, List<QuestionOptionDto>> optionMap = new HashMap<Long, List<QuestionOptionDto>>();
    private Map<Long, Boolean> allowOtherMap = new HashMap<Long, Boolean>();
    private Map<String, Integer> optionsPositionCache = new HashMap<String, Integer>();
    private Map<String, Integer> columnIndexMap = new HashMap<String, Integer>();
    private Map<QuestionGroupDto, Sheet> qgSheetMap = new HashMap<QuestionGroupDto, Sheet>();
    private List<String> questionIdList = new ArrayList<String>();
    private List<String> unsummarizable = new ArrayList<String>();
    Map<String, CaddisflyResource> caddisflyResourceMap = null;
    private int totalInstances = 0;
    private int approvedInstances = 0;
    private Date firstSubmission = null;
    private Date lastSubmission = null;
    private Map<String, Integer> instancesByUser = new HashMap<String, Integer>();
    private Map<String, Integer> instancesByDevice = new HashMap<String, Integer>();
    private long totalDuration = 0L;
    private long minDuration = Long.MAX_VALUE;
    private long maxDuration = 0L;

    @Override
    public void export(Map<String, String> criteria, File fileName, String serverBaseUrl, Map<String, String> options) {
        String surveyId = criteria.get("surveyId").trim();
        String apiKey = criteria.get("apiKey").trim();
        String s3formDir = options.get(UPLOAD_URL_OPT) + options.get(UPLOAD_DIR_OPT);
        log.finest("### Export criteria=" + criteria.toString() + " filename=" + fileName.toString() + " options=" + options.toString());
        if (!this.processOptions(options)) {
            return;
        }
        this.questionsById = new HashMap<Long, QuestionDto>();
        this.surveyGroupDto = BulkDataServiceClient.fetchSurveyGroup(surveyId, serverBaseUrl, apiKey);
        this.serverBase = serverBaseUrl;
        this.orderedGroupList = new ArrayList();
        try {
            Map<QuestionGroupDto, List<QuestionDto>> questionMap = this.fetchQuestionMap(this.usePublishedForm, surveyId, serverBaseUrl, apiKey, s3formDir, this.orderedGroupList);
            if (questionMap.size() > 0) {
                for (List<QuestionDto> qList : questionMap.values()) {
                    for (QuestionDto questionDto : qList) {
                        this.questionsById.put(questionDto.getKeyId(), questionDto);
                    }
                }
                Workbook wb = this.createWorkbookAndFormats();
                Sheet baseSheet = this.createDataSheets(wb, this.orderedGroupList);
                SurveySummaryExporter.SummaryModel model = this.fetchAndWriteRawData(surveyId, questionMap, wb, baseSheet, this.includeSummarySheet, fileName, apiKey);
                if (this.includeSummarySheet) {
                    this.writeStatsAndGraphsSheet(questionMap, model, null, wb);
                }
                if (model.getSectorList() != null && model.getSectorList().size() > 0) {
                    Collections.sort(model.getSectorList(), new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            if (o1 != null && o2 != null) {
                                return o1.toLowerCase().compareTo(o2.toLowerCase());
                            }
                            return 0;
                        }
                    });
                    for (String sector : model.getSectorList()) {
                        this.writeStatsAndGraphsSheet(questionMap, model, sector, wb);
                    }
                }
                FileOutputStream fileOutputStream = new FileOutputStream(fileName);
                wb.setActiveSheet(this.includeSummarySheet ? wb.getNumberOfSheets() - 1 : 0);
                wb.write((OutputStream)fileOutputStream);
                fileOutputStream.close();
            } else {
                log.info("No questions for survey: " + criteria.get("surveyId") + " - instance: " + serverBaseUrl);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error generating report: " + e.getMessage(), e);
        }
    }

    private Workbook createWorkbookAndFormats() {
        SXSSFWorkbook wb = new SXSSFWorkbook(100);
        this.headerStyle = wb.createCellStyle();
        this.headerStyle.setAlignment(HorizontalAlignment.LEFT);
        Font headerFont = wb.createFont();
        headerFont.setBold(true);
        this.headerStyle.setFont(headerFont);
        short textFormat = wb.createDataFormat().getFormat("@");
        this.textStyle = wb.createCellStyle();
        this.textStyle.setDataFormat(textFormat);
        return wb;
    }

    private Sheet createDataSheets(Workbook wb, List<QuestionGroupDto> groupList) {
        Sheet baseSheet = wb.createSheet(RAW_DATA_LABEL);
        for (QuestionGroupDto groupDto : groupList) {
            if (!this.separateSheetsForRepeatableGroups || !this.safeTrue(groupDto.getRepeatable())) continue;
            Sheet repSheet = wb.createSheet("Group " + groupDto.getOrder());
            this.qgSheetMap.put(groupDto, repSheet);
        }
        return baseSheet;
    }

    private Map<QuestionGroupDto, List<QuestionDto>> fetchQuestionMap(boolean usingPublishedForm, String surveyId, String serverBaseUrl, String apiKey, String s3FormDir, List<QuestionGroupDto> groupList) throws Exception {
        Map<QuestionGroupDto, List<QuestionDto>> questionMap = null;
        if (!usingPublishedForm) {
            questionMap = this.loadAllQuestions(surveyId, this.performGeoRollup, serverBaseUrl, apiKey);
            this.loadQuestionOptions(surveyId, serverBaseUrl, questionMap, apiKey);
        } else {
            String fileName = s3FormDir + "/" + surveyId + ".zip";
            String formXml = null;
            URL url = new URL(fileName);
            log.finest("Getting form XML from " + url);
            URLConnection conn = url.openConnection();
            BufferedInputStream deviceZipFileInputStream = new BufferedInputStream(conn.getInputStream());
            ZipInputStream formFileStream = new ZipInputStream(deviceZipFileInputStream);
            formXml = ZipUtil.unZipFile(surveyId + ".xml", formFileStream);
            SurveyDto formDto = PublishedForm.parse(formXml).toDto();
            questionMap = new HashMap<QuestionGroupDto, List<QuestionDto>>();
            this.rollupOrder = new ArrayList();
            boolean anyQuestionsWithoutVariableNames = false;
            for (QuestionGroupDto qgd : formDto.getQuestionGroupList()) {
                ArrayList<QuestionDto> qList = new ArrayList<QuestionDto>();
                List<QuestionDto> questionList = qgd.getQuestionList();
                if (questionList != null) {
                    TreeMap<Integer, QuestionDto> qMap = new TreeMap<Integer, QuestionDto>();
                    for (QuestionDto q : questionList) {
                        qMap.put(q.getOrder(), q);
                    }
                    questionList = new ArrayList(qMap.values());
                    for (QuestionDto dto : questionList) {
                        qList.add(dto);
                        if (dto.getVariableName() == null) {
                            anyQuestionsWithoutVariableNames = true;
                        }
                        if (!this.performGeoRollup) continue;
                        for (int i = 0; i < ROLLUP_QUESTIONS.length; ++i) {
                            if (!ROLLUP_QUESTIONS[i].equalsIgnoreCase(dto.getText())) continue;
                            this.rollupOrder.add(dto);
                        }
                    }
                }
                questionMap.put(qgd, qList);
                groupList.add(qgd);
            }
            if (this.variableNamesInHeaders && anyQuestionsWithoutVariableNames) {
                this.loadVariableNames(surveyId, serverBaseUrl, questionMap, apiKey);
            }
        }
        return questionMap;
    }

    private boolean hasDataApproval() {
        return this.surveyGroupDto != null && this.safeTrue(this.surveyGroupDto.getRequireDataApproval()) && this.surveyGroupDto.getDataApprovalGroupId() != null;
    }

    private boolean safeTrue(Boolean b) {
        return b != null && b != false;
    }

    private String neverNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    protected SurveySummaryExporter.SummaryModel fetchAndWriteRawData(String surveyId, Map<QuestionGroupDto, List<QuestionDto>> questionMap, Workbook wb, Sheet baseSheet, boolean generateSummary, File outputFile, String apiKey) throws Exception {
        LinkedBlockingQueue<Runnable> jobQueue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(5, 5, 10L, TimeUnit.SECONDS, jobQueue);
        final AtomicLong threadsCompleted = new AtomicLong();
        final Object lock = new Object();
        SurveySummaryExporter.SummaryModel model = new SurveySummaryExporter.SummaryModel();
        final String key = apiKey;
        HashMap<String, String> collapseIdMap = new HashMap<String, String>();
        HashMap<String, String> nameToIdMap = new HashMap<String, String>();
        for (Map.Entry<QuestionGroupDto, List<QuestionDto>> groupEntry : questionMap.entrySet()) {
            for (QuestionDto questionDto : groupEntry.getValue()) {
                if (!this.safeTrue(questionDto.getCollapseable())) continue;
                if (collapseIdMap.get(this.safeQuestionText(questionDto)) == null) {
                    collapseIdMap.put(this.safeQuestionText(questionDto), questionDto.getKeyId().toString());
                }
                nameToIdMap.put(questionDto.getKeyId().toString(), this.safeQuestionText(questionDto));
            }
        }
        this.createRawDataHeader(wb, baseSheet, questionMap);
        Map<String, String> instanceMap = BulkDataServiceClient.fetchInstanceIds(surveyId, this.serverBase, key, this.lastCollection, this.selectionFrom, this.selectionTo, this.selectionLimit);
        final ArrayList<InstanceData> allData = new ArrayList<InstanceData>();
        int started = 0;
        for (Map.Entry<String, String> entry : instanceMap.entrySet()) {
            final String instanceId = entry.getKey();
            ++started;
            threadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean done = false;
                    for (int attempts = 0; !done && attempts < 10; ++attempts) {
                        try {
                            Map<Long, Map<Long, String>> responseMap = BulkDataServiceClient.fetchQuestionResponses(instanceId, GraphicalSurveySummaryExporter.this.serverBase, key);
                            InstanceDataDto instanceDataDto = BulkDataServiceClient.fetchInstanceData(Long.parseLong(instanceId.trim()), GraphicalSurveySummaryExporter.this.serverBase, key);
                            if (instanceDataDto.surveyInstanceData != null) {
                                done = true;
                            }
                            List list = allData;
                            synchronized (list) {
                                allData.add(new InstanceData(instanceDataDto, responseMap));
                                continue;
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "Error fetching instance data ", e);
                            continue;
                        }
                        finally {
                            Object object = lock;
                            synchronized (object) {
                                threadsCompleted.getAndIncrement();
                            }
                        }
                    }
                }
            });
        }
        while (!jobQueue.isEmpty() || threadPool.getActiveCount() > 0 || (long)started > threadsCompleted.get()) {
            try {
                log.finest("Sleeping, Queue has: " + jobQueue.size());
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                log.finest("Error thread sleep: " + exception.getMessage());
            }
        }
        this.sortDataOnCollectionDate(allData);
        this.analyseData(allData);
        for (InstanceData instanceData : allData) {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            if (this.separateSheetsForRepeatableGroups) {
                ArrayList<QuestionDto> baseSheetQuestions = new ArrayList<QuestionDto>();
                for (Map.Entry<QuestionGroupDto, List<QuestionDto>> groupEntry : questionMap.entrySet()) {
                    if (this.safeTrue(groupEntry.getKey().getRepeatable())) {
                        this.writeInstanceDataSplit(this.qgSheetMap.get(groupEntry.getKey()), instanceData, groupEntry.getValue(), digest, true);
                        continue;
                    }
                    baseSheetQuestions.addAll((Collection<QuestionDto>)groupEntry.getValue());
                }
                this.writeInstanceDataSplit(baseSheet, instanceData, baseSheetQuestions, digest, false);
                if (this.variableNamesInHeaders) continue;
                String digestStr = StringUtil.toHexString(digest.digest());
                this.createCell(this.getRow(baseSheet.getLastRowNum(), baseSheet), this.columnIndexMap.get(DIGEST_COLUMN), digestStr, null);
                continue;
            }
            int baseCurrentRow = baseSheet.getLastRowNum() + 1;
            baseCurrentRow = this.writeInstanceData(baseSheet, baseCurrentRow, instanceData, generateSummary, nameToIdMap, collapseIdMap, model);
        }
        threadPool.shutdown();
        return model;
    }

    private void sortDataOnCollectionDate(List<InstanceData> allData) {
        log.finest("Starting data sort");
        Collections.sort(allData, new Comparator<InstanceData>(){

            @Override
            public int compare(InstanceData o1, InstanceData o2) {
                return this.safeCompare(o1.surveyInstanceDto.getCollectionDate(), o2.surveyInstanceDto.getCollectionDate());
            }

            private int safeCompare(Date date1, Date date2) {
                if (date1 == null || date2 == null) {
                    return 0;
                }
                return date1.compareTo(date2);
            }
        });
        log.finest("Finished data sort");
    }

    private void analyseData(List<InstanceData> allData) {
        this.totalInstances = allData.size();
        for (InstanceData instance : allData) {
            Long durationSeconds;
            String u;
            SurveyInstanceDto sid = instance.surveyInstanceDto;
            if (sid.getApprovedFlag() != null && sid.getApprovedFlag().equalsIgnoreCase("true")) {
                ++this.approvedInstances;
            }
            Date cd = sid.getCollectionDate();
            if (this.firstSubmission == null || cd.before(this.firstSubmission)) {
                this.firstSubmission = cd;
            }
            if (this.lastSubmission == null || cd.after(this.lastSubmission)) {
                this.lastSubmission = cd;
            }
            if (this.instancesByUser.containsKey(u = sid.getSubmitterName())) {
                this.instancesByUser.put(u, this.instancesByUser.get(u) + 1);
            } else {
                this.instancesByUser.put(u, 1);
            }
            String dev = sid.getDeviceIdentifier();
            if (this.instancesByDevice.containsKey(dev)) {
                this.instancesByDevice.put(dev, this.instancesByDevice.get(dev) + 1);
            } else {
                this.instancesByDevice.put(dev, 1);
            }
            if ((durationSeconds = sid.getSurveyalTime()) == null) continue;
            this.totalDuration += durationSeconds.longValue();
            this.maxDuration = Math.max(this.maxDuration, durationSeconds);
            this.minDuration = Math.min(this.minDuration, durationSeconds);
        }
    }

    private synchronized void writeInstanceDataSplit(Sheet sheet, InstanceData instanceData, List<QuestionDto> whichQuestions, MessageDigest md, boolean groupSheet) throws NoSuchAlgorithmException {
        int startRow = sheet.getLastRowNum() + 1;
        TreeSet<Long> iterationsOnThisSheet = new TreeSet<Long>();
        if (!groupSheet) {
            iterationsOnThisSheet.add(0L);
        }
        for (QuestionDto qd : whichQuestions) {
            Long questionId = qd.getKeyId();
            SortedMap<Long, String> iterationsMap = instanceData.responseMap.get(questionId);
            if (iterationsMap == null) continue;
            iterationsOnThisSheet.addAll(iterationsMap.keySet());
        }
        int rowOffset = 0;
        Iterator iterator = iterationsOnThisSheet.iterator();
        while (iterator.hasNext()) {
            long i = (Long)iterator.next();
            Row iterationRow = this.getRow(startRow + rowOffset, sheet);
            this.writeMetadataRow(iterationRow, instanceData, (int)i + 1, groupSheet);
            for (QuestionDto qd : whichQuestions) {
                String val;
                Long questionId = qd.getKeyId();
                SortedMap<Long, String> iterationsMap = instanceData.responseMap.get(questionId);
                if (iterationsMap == null || (val = (String)iterationsMap.get(i)) == null) continue;
                this.writeAnswer(iterationRow, this.columnIndexMap.get(questionId.toString()), qd, val);
            }
            for (Cell cell : iterationRow) {
                String val = ExportImportUtils.parseCellAsString(cell);
                if (val == null || val.equals("")) continue;
                md.update(val.getBytes());
            }
            ++rowOffset;
        }
    }

    private void writeMetadataRow(Row r, InstanceData instanceData, int iteration, boolean showRepeatColumn) {
        SurveyInstanceDto dto = instanceData.surveyInstanceDto;
        int col = 0;
        this.createCell(r, col++, dto.getSurveyedLocaleIdentifier());
        if (this.hasDataApproval()) {
            this.createCell(r, col++, instanceData.latestApprovalStatus);
        }
        if (showRepeatColumn) {
            this.createCell(r, col++, String.valueOf(iteration), null, 0);
        }
        this.createCell(r, col++, dto.getSurveyedLocaleDisplayName());
        this.createCell(r, col++, dto.getDeviceIdentifier());
        this.createCell(r, col++, dto.getKeyId().toString());
        this.createCell(r, col++, ExportImportUtils.formatDateTime(dto.getCollectionDate()));
        this.createCell(r, col++, this.sanitize(dto.getSubmitterName()));
        String duration = this.getDurationText(dto.getSurveyalTime());
        this.createCell(r, col++, duration);
        Double v = dto.getFormVersion();
        if (v != null) {
            this.createCell(r, col++, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int writeInstanceData(Sheet sheet, int startRow, InstanceData instanceData, boolean generateSummary, Map<String, String> nameToIdMap, Map<String, String> collapseIdMap, SurveySummaryExporter.SummaryModel model) {
        int rowOffset = 0;
        for (long i : instanceData.iterationsPresent) {
            Row iterationRow = this.getRow(startRow + rowOffset, sheet);
            this.writeMetadataRow(iterationRow, instanceData, (int)i + 1, true);
            for (String q : this.questionIdList) {
                String val;
                Long questionId = Long.valueOf(q);
                QuestionDto questionDto = this.questionsById.get(questionId);
                SortedMap<Long, String> iterationsMap = instanceData.responseMap.get(questionId);
                if (iterationsMap == null || (val = (String)iterationsMap.get(i)) == null) continue;
                this.writeAnswer(iterationRow, this.columnIndexMap.get(q), questionDto, val);
            }
            ++rowOffset;
        }
        int maxRow = startRow + rowOffset;
        HashMap<String, String> responseMap = new HashMap<String, String>();
        for (Map.Entry<Long, SortedMap<Long, String>> entry : instanceData.responseMap.entrySet()) {
            String questionId = entry.getKey().toString();
            Collection<String> iterations = entry.getValue().values();
            if (iterations.isEmpty()) continue;
            String response = iterations.iterator().next();
            responseMap.put(questionId, response);
        }
        if (generateSummary && responseMap != null) {
            Set<String> rollups = null;
            if (this.rollupOrder != null && this.rollupOrder.size() > 0) {
                rollups = this.formRollupStrings(responseMap);
            }
            FlowJsonObjectReader jsonReader = new FlowJsonObjectReader();
            TypeReference<List<Map<String, String>>> typeReference = new TypeReference<List<Map<String, String>>>(){};
            for (Map.Entry entry : responseMap.entrySet()) {
                String[] vals;
                if (this.unsummarizable.contains(entry.getKey())) continue;
                String effectiveId = (String)entry.getKey();
                if (nameToIdMap.get(effectiveId) != null) {
                    effectiveId = collapseIdMap.get(nameToIdMap.get(effectiveId));
                }
                if (((String)entry.getValue()).startsWith("[")) {
                    try {
                        List<Map<String, String>> optionNodes = jsonReader.readObject((String)entry.getValue(), typeReference);
                        ArrayList<String> valsList = new ArrayList<String>();
                        for (Map<String, String> optionNode : optionNodes) {
                            if (optionNode.containsKey("text")) {
                                valsList.add(optionNode.get("text"));
                                continue;
                            }
                            if (!optionNode.containsKey("name")) continue;
                            valsList.clear();
                            valsList.add(optionNode.get("name"));
                        }
                        vals = valsList.toArray(new String[valsList.size()]);
                    }
                    catch (IOException e) {
                        vals = ((String)entry.getValue()).split("\\|");
                    }
                } else {
                    vals = ((String)entry.getValue()).split("\\|");
                }
                SurveySummaryExporter.SummaryModel summaryModel = model;
                synchronized (summaryModel) {
                    for (int j = 0; j < vals.length; ++j) {
                        if (vals[j] == null || vals[j].trim().length() <= 0) continue;
                        QuestionDto q = this.questionsById.get(Long.valueOf(effectiveId));
                        model.tallyResponse(effectiveId, rollups, vals[j], q);
                    }
                }
            }
        }
        return maxRow + 1;
    }

    private void writeAnswer(@Nonnull Row row, int startColumn, @Nonnull QuestionDto questionDto, @Nonnull String value) {
        assert (value != null);
        ArrayList<String> cells = new ArrayList<String>();
        QuestionDto.QuestionType questionType = questionDto.getType();
        switch (questionType) {
            case DATE: {
                cells.add(GraphicalSurveySummaryExporter.dateCellValue(value));
                break;
            }
            case PHOTO: 
            case VIDEO: {
                cells.addAll(this.mediaCellValues(value, this.imagePrefix));
                break;
            }
            case GEO: {
                cells.addAll(GraphicalSurveySummaryExporter.geoCellValues(value));
                break;
            }
            case GEOSHAPE: {
                cells.add(GraphicalSurveySummaryExporter.geoShapeValue(value));
                break;
            }
            case CASCADE: {
                if (questionDto.getLevelNames() != null) {
                    cells.addAll(this.cascadeCellValues(value, questionDto.getLevelNames().size()));
                    break;
                }
                log.warning("No CASCADE resource for question '" + questionDto.getText() + "'");
                break;
            }
            case OPTION: {
                Long qId = questionDto.getKeyId();
                cells.addAll(this.optionCellValues(questionDto.getKeyId(), value, this.optionMap.get(qId), this.safeTrue(this.allowOtherMap.get(qId)), this.safeTrue(questionDto.getAllowMultipleFlag())));
                break;
            }
            case CADDISFLY: {
                Long qId = questionDto.getKeyId();
                boolean hasMap = this.safeTrue(this.hasImageMap.get(qId));
                cells.addAll(this.caddisflyCellValues(qId, value, hasMap, this.imagePrefix));
                break;
            }
            default: {
                cells.add(this.sanitize(value));
            }
        }
        int col = startColumn;
        for (String cellValue : cells) {
            if (questionType == QuestionDto.QuestionType.NUMBER) {
                if (cellValue.length() < 16) {
                    this.createCell(row, col, cellValue, null, 0);
                } else {
                    this.createCell(row, col, cellValue, this.textStyle);
                }
            } else if (questionType == QuestionDto.QuestionType.PHOTO) {
                if (col == startColumn) {
                    this.createCell(row, col, cellValue, this.textStyle);
                } else {
                    this.createCell(row, col, cellValue, null, 0);
                }
            } else if (questionType == QuestionDto.QuestionType.OPTION && (cellValue.equals("0") || cellValue.equals("1"))) {
                this.createCell(row, col, cellValue, null, 0);
            } else {
                this.createCell(row, col, cellValue, this.textStyle);
            }
            ++col;
        }
    }

    private static String dateCellValue(String value) {
        return ExportImportUtils.formatDateResponse(value);
    }

    private List<String> mediaCellValues(String value, String imagePrefix) {
        ArrayList<String> cells = new ArrayList<String>();
        Media media = MediaResponse.parse(value);
        String filename = media.getFilename();
        if (filename != null && (filename = Paths.get(filename, new String[0]).getFileName().toString()).length() > 0) {
            cells.add(imagePrefix + filename);
            if (this.splitIntoColumns && media.getLocation() != null) {
                cells.add(Double.toString(media.getLocation().getLatitude()));
                cells.add(Double.toString(media.getLocation().getLongitude()));
                cells.add(Double.toString(media.getLocation().getAccuracy()));
            }
        }
        return cells;
    }

    private static List<String> geoCellValues(String value) {
        String[] geoParts = value.split("\\|");
        ArrayList<String> cells = new ArrayList<String>();
        int count = 0;
        int partsToCopy = Math.min(geoParts.length, 3);
        for (count = 0; count < partsToCopy; ++count) {
            cells.add(geoParts[count]);
        }
        for (int j = count; j < 3; ++j) {
            cells.add("");
        }
        return cells;
    }

    protected static String geoShapeValue(String value) {
        if (value.length() > SpreadsheetVersion.EXCEL2007.getMaxTextLength()) {
            return value.substring(0, SpreadsheetVersion.EXCEL2007.getMaxTextLength());
        }
        return value;
    }

    private static boolean validateCaddisflyValue(Map<String, Object> caddisflyResponseMap, boolean hasImage) {
        if (caddisflyResponseMap.get("uuid") == null || caddisflyResponseMap.get("result") == null) {
            return false;
        }
        if (hasImage && caddisflyResponseMap.get("image") == null) {
            return false;
        }
        List results = (List)caddisflyResponseMap.get("result");
        for (Map result : results) {
            if (result.get("id") != null && result.get("value") != null) continue;
            return false;
        }
        return true;
    }

    private List<String> caddisflyCellValues(Long questionId, String value, boolean hasImage, String imagePrefix) {
        ArrayList<String> caddisflyCellValues = new ArrayList<String>();
        List<Integer> resultIds = this.resultIdMap.get(questionId);
        Map<String, Object> caddisflyResponseMap = DataUtils.parseCaddisflyResponseValue(value);
        if (!GraphicalSurveySummaryExporter.validateCaddisflyValue(caddisflyResponseMap, hasImage)) {
            for (int i = 0; i < resultIds.size(); ++i) {
                caddisflyCellValues.add("");
            }
            if (hasImage) {
                caddisflyCellValues.add("");
            }
            return caddisflyCellValues;
        }
        List caddisflyTestResultsList = (List)caddisflyResponseMap.get("result");
        Map<Integer, Map<String, Object>> caddisflyTestResultsMap = this.mapCaddisflyResultsById(caddisflyTestResultsList);
        if (resultIds != null) {
            for (Integer resultId : resultIds) {
                Map<String, Object> caddisflyTestResult = caddisflyTestResultsMap.get(resultId);
                if (caddisflyTestResult != null) {
                    String testValue = "" + caddisflyTestResult.get("value");
                    caddisflyCellValues.add(testValue);
                    continue;
                }
                caddisflyCellValues.add("");
            }
        }
        if (hasImage) {
            String imageName = (String)caddisflyResponseMap.get("image");
            if (imageName == null) {
                caddisflyCellValues.add("");
            } else {
                caddisflyCellValues.add(imagePrefix + imageName);
            }
        }
        return caddisflyCellValues;
    }

    private Map<Integer, Map<String, Object>> mapCaddisflyResultsById(List<Map<String, Object>> caddisflyTestResults) {
        HashMap<Integer, Map<String, Object>> resultsMap = new HashMap<Integer, Map<String, Object>>();
        for (Map<String, Object> result : caddisflyTestResults) {
            resultsMap.put((Integer)result.get("id"), result);
        }
        return resultsMap;
    }

    private List<String> cascadeCellValues(String value, int levels) {
        String code;
        ArrayList<String> cells = new ArrayList<String>();
        List<Object> cascadeNodes = new ArrayList();
        if (value.startsWith("[")) {
            String[] jsonReader = new FlowJsonObjectReader();
            TypeReference<List<Map<String, String>>> typeReference = new TypeReference<List<Map<String, String>>>(){};
            try {
                cascadeNodes = jsonReader.readObject(value, typeReference);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Unable to parse CASCADE response - " + value, e);
            }
        } else if (!value.isEmpty()) {
            for (String string : value.split("\\|")) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("name", string);
                cascadeNodes.add(m);
            }
        }
        boolean allCodesEqualsName = true;
        for (Object cascadeNode : cascadeNodes) {
            String string = (String)cascadeNode.get("code");
            String name = (String)cascadeNode.get("name");
            if (string == null || string.equalsIgnoreCase(name)) continue;
            allCodesEqualsName = false;
            break;
        }
        if (allCodesEqualsName) {
            for (Object cascadeNode : cascadeNodes) {
                cascadeNode.put("code", null);
            }
        }
        if (this.splitIntoColumns) {
            int padCount = levels - cascadeNodes.size();
            for (Map map : cascadeNodes) {
                code = (String)map.get("code");
                String name = (String)map.get("name");
                String nodeVal = code != null && !code.isEmpty() ? (this.justCodes ? code : code + ":" + name) : name;
                if (cells.size() == levels) {
                    String currentVal = (String)cells.get(cells.size() - 1);
                    cells.add(cells.size() - 1, currentVal + "|" + nodeVal);
                    continue;
                }
                cells.add(nodeVal);
            }
            for (int p = 0; p < padCount; ++p) {
                cells.add("");
            }
        } else {
            StringBuilder cascadeString = new StringBuilder();
            for (Map map : cascadeNodes) {
                code = (String)map.get("code");
                String name = (String)map.get("name");
                cascadeString.append("|");
                if (code != null && !code.isEmpty()) {
                    if (this.justCodes) {
                        cascadeString.append(code);
                        continue;
                    }
                    cascadeString.append(code + ":" + name);
                    continue;
                }
                cascadeString.append(name);
            }
            if (cascadeString.length() > 0) {
                cascadeString.deleteCharAt(0);
            }
            cells.add(cascadeString.toString());
        }
        return cells;
    }

    private List<Map<String, String>> getNodes(String value) {
        boolean isNewFormat = value.startsWith("[");
        ArrayList<Map<String, String>> optionNodes = new ArrayList();
        FlowJsonObjectReader jsonReader = new FlowJsonObjectReader();
        TypeReference<List<Map<String, String>>> typeReference = new TypeReference<List<Map<String, String>>>(){};
        if (isNewFormat) {
            try {
                optionNodes = jsonReader.readObject(value, typeReference);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Could not parse option response: " + value, e);
            }
        } else {
            String[] texts;
            for (String text : texts = value.split("\\|")) {
                HashMap<String, String> node = new HashMap<String, String>();
                node.put("text", text.trim());
                optionNodes.add(node);
            }
        }
        return optionNodes;
    }

    private String buildOptionString(List<Map<String, String>> optionNodes) {
        StringBuilder optionString = new StringBuilder();
        for (Map<String, String> node : optionNodes) {
            String code = node.get("code");
            String text = node.get("text");
            optionString.append("|");
            if (code != null) {
                if (this.justCodes) {
                    optionString.append(code);
                    continue;
                }
                optionString.append(code + ":" + text);
                continue;
            }
            optionString.append(text);
        }
        if (optionString.length() > 0) {
            optionString.deleteCharAt(0);
        }
        return optionString.toString();
    }

    private List<String> optionCellValues(Long questionId, String value, List<QuestionOptionDto> options, boolean allowOther, boolean allowMultiple) {
        ArrayList<String> cells = new ArrayList<String>();
        if (options == null) {
            return cells;
        }
        List<Map<String, String>> optionNodes = this.getNodes(value);
        Map<String, String> otherNode = null;
        String other = null;
        int numOptions = options.size();
        boolean[] optionFound = new boolean[numOptions];
        if (allowOther || this.splitIntoColumns && allowMultiple) {
            String qId = questionId.toString();
            for (Map<String, String> optAnswer : optionNodes) {
                int i;
                String text = this.neverNull(optAnswer.get("text"));
                String code = this.neverNull(optAnswer.get("code"));
                boolean found = false;
                String cacheId = qId + text + code;
                if (this.optionsPositionCache.containsKey(cacheId)) {
                    optionFound[this.optionsPositionCache.get((Object)cacheId).intValue()] = true;
                    found = true;
                }
                if (!found) {
                    for (i = 0; i < numOptions; ++i) {
                        if (text == null || text.length() <= 0 || !text.equalsIgnoreCase(options.get(i).getText())) continue;
                        optionFound[i] = true;
                        found = true;
                        this.optionsPositionCache.put(cacheId, i);
                        break;
                    }
                }
                if (!found) {
                    for (i = 0; i < numOptions; ++i) {
                        if (code == null || code.length() <= 0 || !code.equalsIgnoreCase(options.get(i).getCode())) continue;
                        optionFound[i] = true;
                        found = true;
                        this.optionsPositionCache.put(cacheId, i);
                        break;
                    }
                }
                if (found) continue;
                otherNode = optAnswer;
                other = text;
            }
        }
        if (otherNode != null) {
            optionNodes.remove(otherNode);
        }
        String optionString = this.buildOptionString(optionNodes);
        cells.add(optionString);
        if (this.variableNamesInHeaders && allowMultiple) {
            for (int i = 0; i < numOptions; ++i) {
                cells.add(optionFound[i] ? "1" : "0");
            }
        }
        if (allowOther) {
            cells.add(other != null ? other : "");
        }
        return cells;
    }

    private String sanitize(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("\n", " ").replaceAll("\t", "").trim();
    }

    protected void createRawDataHeader(Workbook wb, Sheet baseSheet, Map<QuestionGroupDto, List<QuestionDto>> questionMap) {
        int columnIdx = this.addMetaDataHeaders(baseSheet, !this.separateSheetsForRepeatableGroups);
        if (questionMap != null) {
            int offset = ++columnIdx;
            for (QuestionGroupDto grpDto : this.orderedGroupList) {
                if (questionMap.get(grpDto) == null) continue;
                if (this.qgSheetMap.containsKey(grpDto)) {
                    Sheet groupSheet = this.qgSheetMap.get(grpDto);
                    int metaEnd = this.addMetaDataHeaders(groupSheet, true);
                    this.writeRawDataGroupHeaders(groupSheet, grpDto, questionMap.get(grpDto), metaEnd + 1);
                    continue;
                }
                offset = this.writeRawDataGroupHeaders(baseSheet, grpDto, questionMap.get(grpDto), offset);
            }
            this.columnIndexMap.put(DIGEST_COLUMN, offset);
        }
    }

    private int addMetaDataHeaders(Sheet sheet, boolean showRepeatColumn) {
        Row row = this.getRow(this.doGroupHeaders ? 1 : 0, sheet);
        int columnIdx = -1;
        this.addMetaDataColumnHeader("Identifier", ++columnIdx, row);
        if (this.hasDataApproval()) {
            this.addMetaDataColumnHeader("Data approval status", ++columnIdx, row);
        }
        if (showRepeatColumn) {
            this.addMetaDataColumnHeader("Repeat no", ++columnIdx, row);
        }
        this.addMetaDataColumnHeader("Display Name", ++columnIdx, row);
        this.addMetaDataColumnHeader("Device identifier", ++columnIdx, row);
        this.addMetaDataColumnHeader("Instance", ++columnIdx, row);
        this.addMetaDataColumnHeader("Submission Date", ++columnIdx, row);
        this.addMetaDataColumnHeader("Submitter", ++columnIdx, row);
        this.addMetaDataColumnHeader("Duration", ++columnIdx, row);
        this.addMetaDataColumnHeader("Form version", ++columnIdx, row);
        if (this.doGroupHeaders) {
            row = this.getRow(0, sheet);
            this.addMetaDataColumnHeader("Metadata", 0, row);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, columnIdx));
        }
        return columnIdx;
    }

    private void addMetaDataColumnHeader(String columnHeaderName, int columnIdx, Row row) {
        this.createCell(row, columnIdx, columnHeaderName, this.headerStyle);
    }

    private int writeRawDataGroupHeaders(Sheet sheet, QuestionGroupDto grpDto, List<QuestionDto> questions, int startOffset) {
        int offset = startOffset;
        Row row = this.getRow(this.doGroupHeaders ? 1 : 0, sheet);
        for (QuestionDto q : questions) {
            this.questionIdList.add(q.getKeyId().toString());
            String varName = q.getVariableName();
            boolean useVarName = this.variableNamesInHeaders && varName != null && !varName.equals("");
            this.columnIndexMap.put(q.getKeyId().toString(), offset);
            if (QuestionDto.QuestionType.GEO == q.getType()) {
                offset = this.addGeoDataColumnHeaders(q, row, offset, varName, this.variableNamesInHeaders, useVarName);
            } else if (QuestionDto.QuestionType.PHOTO == q.getType()) {
                offset = this.addPhotoDataColumnHeader(q, row, offset, varName, this.splitIntoColumns, useVarName);
            } else if (QuestionDto.QuestionType.CASCADE == q.getType() && q.getLevelNames() != null && this.splitIntoColumns) {
                for (String level : q.getLevelNames()) {
                    String levelName = useVarName ? varName + "_" + level.replaceAll(" ", "_") : this.safeQuestionText(q) + " - " + level;
                    this.createHeaderCell(row, offset++, levelName);
                }
            } else if (QuestionDto.QuestionType.CADDISFLY == q.getType()) {
                offset = this.addCaddisflyDataHeaderColumns(q, row, offset, varName, useVarName);
            } else {
                String text;
                String header = "";
                if (useVarName) {
                    header = varName;
                } else if (this.variableNamesInHeaders) {
                    text = this.safeQuestionText(q);
                    header = text.replaceAll("\n", "").trim();
                } else {
                    text = this.safeQuestionText(q);
                    String replaced = text.replaceAll("\n", "");
                    header = q.getKeyId().toString() + "|" + replaced.trim();
                }
                this.createHeaderCell(row, offset++, header);
                if (QuestionDto.QuestionType.OPTION == q.getType()) {
                    offset = this.addExtraOptionColumnHeaders(header, offset, row, q);
                }
            }
            if (QuestionDto.QuestionType.NUMBER == q.getType() || QuestionDto.QuestionType.OPTION == q.getType() || QuestionDto.QuestionType.CASCADE == q.getType()) continue;
            this.unsummarizable.add(q.getKeyId().toString());
        }
        if (this.doGroupHeaders && questions != null && questions.size() > 1) {
            this.createCell(this.getRow(0, sheet), startOffset, "Group " + grpDto.getOrder() + " - " + grpDto.getCode(), this.headerStyle);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, startOffset, offset - 1));
        }
        return offset;
    }

    private String safeQuestionText(QuestionDto q) {
        String text = q.getText();
        if (text == null) {
            text = "";
        }
        return text;
    }

    private int addCaddisflyDataHeaderColumns(QuestionDto q, Row row, int originalOffset, String variableName, boolean useVariableName) {
        int offset = originalOffset;
        StringBuilder caddisflyFirstResultColumnHeaderPrefix = new StringBuilder();
        if (useVariableName) {
            caddisflyFirstResultColumnHeaderPrefix.append(variableName);
        } else {
            caddisflyFirstResultColumnHeaderPrefix.append(q.getKeyId());
        }
        caddisflyFirstResultColumnHeaderPrefix.append("|").append(this.safeQuestionText(q)).append("|");
        if (this.caddisflyResourceMap == null) {
            this.caddisflyResourceMap = new HashMap<String, CaddisflyResource>();
            for (CaddisflyResource r : this.retrieveCaddisflyTestsDefinitions()) {
                this.caddisflyResourceMap.put(r.getUuid().trim(), r);
            }
        }
        CaddisflyResource cr = null;
        String resId = q.getCaddisflyResourceUuid();
        if (resId != null) {
            cr = this.caddisflyResourceMap.get(resId.trim());
        }
        if (cr != null) {
            List<CaddisflyResult> crResults = cr.getResults();
            Collections.sort(crResults);
            ArrayList<Integer> resultIds = new ArrayList<Integer>();
            for (int i = 0; i < crResults.size(); ++i) {
                CaddisflyResult result = crResults.get(i);
                resultIds.add(result.getId());
                StringBuilder columnHeaderSuffix = new StringBuilder(result.getName());
                if (result.getUnit() != null && !result.getUnit().isEmpty()) {
                    columnHeaderSuffix.append("(").append(result.getUnit()).append(")");
                }
                String columnHeader = i == 0 ? caddisflyFirstResultColumnHeaderPrefix.toString() + columnHeaderSuffix : "--CADDISFLY--|" + columnHeaderSuffix;
                this.createHeaderCell(row, offset++, columnHeader);
            }
            if (Boolean.TRUE.equals(cr.getHasImage())) {
                this.createHeaderCell(row, offset++, "--CADDISFLY--|" + this.safeQuestionText(q) + "--" + "Image");
            }
            this.resultIdMap.put(q.getKeyId(), resultIds);
            this.hasImageMap.put(q.getKeyId(), Boolean.TRUE.equals(cr.getHasImage()));
        }
        return offset;
    }

    private List<CaddisflyResource> retrieveCaddisflyTestsDefinitions() {
        if (this.caddisflyTestsFileUrl == null || this.caddisflyTestsFileUrl.isEmpty()) {
            return this.caddisflyResourceDao.listResources();
        }
        return this.caddisflyResourceDao.listResources(this.caddisflyTestsFileUrl);
    }

    private int addPhotoDataColumnHeader(QuestionDto q, Row row, int originalOffset, String variableName, boolean analysisFormat, boolean useVariableName) {
        int offset = originalOffset;
        String header = "";
        header = useVariableName ? variableName : (analysisFormat ? this.safeQuestionText(q).replaceAll("\n", "").trim() : q.getKeyId().toString() + "|" + this.safeQuestionText(q).replaceAll("\n", "").trim());
        this.createHeaderCell(row, offset++, header);
        if (analysisFormat) {
            String prefix = "--PHOTO--|";
            this.createHeaderCell(row, offset++, prefix + "Latitude");
            this.createHeaderCell(row, offset++, prefix + "Longitude");
            this.createHeaderCell(row, offset++, prefix + "Accuracy (m)");
        }
        return offset;
    }

    private int addGeoDataColumnHeaders(QuestionDto q, Row row, int originalOffset, String variableName, boolean analysisFormat, boolean useVariableName) {
        int offset = originalOffset;
        if (analysisFormat) {
            if (useVariableName) {
                this.createHeaderCell(row, offset++, variableName + "_" + "Latitude");
                this.createHeaderCell(row, offset++, variableName + "_" + "Longitude");
                this.createHeaderCell(row, offset++, variableName + "_" + "Elevation");
            } else {
                this.createHeaderCell(row, offset++, this.safeQuestionText(q) + " - " + "Latitude");
                this.createHeaderCell(row, offset++, this.safeQuestionText(q) + " - " + "Longitude");
                this.createHeaderCell(row, offset++, this.safeQuestionText(q) + " - " + "Elevation");
            }
        } else {
            this.createHeaderCell(row, offset++, q.getKeyId() + "|" + "Latitude");
            this.createHeaderCell(row, offset++, "--GEOLON--|Longitude");
            this.createHeaderCell(row, offset++, "--GEOELE--|Elevation");
        }
        return offset;
    }

    private int addExtraOptionColumnHeaders(String header, int initialOffset, Row row, QuestionDto q) {
        ArrayList<QuestionOptionDto> qoList;
        int offset = initialOffset;
        OptionContainerDto ocDto = q.getOptionContainerDto();
        if (ocDto != null && (qoList = ocDto.getOptionsList()) != null) {
            if (this.splitIntoColumns & this.safeTrue(q.getAllowMultipleFlag())) {
                for (QuestionOptionDto qo : qoList) {
                    String hdr = qo.getCode() != null && !qo.getCode().equals("null") && qo.getCode().length() > 0 ? qo.getCode() + ":" : "";
                    this.createHeaderCell(row, offset++, "--OPTION--|" + hdr + qo.getText());
                }
            }
            if (this.safeTrue(q.getAllowOtherFlag())) {
                this.createHeaderCell(row, offset++, header + "--OTHER--");
            }
            this.optionMap.put(q.getKeyId(), qoList);
            this.allowOtherMap.put(q.getKeyId(), q.getAllowOtherFlag());
        }
        return offset;
    }

    private void writeStatsAndGraphsSheet(Map<QuestionGroupDto, List<QuestionDto>> questionMap, SurveySummaryExporter.SummaryModel summaryModel, String sector, Workbook wb) throws Exception {
        int variableNameColumnIndex = 3;
        int descriptiveStatsColumnIndex = 4;
        String title = sector == null ? SUMMARY_LABEL : sector;
        Sheet sheet = null;
        int sheetCount = 2;
        String curTitle = WorkbookUtil.createSafeSheetName((String)title);
        while (sheet == null) {
            sheet = wb.getSheet(curTitle);
            if (sheet == null) {
                sheet = wb.createSheet(curTitle);
                continue;
            }
            sheet = null;
            curTitle = WorkbookUtil.createSafeSheetName((String)(title.substring(0, Math.min(title.length(), 27)) + " " + sheetCount));
            if (++sheetCount < 1000) continue;
            throw new Exception("Could not create unique sheet name after 1000 tries.");
        }
        CreationHelper creationHelper = wb.getCreationHelper();
        Drawing patriarch = sheet.createDrawingPatriarch();
        int rowIndex = 0;
        Row row = this.getRow(rowIndex++, sheet);
        if (sector == null) {
            this.createCell(row, 0, REPORT_HEADER, this.headerStyle);
            rowIndex = this.writeCollectionStats(questionMap, sheet, rowIndex);
        } else {
            this.createCell(row, 0, sector + " " + REPORT_HEADER, this.headerStyle);
        }
        for (QuestionGroupDto group : this.orderedGroupList) {
            if (questionMap.get(group) == null) continue;
            for (QuestionDto question : questionMap.get(group)) {
                boolean doDescriptiveStats = false;
                boolean doChart = false;
                boolean doDataTable = false;
                if (QuestionDto.QuestionType.OPTION == question.getType()) {
                    doChart = true;
                    doDataTable = true;
                } else if (QuestionDto.QuestionType.CASCADE == question.getType()) {
                    doChart = true;
                    doDataTable = true;
                } else {
                    if (QuestionDto.QuestionType.NUMBER != question.getType()) continue;
                    doDescriptiveStats = true;
                }
                if (summaryModel.getResponseCountsForQuestion(question.getKeyId(), sector).size() == 0) continue;
                int tableTopRow = rowIndex++;
                int bottomRow = rowIndex;
                row = this.getRow(tableTopRow, sheet);
                sheet.addMergedRegion(new CellRangeAddress(rowIndex - 1, rowIndex - 1, 0, 2));
                this.createCell(row, 0, question.getText(), this.headerStyle);
                this.createCell(row, 3, question.getVariableName(), this.headerStyle);
                SurveySummaryExporter.DescriptiveStats stats = summaryModel.getDescriptiveStatsForQuestion(question.getKeyId(), sector);
                if (doDescriptiveStats && stats != null && stats.getSampleCount() > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(rowIndex - 1, rowIndex - 1, 4, 5));
                    this.createCell(row, 4, question.getText(), this.headerStyle);
                }
                Map<String, Long> counts = summaryModel.getResponseCountsForQuestion(question.getKeyId(), sector);
                int sampleTotal = 0;
                ArrayList<String> labels = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                for (Map.Entry<String, Long> count : counts.entrySet()) {
                    String labelText = count.getKey();
                    if (labelText == null) {
                        labelText = "";
                    } else if (labelText.startsWith("[")) {
                        FlowJsonObjectReader jsonReader = new FlowJsonObjectReader();
                        TypeReference<List<Map<String, String>>> typeReference = new TypeReference<List<Map<String, String>>>(){};
                        try {
                            List<Map<String, String>> optionNodes = jsonReader.readObject(labelText, typeReference);
                            StringBuilder labelTextBuilder = new StringBuilder();
                            for (Map<String, String> optionNode : optionNodes) {
                                labelTextBuilder.append("|");
                                labelTextBuilder.append(optionNode.get("text"));
                            }
                            if (labelTextBuilder.length() > 0) {
                                labelTextBuilder.deleteCharAt(0);
                            }
                            labelText = labelTextBuilder.toString();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    labels.add(labelText);
                    values.add(count.getValue().toString());
                    sampleTotal = (int)((long)sampleTotal + count.getValue());
                }
                if (doDescriptiveStats && stats != null && stats.getSampleCount() > 0) {
                    int tempRow = tableTopRow + 1;
                    int c1 = 4;
                    int c2 = c1 + 1;
                    row = this.getRow(tempRow++, sheet);
                    this.createCell(row, c1, "N");
                    this.createCell(row, c2, sampleTotal);
                    row = this.getRow(tempRow++, sheet);
                    this.createCell(row, c1, MEAN_LABEL);
                    this.createCell(row, c2, stats.getMean());
                    row = this.getRow(tempRow++, sheet);
                    this.createCell(row, c1, STD_E_LABEL);
                    this.createCell(row, c2, stats.getStandardError());
                    row = this.getRow(tempRow++, sheet);
                    this.createCell(row, c1, MEDIAN_LABEL);
                    this.createCell(row, c2, stats.getMedian());
                    row = this.getRow(tempRow++, sheet);
                    this.createCell(row, c1, STD_D_LABEL);
                    this.createCell(row, c2, stats.getStandardDeviation());
                    row = this.getRow(tempRow++, sheet);
                    this.createCell(row, c1, VAR_LABEL);
                    this.createCell(row, c2, stats.getVariance());
                    row = this.getRow(tempRow++, sheet);
                    this.createCell(row, c1, RANGE_LABEL);
                    this.createCell(row, c2, stats.getRange());
                    row = this.getRow(tempRow++, sheet);
                    this.createCell(row, c1, MIN_LABEL);
                    this.createCell(row, c2, stats.getMin());
                    row = this.getRow(tempRow++, sheet);
                    this.createCell(row, c1, MAX_LABEL);
                    this.createCell(row, c2, stats.getMax());
                    bottomRow = tempRow;
                }
                if (doChart && labels.size() > 0) {
                    boolean hasVals = false;
                    if (values != null) {
                        for (String val : values) {
                            try {
                                if (val == null) continue;
                                Double d = new Double(val.trim());
                                if (!(d > 0.0)) continue;
                                hasVals = true;
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                    if (hasVals && this.generateCharts) {
                        int indx = wb.addPicture(JFreechartChartUtil.getBarChart(labels, values, question.getText(), 600, 400), 6);
                        ClientAnchor anchor = creationHelper.createClientAnchor();
                        anchor.setDx1(0);
                        anchor.setDy1(0);
                        anchor.setDx2(0);
                        anchor.setDy2(255);
                        anchor.setCol1(6);
                        anchor.setRow1(tableTopRow);
                        anchor.setCol2(16);
                        anchor.setRow2(tableTopRow + 22);
                        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                        patriarch.createPicture(anchor, indx);
                        if (tableTopRow + 22 > bottomRow) {
                            bottomRow = tableTopRow + 22;
                        }
                    }
                }
                if (doDataTable) {
                    rowIndex = tableTopRow;
                    row = this.getRow(rowIndex++, sheet);
                    this.createCell(row, 1, FREQ_LABEL, this.headerStyle);
                    this.createCell(row, 2, PCT_LABEL, this.headerStyle);
                    for (int i = 0; i < labels.size(); ++i) {
                        row = this.getRow(rowIndex++, sheet);
                        this.createCell(row, 0, (String)labels.get(i));
                        this.createCell(row, 1, (String)values.get(i));
                        if (sampleTotal > 0) {
                            this.createCell(row, 2, PCT_FMT.format(Double.parseDouble((String)values.get(i)) / (double)sampleTotal));
                            continue;
                        }
                        this.createCell(row, 2, PCT_FMT.format(0L));
                    }
                    row = this.getRow(rowIndex++, sheet);
                    this.createCell(row, 0, TOTAL_LABEL);
                    this.createCell(row, 1, sampleTotal + "");
                    if (rowIndex > bottomRow) {
                        bottomRow = rowIndex;
                    }
                }
                rowIndex = bottomRow;
                this.getRow(rowIndex++, sheet);
                ((SXSSFSheet)sheet).flushRows(0);
            }
        }
    }

    private int writeCollectionStats(Map<QuestionGroupDto, List<QuestionDto>> questionMap, Sheet sheet, int firstRowIndex) {
        boolean tagCol = false;
        int valCol = 3;
        int totalQuestions = 0;
        for (List<QuestionDto> group : questionMap.values()) {
            totalQuestions += group.size();
        }
        int rowIndex = firstRowIndex + 1;
        Row statRow = this.getRow(rowIndex++, sheet);
        this.createCell(statRow, 0, "Questions");
        this.createCell(statRow, 3, totalQuestions);
        statRow = this.getRow(rowIndex++, sheet);
        this.createCell(statRow, 0, "Form submissions");
        this.createCell(statRow, 3, this.totalInstances);
        if (this.totalInstances == 0) {
            return rowIndex + 2;
        }
        if (this.safeTrue(this.surveyGroupDto.getRequireDataApproval())) {
            statRow = this.getRow(rowIndex++, sheet);
            this.createCell(statRow, 0, "Approved submissions");
            this.createCell(statRow, 3, this.approvedInstances);
        }
        statRow = this.getRow(rowIndex++, sheet);
        this.createCell(statRow, 0, "First submission");
        this.createCell(statRow, 3, ExportImportUtils.formatDateTime(this.firstSubmission));
        statRow = this.getRow(rowIndex++, sheet);
        this.createCell(statRow, 0, "Last submission");
        this.createCell(statRow, 3, ExportImportUtils.formatDateTime(this.lastSubmission));
        statRow = this.getRow(rowIndex++, sheet);
        this.createCell(statRow, 0, "Shortest duration");
        this.createCell(statRow, 3, this.getDurationText(this.minDuration));
        statRow = this.getRow(rowIndex++, sheet);
        this.createCell(statRow, 0, "Longest duration");
        this.createCell(statRow, 3, this.getDurationText(this.maxDuration));
        statRow = this.getRow(rowIndex++, sheet);
        this.createCell(statRow, 0, "Average duration");
        try {
            this.createCell(statRow, 3, this.getDurationText(this.totalDuration / (long)this.totalInstances));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String user : this.instancesByUser.keySet()) {
            statRow = this.getRow(rowIndex++, sheet);
            if (user != null) {
                this.createCell(statRow, 0, "User " + user);
            } else {
                this.createCell(statRow, 0, "No user");
            }
            this.createCell(statRow, 3, this.instancesByUser.get(user));
        }
        for (String device : this.instancesByDevice.keySet()) {
            statRow = this.getRow(rowIndex++, sheet);
            this.createCell(statRow, 0, "Device " + device);
            this.createCell(statRow, 3, this.instancesByDevice.get(device));
        }
        return rowIndex + 2;
    }

    protected Cell createCell(Row row, int col, String value) {
        return this.createCell(row, col, value, null, -1);
    }

    protected Cell createCell(Row row, int col, int value) {
        Cell cell = row.createCell(col);
        cell.setCellType(0);
        cell.setCellValue((double)value);
        return cell;
    }

    protected Cell createCell(Row row, int col, double value) {
        Cell cell = row.createCell(col);
        cell.setCellType(0);
        cell.setCellValue(value);
        return cell;
    }

    protected Cell createCell(Row row, int col, Date value) {
        Cell cell = row.createCell(col);
        cell.setCellType(0);
        cell.setCellValue(value);
        return cell;
    }

    protected Cell createHeaderCell(Row row, int col, String value) {
        return this.createCell(row, col, value, this.headerStyle, -1);
    }

    protected Cell createCell(Row row, int col, String value, CellStyle style) {
        return this.createCell(row, col, value, style, -1);
    }

    protected Cell createCell(Row row, int col, String value, CellStyle style, int type) {
        Cell cell = row.createCell(col);
        if (style != null) {
            cell.setCellStyle(style);
        }
        if (value != null) {
            if (type == 0) {
                Double val = null;
                try {
                    val = Double.parseDouble(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (val != null) {
                    cell.setCellType(0);
                    cell.setCellValue(val.doubleValue());
                } else {
                    cell.setCellValue(value);
                }
            } else {
                cell.setCellValue(value);
            }
        }
        return cell;
    }

    private synchronized Row getRow(int index, Sheet sheet) {
        Row row = sheet.getRow(index);
        if (row == null) {
            row = sheet.createRow(index);
        }
        return row;
    }

    protected boolean processOptions(Map<String, String> options) {
        this.includeSummarySheet = true;
        this.performGeoRollup = true;
        this.generateCharts = true;
        this.separateSheetsForRepeatableGroups = false;
        this.doGroupHeaders = false;
        this.variableNamesInHeaders = false;
        if (options != null) {
            String po;
            this.reportType = options.get(TYPE_OPT);
            if (this.reportType == null || this.reportType.isEmpty()) {
                log.severe("exportMode was not set.");
                return false;
            }
            if (DATA_CLEANING_TYPE.equalsIgnoreCase(this.reportType)) {
                this.includeSummarySheet = false;
                this.doGroupHeaders = true;
                this.separateSheetsForRepeatableGroups = true;
                this.variableNamesInHeaders = false;
                this.splitIntoColumns = false;
                this.justCodes = false;
            } else if (DATA_ANALYSIS_TYPE.equalsIgnoreCase(this.reportType)) {
                this.includeSummarySheet = false;
                this.doGroupHeaders = false;
                this.separateSheetsForRepeatableGroups = false;
                this.variableNamesInHeaders = true;
                this.splitIntoColumns = true;
                this.justCodes = true;
            } else if (COMPREHENSIVE_TYPE.equalsIgnoreCase(this.reportType)) {
                this.includeSummarySheet = true;
                this.doGroupHeaders = false;
                this.separateSheetsForRepeatableGroups = false;
                this.variableNamesInHeaders = true;
                this.splitIntoColumns = true;
                this.justCodes = true;
            } else {
                log.severe("Unknown value " + this.reportType + " for " + TYPE_OPT);
                return false;
            }
            this.imagePrefix = options.get(IMAGE_PREFIX_OPT);
            this.selectionFrom = options.get(FROM_OPT);
            this.selectionTo = options.get(TO_OPT);
            this.selectionLimit = options.get(MAX_ROWS_OPT);
            String lc = options.get(LAST_COLLECTION_OPT);
            if (lc != null && "true".equalsIgnoreCase(lc.toString())) {
                this.lastCollection = true;
            }
            if ((po = options.get(PUBLISHED_OPT)) != null && "false".equalsIgnoreCase(po.toString())) {
                this.usePublishedForm = false;
            }
            if (options.get(CADDISFLY_TESTS_FILE_URL_OPT) != null && !options.get(CADDISFLY_TESTS_FILE_URL_OPT).isEmpty()) {
                this.caddisflyTestsFileUrl = options.get(CADDISFLY_TESTS_FILE_URL_OPT);
            }
        }
        if (this.imagePrefix != null) {
            this.imagePrefix = this.imagePrefix.trim();
            if (!this.imagePrefix.endsWith("/")) {
                this.imagePrefix = this.imagePrefix + "/";
            }
        } else {
            this.imagePrefix = DEFAULT_IMAGE_PREFIX;
        }
        return true;
    }

    private String getDurationText(Long duration) {
        if (duration == null) {
            return "";
        }
        String result = "";
        try {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            result = df.format(duration * 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected String getImagePrefix() {
        return this.imagePrefix;
    }

    public static void main(String[] args) {
        GraphicalSurveySummaryExporter exporter = new GraphicalSurveySummaryExporter();
        HashMap<String, String> criteria = new HashMap<String, String>();
        HashMap<String, String> options = new HashMap<String, String>();
        if (args.length < 5) {
            options.put(TYPE_OPT, DATA_CLEANING_TYPE);
        } else {
            options.put(TYPE_OPT, args[4]);
        }
        if (args.length >= 6) {
            options.put(PUBLISHED_OPT, args[5]);
        }
        options.put(LAST_COLLECTION_OPT, "false");
        options.put(EMAIL_OPT, "email@example.com");
        options.put(FROM_OPT, null);
        options.put(TO_OPT, null);
        options.put(MAX_ROWS_OPT, null);
        String instance = args[1].replace(".appspot.com", "").replace("https://", "").replace("http://", "");
        options.put(UPLOAD_URL_OPT, String.format("https://%s.s3.amazonaws.com/", instance));
        options.put(UPLOAD_DIR_OPT, "surveys");
        criteria.put("surveyId", args[2]);
        criteria.put("apiKey", args[3]);
        exporter.export(criteria, new File(args[0]), args[1], options);
    }
}

