/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.servlet;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.user.dao.UserAuthorizationDAO;
import com.gallatinsystems.user.dao.UserDao;
import com.gallatinsystems.user.domain.User;
import com.gallatinsystems.user.domain.UserAuthorization;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.domain.DefaultUserAuthorization;
import org.akvo.flow.rest.dto.PostUserRegistrationRestRequest;

public class PostUserRegistrationServlet
extends AbstractRestApiServlet {
    private final String MAIN_DOMAIN = "www";
    private final String DEMO_DOMAIN = "demo";
    private UserDao userDao = new UserDao();
    private SurveyGroupDAO folderDao = new SurveyGroupDAO();

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        PostUserRegistrationRestRequest restRequest = new PostUserRegistrationRestRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        PostUserRegistrationRestRequest request = (PostUserRegistrationRestRequest)req;
        if (!"www".equalsIgnoreCase(request.getDomain()) || !"demo".equalsIgnoreCase(request.getDomain())) {
            return new RestResponse();
        }
        User newUser = this.addUser(request.getEmail(), request.getFullName());
        SurveyGroup folder = this.addFolder(newUser.getUserName(), newUser.getKey().getId());
        this.addAuthorization(newUser, folder);
        return new RestResponse();
    }

    private User addUser(String email, String fullName) {
        User newUser = new User();
        newUser.setEmailAddress(email);
        newUser.setUserName(fullName);
        return this.userDao.save(newUser);
    }

    private SurveyGroup addFolder(String folderName, Long creationUserId) {
        SurveyGroup folder = new SurveyGroup();
        folder.setProjectType(SurveyGroup.ProjectType.PROJECT_FOLDER);
        folder.setName(folderName);
        folder.setCode(folderName);
        folder.setCreateUserId(creationUserId);
        return this.folderDao.save(folder);
    }

    private void addAuthorization(User newUser, SurveyGroup folder) {
        UserAuthorization authorization = DefaultUserAuthorization.getOrCreateDefaultAuthorization(newUser.getKey().getId(), folder.getKey().getId());
        new UserAuthorizationDAO().save(authorization);
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
    }
}

