/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.dto;

import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class BootstrapGeneratorRequest
extends RestRequest {
    private static final long serialVersionUID = 9041460970737380174L;
    public static final String GEN_ACTION = "generate";
    public static final String SURVEY_ID_LIST_PARAM = "surveyIds";
    public static final String EMAIL_PARAM = "email";
    public static final String DB_PARAM = "dbInstructions";
    public static final String DELMITER = "||";
    private String email;
    private String dbInstructions;
    private List<Long> surveyIds;

    @Override
    protected void populateErrors() {
        if (!(this.surveyIds != null && this.surveyIds.size() != 0 || this.dbInstructions != null && this.dbInstructions.trim().length() != 0)) {
            this.addError(new RestError("5001", "Missing mandatory parameter", "surveyIds cannot be null or empty if dbInstructions is also null"));
        }
        if (this.email == null) {
            this.addError(new RestError("5001", "Missing mandatory parameter", "email cannot be null or empty"));
        }
    }

    @Override
    protected void populateFields(HttpServletRequest req) throws Exception {
        this.email = req.getParameter(EMAIL_PARAM);
        this.dbInstructions = req.getParameter(DB_PARAM);
        String ids = req.getParameter(SURVEY_ID_LIST_PARAM);
        if (ids != null && ids.trim().length() > 0) {
            this.surveyIds = new ArrayList<Long>();
            StringTokenizer strTok = new StringTokenizer(ids, DELMITER);
            while (strTok.hasMoreTokens()) {
                String id = strTok.nextToken().trim();
                try {
                    this.surveyIds.add(new Long(id));
                }
                catch (NumberFormatException e) {
                    this.addError(new RestError("5002", "Invalid data type", "surveyIds must only contain integers delimited by ||"));
                }
            }
        }
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDbInstructions() {
        return this.dbInstructions;
    }

    public void setDbInstructions(String dbInstructions) {
        this.dbInstructions = dbInstructions;
    }

    public List<Long> getSurveyIds() {
        return this.surveyIds;
    }

    public void setSurveyIds(List<Long> surveyIds) {
        this.surveyIds = surveyIds;
    }
}

