/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.framework.rest;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.framework.rest.exception.RestException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractRestApiServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(AbstractRestApiServlet.class.getName());
    private static final long serialVersionUID = -8553345034709944772L;
    public static final String XML_MODE = "XML";
    public static final String JSON_MODE = "JSON";
    public static final String XHTML_MODE = "XHTML";
    public static final String PLAINTEXT_MODE = "TEXT";
    private String mode;
    private ThreadLocal<HttpServletRequest> requests;
    private ThreadLocal<HttpServletResponse> responses;
    private static final String API_PRIVATE_KEY = PropertyUtil.getProperty("restPrivateKey");

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.executeRequest(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.executeRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.checkThreadLocal();
            resp.setCharacterEncoding("UTF-8");
            this.requests.set(req);
            this.responses.set(resp);
            this.setContentType(resp);
            RestRequest restReq = this.convertRequest();
            restReq.validate();
            RestResponse restResp = this.handleRequest(restReq);
            this.writeOkResponse(restResp);
        }
        catch (RestException e) {
            this.writeErrorResponse(e.getErrors(), resp);
        }
        catch (Throwable e) {
            this.writeErrorResponse(null, resp);
            log.log(Level.SEVERE, "Could not execute rest request", e);
        }
        finally {
            this.requests.set(null);
            this.responses.set(null);
        }
    }

    protected abstract RestRequest convertRequest() throws Exception;

    protected abstract RestResponse handleRequest(RestRequest var1) throws Exception;

    protected abstract void writeOkResponse(RestResponse var1) throws Exception;

    private void setContentType(HttpServletResponse resp) {
        if (XML_MODE.equalsIgnoreCase(this.mode)) {
            resp.setContentType("text/xml;charset=utf-8");
        } else if (JSON_MODE.equalsIgnoreCase(this.mode)) {
            resp.setContentType("application/json;charset=utf-8");
        } else if (XHTML_MODE.equalsIgnoreCase(this.mode)) {
            resp.setContentType("application/xhtml+xml");
        } else {
            resp.setContentType("text/plain");
        }
    }

    protected void writeErrorResponse(List<RestError> errs, HttpServletResponse resp) {
        try {
            resp.setStatus(500);
            if (errs != null) {
                for (RestError err : errs) {
                    resp.getWriter().print(err.toString() + "\n");
                    log.log(Level.SEVERE, err.toString());
                }
            } else {
                resp.getWriter().print(new RestError());
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not write to servlet response object", e);
        }
    }

    protected HttpServletRequest getRequest() {
        return this.requests.get();
    }

    protected HttpServletResponse getResponse() {
        return this.responses.get();
    }

    private void checkThreadLocal() {
        if (this.requests == null) {
            this.requests = new ThreadLocal();
        }
        if (this.responses == null) {
            this.responses = new ThreadLocal();
        }
    }
}

