/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.auth.dao;

import com.gallatinsystems.auth.domain.WebActivityAuthorization;
import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class WebActivityAuthorizationDao
extends BaseDAO<WebActivityAuthorization> {
    public WebActivityAuthorizationDao() {
        super(WebActivityAuthorization.class);
    }

    public List<WebActivityAuthorization> listByToken(String token, String activityName, String cursorString, boolean validOnly) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(WebActivityAuthorization.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("token", filterString, paramString, "String", token, paramMap);
        this.appendNonNullParam("webActivityName", filterString, paramString, "String", activityName, paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursorString, query);
        ArrayList<WebActivityAuthorization> authList = (ArrayList<WebActivityAuthorization>)query.executeWithMap(paramMap);
        if (authList != null && validOnly) {
            ArrayList<WebActivityAuthorization> filteredList = new ArrayList<WebActivityAuthorization>();
            for (WebActivityAuthorization auth : authList) {
                if (!auth.isValidForAuth()) continue;
                filteredList.add(auth);
            }
            authList = filteredList;
        }
        return authList;
    }

    public List<WebActivityAuthorization> listByUser(Long userId, String activityName) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(WebActivityAuthorization.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("userId", filterString, paramString, "Long", userId, paramMap);
        this.appendNonNullParam("webActivityName", filterString, paramString, "String", activityName, paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        ArrayList<WebActivityAuthorization> authList = (ArrayList<WebActivityAuthorization>)query.executeWithMap(paramMap);
        if (authList != null) {
            ArrayList<WebActivityAuthorization> filteredList = new ArrayList<WebActivityAuthorization>();
            for (WebActivityAuthorization auth : authList) {
                if (!auth.isValidForAuth()) continue;
                filteredList.add(auth);
            }
            authList = filteredList;
        }
        return authList;
    }
}

