/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest.form;

import com.gallatinsystems.survey.domain.QuestionGroup;
import com.google.appengine.api.datastore.KeyFactory;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.akvo.flow.rest.form.QuestionMapper;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;

public class QuestionGroupMapper {
    private final QuestionMapper questionMapper;

    public QuestionGroupMapper(QuestionMapper questionMapper) {
        this.questionMapper = questionMapper;
    }

    @Nonnull
    TreeMap<Integer, QuestionGroup> mapGroups(List<QuestionGroupDto> groupDtos) {
        TreeMap<Integer, QuestionGroup> groupMap = new TreeMap<Integer, QuestionGroup>();
        if (groupDtos != null) {
            int i = 1;
            for (QuestionGroupDto groupDto : groupDtos) {
                QuestionGroup group = this.mapGroup(groupDto);
                Integer groupDtoOrder = groupDto.getOrder();
                if (groupDtoOrder != null && groupMap.containsKey(groupDtoOrder)) {
                    group.setOrder(i);
                    groupMap.put(i, group);
                } else {
                    int order = groupDtoOrder != null ? groupDtoOrder : i;
                    group.setOrder(order);
                    groupMap.put(order, group);
                }
                ++i;
            }
        }
        return groupMap;
    }

    private QuestionGroup mapGroup(QuestionGroupDto groupDto) {
        QuestionGroup group = new QuestionGroup();
        group.setKey(KeyFactory.createKey((String)"QuestionGroup", (long)groupDto.getKeyId()));
        group.setCode(groupDto.getCode());
        group.setSurveyId(groupDto.getSurveyId());
        group.setOrder(groupDto.getOrder());
        group.setPath(groupDto.getPath());
        group.setName(groupDto.getName());
        group.setRepeatable(groupDto.getRepeatable());
        String status = groupDto.getStatus();
        if (status != null) {
            group.setStatus(QuestionGroup.Status.valueOf(status));
        }
        group.setImmutable(groupDto.getImmutable());
        group.setQuestionMap(this.questionMapper.mapQuestions(groupDto.getQuestionList()));
        return group;
    }
}

