/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.analytics;

import com.gallatinsystems.framework.analytics.summarization.DataSummarizer;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.domain.Question;
import java.util.List;
import org.waterforpeople.mapping.analytics.dao.SurveyQuestionSummaryDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;

public class SurveyQuestionSummarizer
implements DataSummarizer {
    @Override
    public boolean performSummarization(String key, String type, String value, Integer offset, String cursor) {
        SurveyInstanceDAO instanceDao;
        List<QuestionAnswerStore> answers;
        if (key != null && (answers = (instanceDao = new SurveyInstanceDAO()).listQuestionAnswerStoreByType(new Long(key), "VALUE")) != null && answers.size() > 0) {
            QuestionDao questionDao = new QuestionDao();
            List<Question> qList = questionDao.listQuestionsInOrder(answers.get(0).getSurveyId(), Question.Type.OPTION);
            int i = 0;
            if (offset != null) {
                i = offset;
            } else {
                offset = 0;
            }
            while (i < answers.size() && i < offset + 10) {
                if (this.isSummarizable(answers.get(i), qList)) {
                    SurveyQuestionSummaryDao.incrementCount(answers.get(i), 1);
                }
                ++i;
            }
            if (i < answers.size()) {
                return false;
            }
        }
        return true;
    }

    private boolean isSummarizable(QuestionAnswerStore answer, List<Question> questions) {
        if (questions != null && answer != null) {
            long id = Long.parseLong(answer.getQuestionID());
            for (Question q : questions) {
                if (q.getKey().getId() != id) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public String getCursor() {
        return null;
    }
}

