/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.notification.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.notification.domain.NotificationHistory;
import com.gallatinsystems.notification.domain.NotificationSubscription;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class NotificationSubscriptionDao
extends BaseDAO<NotificationSubscription> {
    public NotificationSubscriptionDao() {
        super(NotificationSubscription.class);
    }

    public List<NotificationSubscription> listUnexpiredNotifications(String type) {
        return this.listSubscriptions(null, type, true);
    }

    public List<NotificationSubscription> listSubscriptions(Long entityId, String type, boolean unexpiredOnly) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(NotificationSubscription.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("notificationType", filterString, paramString, "String", type, paramMap);
        this.appendNonNullParam("entityId", filterString, paramString, "Long", entityId, paramMap);
        if (unexpiredOnly) {
            this.appendNonNullParam("expiryDate", filterString, paramString, "Date", new Date(), paramMap, " >= ");
            query.declareImports("import java.util.Date");
        }
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        return (List)query.executeWithMap(paramMap);
    }

    public NotificationHistory findNotificationHistory(String type, Long entityId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(NotificationHistory.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("type", filterString, paramString, "String", type, paramMap);
        this.appendNonNullParam("entityId", filterString, paramString, "Long", entityId, paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        List results = (List)query.executeWithMap(paramMap);
        if (results != null && results.size() > 0) {
            return (NotificationHistory)results.get(0);
        }
        return null;
    }

    public static synchronized NotificationHistory saveNotificationHistory(NotificationHistory h) {
        if (h != null) {
            if (h.getCount() == null) {
                h.setCount(1L);
            } else {
                h.setCount(h.getCount() + 1L);
            }
            h.setLastNotification(new Date());
            NotificationSubscriptionDao dao = new NotificationSubscriptionDao();
            h = dao.save(h);
        }
        return h;
    }
}

