/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.dao.DeviceFileJobQueueDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.device.domain.DeviceFileJobQueue;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.domain.Survey;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.waterforpeople.mapping.app.web.dto.DeviceNotificationRequest;
import org.waterforpeople.mapping.app.web.dto.DeviceNotificationResponse;

public class DeviceNotificationRestServlet
extends AbstractRestApiServlet {
    private static final long serialVersionUID = -2243167279214074216L;

    public DeviceNotificationRestServlet() {
        this.setMode("JSON");
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        DeviceNotificationRequest restRequest = new DeviceNotificationRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        DeviceNotificationRequest dnReq = (DeviceNotificationRequest)req;
        DeviceNotificationResponse resp = new DeviceNotificationResponse();
        Device d = this.getDevice(dnReq);
        if (d != null) {
            DeviceFileJobQueueDAO jobDao = new DeviceFileJobQueueDAO();
            List<DeviceFileJobQueue> missingByDevice = jobDao.listByDeviceId(d.getKey().getId());
            List<DeviceFileJobQueue> missingUnknown = jobDao.listByUnknownDevice();
            resp.setMissingFiles(missingByDevice);
            resp.setMissingUnknown(missingUnknown);
            new DeviceDAO().updateDevice(dnReq.getPhoneNumber(), dnReq.getLat(), dnReq.getLon(), dnReq.getAccuracy(), dnReq.getAppVersion(), dnReq.getDeviceIdentifier(), dnReq.getImei(), dnReq.getOsVersion(), dnReq.getAndroidId());
        }
        resp.setDeletedSurvey(this.getDeletedSurveys(dnReq));
        return resp;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
        DeviceNotificationResponse r = (DeviceNotificationResponse)resp;
        JSONObject json = new JSONObject();
        JSONArray missingFiles = new JSONArray();
        JSONArray missingUnknown = new JSONArray();
        JSONArray deletedSurveys = new JSONArray();
        for (String mf : r.getMissingFiles()) {
            missingFiles.put((Object)mf);
        }
        for (String mu : r.getMissingUnknown()) {
            missingUnknown.put((Object)mu);
        }
        for (Long id : r.getDeletedSurveys()) {
            deletedSurveys.put((Object)String.valueOf(id));
        }
        json.put("missingFiles", (Object)missingFiles);
        json.put("missingUnknown", (Object)missingUnknown);
        json.put("deletedForms", (Object)deletedSurveys);
        this.getResponse().getWriter().println(json.toString());
    }

    private Set<Long> getDeletedSurveys(DeviceNotificationRequest req) {
        Set<Long> surveyIds = req.getSurveyIds();
        if (surveyIds.isEmpty()) {
            return surveyIds;
        }
        HashSet<Long> foundIds = new HashSet<Long>();
        Long[] surveyIdsArray = surveyIds.toArray(new Long[surveyIds.size()]);
        for (Survey s : new SurveyDAO().listByKeys(surveyIdsArray)) {
            foundIds.add(s.getKey().getId());
        }
        surveyIds.removeAll(foundIds);
        return surveyIds;
    }

    private Device getDevice(DeviceNotificationRequest req) {
        DeviceDAO deviceDao = new DeviceDAO();
        return deviceDao.getDevice(req.getAndroidId(), req.getImei(), req.getPhoneNumber());
    }
}

