/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.dao.MessageDao;
import org.akvo.flow.domain.Message;
import org.waterforpeople.mapping.app.web.dto.RawDataImportRequest;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class RawDataRestServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger("RawDataRestServlet");
    private static final long serialVersionUID = 2409014651721639814L;
    private SurveyInstanceDAO instanceDao = new SurveyInstanceDAO();
    private QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
    private SurveyedLocaleDao slDao = new SurveyedLocaleDao();
    private QuestionDao qDao = new QuestionDao();
    private DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        RawDataImportRequest restRequest = new RawDataImportRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        RawDataImportRequest importReq = (RawDataImportRequest)req;
        if ("saveSurveyInstance".equals(importReq.getAction())) {
            Map<Long, Map<Integer, String[]>> incomingResponses;
            Survey s = importReq.getForm();
            SurveyGroup sg = importReq.getSurvey();
            SurveyInstance instance = null;
            instance = importReq.isNewFormInstance() ? this.createInstance(importReq) : importReq.getFormInstance();
            SurveyedLocale dataPoint = null;
            if (importReq.isNewFormInstance()) {
                dataPoint = new SurveyedLocale();
                dataPoint.setIdentifier(SurveyedLocale.generateBase32Uuid());
                instance.setSurveyedLocaleIdentifier(dataPoint.getIdentifier());
                dataPoint.setSurveyGroupId(sg.getKey().getId());
                dataPoint.setCreationSurveyId(s.getKey().getId());
                KeyRange ids = this.datastore.allocateIds("SurveyedLocale", 1L);
                dataPoint.setKey(ids.getStart());
                this.slDao.save(dataPoint);
                instance.setSurveyedLocaleId(dataPoint.getKey().getId());
                this.instanceDao.save(instance);
            } else {
                dataPoint = importReq.getDataPoint();
            }
            HashMap<Long, Map<Integer, QuestionAnswerStore>> existingAnswers = new HashMap<Long, Map<Integer, QuestionAnswerStore>>();
            if (!importReq.isNewFormInstance()) {
                existingAnswers.putAll(this.qasDao.mapByQuestionIdAndIteration(this.qasDao.listBySurveyInstance(instance.getKey().getId())));
            }
            if ((incomingResponses = importReq.getResponseMap()).isEmpty()) {
                log.log(Level.WARNING, "incomingResponses is empty");
            }
            ArrayList<QuestionAnswerStore> updatedAnswers = new ArrayList<QuestionAnswerStore>();
            for (Map.Entry<Long, Map<Integer, String[]>> entry : incomingResponses.entrySet()) {
                Long questionId = entry.getKey();
                Map<Integer, String[]> iterationMap = entry.getValue();
                if (iterationMap.isEmpty()) {
                    log.log(Level.WARNING, "iterationMap is empty");
                }
                for (Map.Entry<Integer, String[]> iterationEntry : iterationMap.entrySet()) {
                    Integer iteration = iterationEntry.getKey();
                    String response = iterationEntry.getValue()[0];
                    String type = iterationEntry.getValue()[1];
                    QuestionAnswerStore answer = null;
                    if (existingAnswers.containsKey(questionId) && ((Map)existingAnswers.get(questionId)).containsKey(iteration)) {
                        answer = (QuestionAnswerStore)((Map)existingAnswers.get(questionId)).get(iteration);
                    }
                    if (answer == null) {
                        answer = new QuestionAnswerStore();
                        answer.setQuestionID(questionId.toString());
                        answer.setSurveyInstanceId(instance.getKey().getId());
                        answer.setSurveyId(s.getKey().getId());
                        answer.setCollectionDate(instance.getCollectionDate());
                        answer.setType(type);
                        answer.setIteration(iteration);
                    }
                    answer.setValue(response);
                    updatedAnswers.add(answer);
                }
            }
            log.log(Level.INFO, "Updating " + updatedAnswers.size() + " question answers");
            this.qasDao.save((List<QuestionAnswerStore>)updatedAnswers);
            ArrayList<QuestionAnswerStore> deletedAnswers = new ArrayList<QuestionAnswerStore>();
            for (Long questionId : existingAnswers.keySet()) {
                for (Integer iteration : ((Map)existingAnswers.get(questionId)).keySet()) {
                    if (!incomingResponses.containsKey(questionId) || incomingResponses.get(questionId).containsKey(iteration)) continue;
                    deletedAnswers.add((QuestionAnswerStore)((Map)existingAnswers.get(questionId)).get(iteration));
                }
            }
            log.log(Level.INFO, "Deleting " + deletedAnswers.size() + " question answers");
            this.qasDao.delete((List<QuestionAnswerStore>)deletedAnswers);
            if (importReq.isRegistrationForm()) {
                dataPoint.assembleDisplayName(this.qDao.listDisplayNameQuestionsBySurveyId(s.getKey().getId()), updatedAnswers);
                this.updateDataPointLocation(dataPoint, updatedAnswers);
                this.slDao.save(dataPoint);
            }
            if (importReq.isNewFormInstance()) {
                Queue queue = QueueFactory.getDefaultQueue();
                TaskOptions processNewInstanceOptions = TaskOptions.Builder.withUrl((String)"/app_worker/surveyalservlet").param("action", "ingestInstance").param("surveyInstanceId", Long.toString(instance.getKey().getId())).countdownMillis(120000L);
                queue.add(processNewInstanceOptions);
            }
        } else if ("updateSummaries".equalsIgnoreCase(importReq.getAction())) {
            if (importReq.getSurveyId() == null || new SurveyDAO().getById(importReq.getSurveyId()) == null) {
                return null;
            }
            log.log(Level.INFO, "Rebuilding summaries for surveyId " + importReq.getSurveyId().toString());
            TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "rebuildQuestionSummary").param("surveyId", importReq.getSurveyId().toString());
            Queue queue = QueueFactory.getDefaultQueue();
            queue.add(options);
        } else if ("saveMessage".equalsIgnoreCase(importReq.getAction())) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(importReq.getSurveyId());
            SurveyUtils.notifyReportService(ids, "invalidate");
            MessageDao mdao = new MessageDao();
            Message msg = new Message();
            SurveyDAO sdao = new SurveyDAO();
            Survey s = sdao.getById(importReq.getSurveyId());
            msg.setShortMessage("Spreadsheet processed");
            msg.setObjectId(importReq.getSurveyId());
            msg.setObjectTitle(s.getPath() + "/" + s.getName());
            msg.setActionAbout("spreadsheetProcessed");
            mdao.save(msg);
        }
        return null;
    }

    private void updateDataPointLocation(SurveyedLocale dataPoint, List<QuestionAnswerStore> updatedAnswers) {
        for (QuestionAnswerStore answer : updatedAnswers) {
            if (!Question.Type.GEO.toString().equals(answer.getType())) continue;
            dataPoint.setGeoLocation(answer.getValue());
        }
    }

    private SurveyInstance createInstance(RawDataImportRequest importReq) {
        SurveyInstance inst = new SurveyInstance();
        inst.setUserID(1L);
        inst.setSurveyId(importReq.getSurveyId());
        inst.setCollectionDate(importReq.getCollectionDate() != null ? importReq.getCollectionDate() : new Date());
        inst.setDeviceIdentifier("IMPORTER");
        inst.setUuid(UUID.randomUUID().toString());
        inst.setSurveyedLocaleId(importReq.getSurveyedLocaleId());
        inst.setUuid(UUID.randomUUID().toString());
        inst.setSubmitterName(importReq.getSubmitter());
        inst.setSurveyalTime(importReq.getSurveyDuration());
        inst.setFormVersion(importReq.getFormVersion());
        KeyRange ids = this.datastore.allocateIds("SurveyInstance", 1L);
        inst.setKey(ids.getStart());
        this.instanceDao.save(inst);
        if (importReq.getCollectionDate() == null) {
            importReq.setCollectionDate(inst.getCollectionDate());
        }
        return inst;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
    }
}

