/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.user.dao.UserDao;
import com.gallatinsystems.user.domain.User;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.waterforpeople.mapping.app.web.CurrentUserServlet;

public class StringsServlet
extends HttpServlet {
    private static final long serialVersionUID = -5814616069972956097L;
    private static final Logger log = Logger.getLogger(StringsServlet.class.getClass().getName());
    final Set<String> enabledLocales = new HashSet<String>(Arrays.asList("en", "es", "fr", "pt", "id", "vi"));

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String locale = req.getParameter("locale");
        if (locale == null || !this.isAllowedLocale(locale.trim())) {
            return;
        }
        User currentUser = CurrentUserServlet.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        currentUser.setLanguage(locale);
        UserDao uDao = new UserDao();
        uDao.save(currentUser);
        log.info("Changed locale setting for user to '" + locale.toUpperCase() + "'");
    }

    private boolean isAllowedLocale(String locale) {
        return this.enabledLocales.contains(locale);
    }
}

