/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest.form;

import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.Survey;
import com.google.appengine.api.datastore.KeyFactory;
import java.util.TreeMap;
import org.akvo.flow.rest.form.QuestionGroupMapper;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;

public class FormMapper {
    private final QuestionGroupMapper questionGroupMapper;

    public FormMapper(QuestionGroupMapper questionGroupMapper) {
        this.questionGroupMapper = questionGroupMapper;
    }

    Survey mapFormFromDto(SurveyDto surveyDto) {
        Survey form = new Survey();
        form.setKey(KeyFactory.createKey((String)"Survey", (long)surveyDto.getKeyId()));
        form.setCode(surveyDto.getCode());
        form.setName(surveyDto.getName());
        form.setVersion(Double.parseDouble(surveyDto.getVersion()));
        form.setDesc(surveyDto.getDescription());
        String status = surveyDto.getStatus();
        if (status != null) {
            form.setStatus(Survey.Status.valueOf(status));
        }
        form.setPath(surveyDto.getPath());
        form.setSurveyGroupId(surveyDto.getSurveyGroupId());
        form.setDefaultLanguageCode(surveyDto.getDefaultLanguageCode());
        form.setRequireApproval(surveyDto.getRequireApproval());
        form.setCreatedDateTime(surveyDto.getCreatedDateTime());
        form.setLastUpdateDateTime(surveyDto.getLastUpdateDateTime());
        form.setAncestorIds(surveyDto.getAncestorIds());
        form.setWebFormPassword(surveyDto.getWebFormPassword());
        TreeMap<Integer, QuestionGroup> groupMap = this.questionGroupMapper.mapGroups(surveyDto.getQuestionGroupList());
        form.setQuestionGroupMap(groupMap);
        return form;
    }
}

