/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.domain;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class WebForm {
    private static final Logger logger = Logger.getLogger(WebForm.class.getName());

    public static Set<String> unsupportedQuestionTypes() {
        HashSet<String> unsupportedTypes = new HashSet<String>();
        unsupportedTypes.add(Question.Type.GEOSHAPE.toString());
        unsupportedTypes.add(Question.Type.SIGNATURE.toString());
        unsupportedTypes.add(Question.Type.CADDISFLY.toString());
        return unsupportedTypes;
    }

    public static boolean validForm(Survey survey, SurveyGroup surveyGroup) {
        return surveyGroup.getMonitoringGroup() == false || surveyGroup.getNewLocaleSurveyId() != null && surveyGroup.getNewLocaleSurveyId().equals(survey.getKey().getId());
    }

    public static boolean validWebForm(SurveyGroup surveyGroup, Survey survey, List<Question> questions) {
        boolean validSurveyGroup = WebForm.validForm(survey, surveyGroup);
        if (!validSurveyGroup) {
            return false;
        }
        List validQuestions = questions.stream().filter(i -> !WebForm.unsupportedQuestionTypes().contains(i.getType().toString())).collect(Collectors.toList());
        return validQuestions.size() == questions.size();
    }

    public static String generateWebFormV2Uri(Long formId) {
        String baseUri = PropertyUtil.getProperty("webFormV2GenerateEndpoint");
        String alias = PropertyUtil.getProperty("alias").split("\\.")[0];
        String fullUri = String.format("%s/%s/%s", baseUri, alias, formId);
        logger.fine("Generating Uri using endpoint: " + fullUri);
        String response = null;
        try {
            response = WebForm.executeHttpRequest(fullUri);
            if (response.length() > 1500) {
                throw new IOException("Response is too large");
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error while retrieving webformV2 form endpoint:" + e.getMessage(), e);
        }
        return response;
    }

    public static boolean isWebFormV2Enabled() {
        return "true".equalsIgnoreCase(PropertyUtil.getProperty("enableWebFormV2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeHttpRequest(String fullUri) throws IOException {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpget = new HttpGet(fullUri);
            ResponseHandler responseHandler = response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                return null;
            };
            String string = (String)httpclient.execute((HttpUriRequest)httpget, responseHandler);
            return string;
        }
    }
}

