/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.user.domain;

public enum Permission {
    PROJECT_FOLDER_CREATE("POST", "/rest/survey_groups"),
    PROJECT_FOLDER_READ("GET", "/rest/survey_groups"),
    PROJECT_FOLDER_UPDATE("PUT", "/rest/survey_groups"),
    PROJECT_FOLDER_DELETE("DELETE", "/rest/survey_groups"),
    FORM_CREATE("POST", "/rest/surveys"),
    FORM_READ("GET", "/rest/surveys"),
    FORM_UPDATE("PUT", "/rest/surveys"),
    FORM_DELETE("DELETE", "/rest/surveys"),
    DATA_APPROVE_MANAGE("GET", "/rest/approval_groups"),
    DATA_CLEANING("", ""),
    DATA_READ("GET", "/rest/survey_instances"),
    DATA_UPDATE("PUT", "/rest/survey_instances"),
    DATA_DELETE("DELETE", "/rest/survey_instances"),
    DEVICE_MANAGE("GET", "/rest/devices"),
    CASCADE_MANAGE("GET", "/rest/cascade_resources");

    private final String httpMethod;
    private final String uriPrefix;

    private Permission(String method, String uri) {
        this.httpMethod = method;
        this.uriPrefix = uri;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getUriPrefix() {
        return this.uriPrefix;
    }

    public static Permission lookup(String httpMethod, String requestUri) {
        if (httpMethod == null || requestUri == null) {
            return null;
        }
        for (Permission permission : Permission.values()) {
            if (!permission.getHttpMethod().equals(httpMethod) || !requestUri.startsWith(permission.getUriPrefix())) continue;
            return permission;
        }
        return null;
    }
}

