/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.device.dao.DeviceFileJobQueueDAO;
import com.gallatinsystems.device.domain.DeviceFileJobQueue;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.waterforpeople.mapping.app.web.dto.ImageCheckRequest;

public class ImageCheckServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger(ImageCheckServlet.class.getName());
    private static final long serialVersionUID = 9187987692591327059L;
    private static final long MAX_ATTEMPTS = 3L;
    private static final long DELAY = 300000L;

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        ImageCheckRequest restRequest = new ImageCheckRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        ImageCheckRequest checkReq = (ImageCheckRequest)req;
        if (checkReq.getFileName() == null || checkReq.getFileName().equals("")) {
            log.log(Level.SEVERE, "No filename was provided, aborting check");
            return new RestResponse();
        }
        if (checkReq.getAttempt() == null) {
            log.log(Level.SEVERE, "No attempt number was specified, aborting check");
            return new RestResponse();
        }
        String baseUrl = PropertyUtil.getProperty("photo_url_root");
        String imageUrl = baseUrl + checkReq.getFileName();
        URL url = new URL(imageUrl);
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(60000);
            conn.setRequestMethod("HEAD");
            if (conn.getResponseCode() != 200) {
                if ((long)checkReq.getAttempt().intValue() == 3L) {
                    log.log(Level.INFO, "Adding file as missing: " + checkReq);
                    DeviceFileJobQueueDAO jobDao = new DeviceFileJobQueueDAO();
                    DeviceFileJobQueue df = new DeviceFileJobQueue();
                    df.setFileName(checkReq.getFileName());
                    df.setDeviceId(checkReq.getDeviceId());
                    df.setQasId(checkReq.getQasId());
                    jobDao.save(df);
                } else {
                    this.rescheduleTask(checkReq, true);
                }
            }
        }
        catch (SocketTimeoutException timeout) {
            this.rescheduleTask(checkReq, false);
        }
        catch (IOException e) {
            this.rescheduleTask(checkReq, true);
        }
        return new RestResponse();
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
    }

    private void rescheduleTask(ImageCheckRequest req, boolean delay) {
        int attempt = delay ? req.getAttempt() + 1 : req.getAttempt();
        log.log(Level.INFO, "Rescheduling image check: " + req);
        Queue queue = QueueFactory.getQueue((String)"background-processing");
        TaskOptions to = TaskOptions.Builder.withUrl((String)"/app_worker/imagecheck").param("fileName", req.getFileName()).param("deviceId", String.valueOf(req.getDeviceId())).param("qasId", String.valueOf(req.getQasId())).param("attempt", String.valueOf(attempt)).countdownMillis(delay ? 300000L * (long)req.getAttempt().intValue() : 0L);
        queue.add(to);
    }
}

