/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.user.dao.UserAuthorizationDAO;
import com.gallatinsystems.user.dao.UserRoleDao;
import com.gallatinsystems.user.domain.Permission;
import com.gallatinsystems.user.domain.UserRole;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;
import org.waterforpeople.mapping.app.web.rest.dto.UserRolePayload;

@Controller
@RequestMapping(value={"/user_roles"})
public class UserRolesRestService {
    private UserRoleDao userRoleDao = new UserRoleDao();
    private UserAuthorizationDAO userAuthorizationDAO = new UserAuthorizationDAO();

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> createUserRole(@RequestBody UserRolePayload payload) {
        RestStatusDto statusDto = new RestStatusDto();
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("meta", statusDto);
        if (StringUtils.isBlank((String)payload.getName())) {
            statusDto.setMessage("_missing_role_name");
            return response;
        }
        if (this.userRoleDao.findUserRoleByName(payload.getName()) == null) {
            UserRole createdRole = this.userRoleDao.save(payload.getUserRole());
            statusDto.setStatus("ok");
            statusDto.setMessage("_role_created");
            response.put("user_roles", new UserRolePayload(createdRole));
        } else {
            statusDto.setMessage("_role_already_exists");
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listUserRoles() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<UserRolePayload> rolesPayload = new ArrayList<UserRolePayload>();
        for (UserRole role : this.userRoleDao.listAllRoles()) {
            rolesPayload.add(new UserRolePayload(role));
        }
        response.put("user_roles", rolesPayload);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{roleId}"})
    @ResponseBody
    public Map<String, Object> findUserRole(@PathVariable Long roleId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        response.put("meta", statusDto);
        UserRole role = (UserRole)this.userRoleDao.getByKey(roleId);
        if (role == null) {
            statusDto.setMessage("_role_not_found");
            return response;
        }
        statusDto.setStatus("ok");
        response.put("user_roles", new UserRolePayload(role));
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{roleId}"})
    @ResponseBody
    public Map<String, Object> updateUserRole(@PathVariable Long roleId, @RequestBody UserRolePayload payload) {
        UserRole duplicateRoleName;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("meta", statusDto);
        if (StringUtils.isBlank((String)payload.getName())) {
            statusDto.setMessage("_missing_role_name");
            return response;
        }
        UserRole existingRole = (UserRole)this.userRoleDao.getByKey(roleId);
        if (existingRole == null) {
            statusDto.setMessage("_role_not_found");
            return response;
        }
        if (!existingRole.getName().equals(payload.getName()) && (duplicateRoleName = this.userRoleDao.findUserRoleByName(payload.getName())) != null) {
            statusDto.setMessage("_duplicate_role_name");
            return response;
        }
        BeanUtils.copyProperties((Object)payload, (Object)existingRole);
        UserRolePayload updatedRole = new UserRolePayload(this.userRoleDao.save(existingRole));
        response.put("user_roles", updatedRole);
        statusDto.setStatus("ok");
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{roleId}"})
    @ResponseBody
    public Map<String, Object> deleteUserRole(@PathVariable Long roleId) {
        RestStatusDto statusDto = new RestStatusDto();
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("meta", statusDto);
        UserRole deleteRole = (UserRole)this.userRoleDao.getByKey(roleId);
        if (deleteRole == null) {
            statusDto.setStatus("ok");
            statusDto.setMessage("_role_not_found");
            return response;
        }
        if (this.userAuthorizationDAO.findFirstAssignedByRole(roleId).isEmpty()) {
            this.userRoleDao.delete(deleteRole);
            statusDto.setStatus("ok");
            statusDto.setMessage("_role_deleted");
        } else {
            statusDto.setMessage("_role_in_use");
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/permissions"})
    @ResponseBody
    public Map<String, Object> listAllPermissions() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashSet<Permission> permissions = new HashSet<Permission>(Arrays.asList(Permission.values()));
        response.put("permissions", permissions);
        return response;
    }
}

