/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.xml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Translation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.akvo.flow.xml.XmlAltText;
import org.akvo.flow.xml.XmlDependency;
import org.akvo.flow.xml.XmlHelp;
import org.akvo.flow.xml.XmlLevel;
import org.akvo.flow.xml.XmlOptions;
import org.akvo.flow.xml.XmlValidationRule;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.TranslationDto;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class XmlQuestion {
    private static final String FREE_TYPE = "free";
    private static final String NUMERIC_VALIDATION_TYPE = "numeric";
    @JacksonXmlProperty(localName="options", isAttribute=false)
    private XmlOptions options;
    @JacksonXmlProperty(localName="validationRule", isAttribute=false)
    private XmlValidationRule validationRule;
    @JacksonXmlProperty(localName="dependency", isAttribute=false)
    private XmlDependency dependency;
    @JacksonXmlProperty(localName="help", isAttribute=false)
    private XmlHelp help;
    @JacksonXmlElementWrapper(localName="altText", useWrapping=false)
    private List<XmlAltText> altText;
    @JacksonXmlProperty(localName="text", isAttribute=false)
    private String text;
    @JacksonXmlProperty(localName="variableName", isAttribute=true)
    private String variableName;
    @JacksonXmlElementWrapper(localName="levels", useWrapping=true)
    private List<XmlLevel> level;
    @JacksonXmlProperty(localName="id", isAttribute=true)
    private long id;
    @JacksonXmlProperty(localName="order", isAttribute=true)
    private int order;
    @JacksonXmlProperty(localName="locked", isAttribute=true)
    private Boolean locked;
    @JacksonXmlProperty(localName="allowMultiple", isAttribute=true)
    private Boolean allowMultiple;
    @JacksonXmlProperty(localName="type", isAttribute=true)
    private String type;
    @JacksonXmlProperty(localName="mandatory", isAttribute=true)
    private boolean mandatory;
    @JacksonXmlProperty(localName="requireDoubleEntry", isAttribute=true)
    private Boolean requireDoubleEntry;
    @JacksonXmlProperty(localName="localeNameFlag", isAttribute=true)
    private boolean localeNameFlag;
    @JacksonXmlProperty(localName="localeLocationFlag", isAttribute=true)
    private Boolean localeLocationFlag;
    @JacksonXmlProperty(localName="caddisflyResourceUuid", isAttribute=true)
    private String caddisflyResourceUuid;
    @JacksonXmlProperty(localName="cascadeResource", isAttribute=true)
    private String cascadeResource;
    @JacksonXmlProperty(localName="allowPoints", isAttribute=true)
    private Boolean allowPoints;
    @JacksonXmlProperty(localName="allowLine", isAttribute=true)
    private Boolean allowLine;
    @JacksonXmlProperty(localName="allowPolygon", isAttribute=true)
    private Boolean allowPolygon;

    public XmlQuestion() {
    }

    public XmlQuestion(Question q) {
        this.text = q.getText();
        this.id = q.getKey().getId();
        this.order = q.getOrder();
        this.mandatory = Boolean.TRUE.equals(q.getMandatoryFlag());
        this.localeNameFlag = Boolean.TRUE.equals(q.getLocaleNameFlag());
        if (Boolean.TRUE.equals(q.getLocaleLocationFlag())) {
            this.localeLocationFlag = Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(q.getGeoLocked())) {
            this.locked = Boolean.TRUE;
        }
        if (q.getTip() != null) {
            this.help = new XmlHelp(q.getTip());
        }
        if (q.getVariableName() != null && !q.getVariableName().trim().equals("")) {
            this.variableName = q.getVariableName();
        }
        this.type = q.getType().toString().toLowerCase();
        switch (q.getType()) {
            case NUMBER: {
                this.type = FREE_TYPE;
                this.validationRule = new XmlValidationRule(q);
                if (!Boolean.TRUE.equals(q.getRequireDoubleEntry())) break;
                this.requireDoubleEntry = Boolean.TRUE;
                break;
            }
            case FREE_TEXT: {
                this.type = FREE_TYPE;
                if (!Boolean.TRUE.equals(q.getRequireDoubleEntry())) break;
                this.requireDoubleEntry = Boolean.TRUE;
                break;
            }
            case GEOSHAPE: {
                this.allowPoints = Boolean.TRUE.equals(q.getAllowPoints());
                this.allowLine = Boolean.TRUE.equals(q.getAllowLine());
                this.allowPolygon = Boolean.TRUE.equals(q.getAllowPolygon());
                break;
            }
            case CASCADE: {
                this.cascadeResource = q.getCascadeResource();
                if (q.getLevelNames() == null) break;
                this.level = new ArrayList<XmlLevel>();
                for (String text : q.getLevelNames()) {
                    this.level.add(new XmlLevel(text));
                }
                break;
            }
            case CADDISFLY: {
                this.caddisflyResourceUuid = q.getCaddisflyResourceUuid();
                break;
            }
            case OPTION: {
                if (q.getQuestionOptionMap() == null) break;
                this.options = new XmlOptions(q);
                break;
            }
            case SCAN: {
                if (q.getAllowMultipleFlag() == null || !q.getAllowMultipleFlag().booleanValue()) break;
                this.allowMultiple = true;
                break;
            }
        }
        if (Boolean.TRUE.equals(q.getDependentFlag())) {
            this.dependency = new XmlDependency(q.getDependentQuestionId(), q.getDependentQuestionAnswer());
        }
        if (q.getTranslationMap() != null) {
            this.altText = new ArrayList<XmlAltText>();
            for (Translation t : q.getTranslationMap().values()) {
                this.altText.add(new XmlAltText(t));
            }
        }
    }

    public QuestionDto toDto() {
        QuestionDto.QuestionType t;
        QuestionDto dto = new QuestionDto();
        dto.setKeyId(this.id);
        dto.setText(this.text);
        dto.setOrder(this.order);
        dto.setMandatoryFlag(this.mandatory);
        dto.setLocaleNameFlag(this.localeNameFlag);
        dto.setRequireDoubleEntry(this.requireDoubleEntry);
        dto.setVariableName(this.variableName);
        if (FREE_TYPE.equalsIgnoreCase(this.type)) {
            t = this.validationRule != null && NUMERIC_VALIDATION_TYPE.equals(this.validationRule.getValidationType()) ? QuestionDto.QuestionType.NUMBER : QuestionDto.QuestionType.FREE_TEXT;
        } else {
            try {
                t = QuestionDto.QuestionType.valueOf(this.type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                t = QuestionDto.QuestionType.FREE_TEXT;
            }
        }
        dto.setType(t);
        if (this.options != null) {
            dto.setOptionContainerDto(this.options.toDto());
            dto.setAllowMultipleFlag(this.options.getAllowMultiple());
            dto.setAllowOtherFlag(this.options.getAllowOther());
        }
        if (this.altText != null) {
            HashMap<String, TranslationDto> qMap = new HashMap<String, TranslationDto>();
            for (XmlAltText alt : this.altText) {
                qMap.put(alt.getLanguage(), alt.toDto());
            }
            dto.setTranslationMap(qMap);
        }
        if (this.level != null) {
            ArrayList<String> cl = new ArrayList<String>();
            for (XmlLevel lvl : this.level) {
                cl.add(lvl.getText());
            }
            dto.setLevelNames(cl);
        }
        if (this.caddisflyResourceUuid != null) {
            dto.setCaddisflyResourceUuid(this.caddisflyResourceUuid);
        }
        return dto;
    }

    public String toString() {
        return "question{id='" + this.id + "',order='" + this.order + "',type='" + this.type + "',mandatory='" + this.mandatory + "',requireDoubleEntry='" + this.requireDoubleEntry + "',locked='" + this.locked + "',variableName='" + this.variableName + "',localeNameFlag='" + this.localeNameFlag + "',allowPoints='" + this.allowPoints + "',allowLines='" + this.allowLine + "',allowPolygon='" + this.allowPolygon + "',options=" + (this.options != null ? this.options.toString() : "(null)") + "'}";
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public Boolean getLocaleNameFlag() {
        return this.localeNameFlag;
    }

    public void setLocaleNameFlag(Boolean localeNameFlag) {
        this.localeNameFlag = localeNameFlag;
    }

    public List<XmlAltText> getAltText() {
        return this.altText;
    }

    public void setAltText(List<XmlAltText> altText) {
        this.altText = altText;
    }

    public XmlOptions getOptions() {
        return this.options;
    }

    public void setOptions(XmlOptions options) {
        this.options = options;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Boolean isLocaleLocationFlag() {
        return this.localeLocationFlag;
    }

    public void setLocaleLocationFlag(Boolean localeLocationFlag) {
        this.localeLocationFlag = localeLocationFlag;
    }

    public String getCaddisflyResourceUuid() {
        return this.caddisflyResourceUuid;
    }

    public void setCaddisflyResourceUuid(String caddisflyResourceUuid) {
        this.caddisflyResourceUuid = caddisflyResourceUuid;
    }

    public String getCascadeResource() {
        return this.cascadeResource;
    }

    public void setCascadeResource(String cascadeResource) {
        this.cascadeResource = cascadeResource;
    }

    public XmlValidationRule getValidationRule() {
        return this.validationRule;
    }

    public void setValidationRule(XmlValidationRule validationRule) {
        this.validationRule = validationRule;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public Boolean getAllowPoints() {
        return this.allowPoints;
    }

    public void setAllowPoints(Boolean allowPoints) {
        this.allowPoints = allowPoints;
    }

    public Boolean getAllowLine() {
        return this.allowLine;
    }

    public void setAllowLine(Boolean allowLine) {
        this.allowLine = allowLine;
    }

    public Boolean getAllowPolygon() {
        return this.allowPolygon;
    }

    public void setAllowPolygon(Boolean allowPolygon) {
        this.allowPolygon = allowPolygon;
    }

    public XmlHelp getHelp() {
        return this.help;
    }

    public void setHelp(XmlHelp help) {
        this.help = help;
    }

    public List<XmlLevel> getLevel() {
        return this.level;
    }

    public void setLevel(List<XmlLevel> level) {
        this.level = level;
    }

    public Boolean getRequireDoubleEntry() {
        return this.requireDoubleEntry;
    }

    public void setRequireDoubleEntry(Boolean requireDoubleEntry) {
        this.requireDoubleEntry = requireDoubleEntry;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }
}

