/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.analytics;

import com.gallatinsystems.common.util.StringUtil;
import com.gallatinsystems.framework.analytics.summarization.DataSummarizer;
import com.gallatinsystems.framework.domain.DataChangeRecord;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.List;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;

public class NameQuestionDataCleanser
implements DataSummarizer {
    private String currentCursor;
    private SurveyInstanceDAO dao = new SurveyInstanceDAO();

    @Override
    public boolean performSummarization(String key, String type, String value, Integer offset, String cursor) {
        List<QuestionAnswerStore> answers = this.dao.listQuestionAnswerStoreForQuestion(key, cursor);
        this.currentCursor = answers != null && answers.size() > 0 ? SurveyInstanceDAO.getCursor(answers) : null;
        if (answers != null && answers.size() > 0) {
            for (QuestionAnswerStore answer : answers) {
                if (answer.getValue() == null) continue;
                String newValue = StringUtil.capitalizeString(answer.getValue());
                if (answer.getValue().equals(newValue)) continue;
                this.sendChangeMessage(new DataChangeRecord(QuestionAnswerStore.class.getName(), key, answer.getValue(), newValue));
                answer.setValue(newValue);
            }
            this.dao.save(answers);
        }
        return this.currentCursor == null;
    }

    @Override
    public String getCursor() {
        return this.currentCursor;
    }

    private void sendChangeMessage(DataChangeRecord value) {
        Queue queue = QueueFactory.getQueue((String)"dataUpdate");
        queue.add(TaskOptions.Builder.withUrl((String)"/app_worker/dataupdate").param("objectKey", value.getId()).param("type", "QuestionDataChange").param("value", value.packString()));
    }
}

