/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.common.domain.UploadStatusContainer;
import com.gallatinsystems.common.util.S3Util;
import com.gallatinsystems.common.util.ZipUtil;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.operations.dao.ProcessingStatusDao;
import com.gallatinsystems.operations.domain.ProcessingStatus;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.survey.domain.WebForm;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.api.utils.SystemProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akvo.flow.dao.MessageDao;
import org.akvo.flow.domain.Message;
import org.akvo.flow.xml.PublishedForm;
import org.akvo.flow.xml.XmlForm;
import org.apache.log4j.Logger;
import org.waterforpeople.mapping.app.web.DataProcessorRestServlet;
import org.waterforpeople.mapping.app.web.dto.SurveyAssemblyRequest;

public class SurveyAssemblyServlet
extends AbstractRestApiServlet {
    private static final Logger log = Logger.getLogger((String)SurveyAssemblyServlet.class.getName());
    private static final long serialVersionUID = -6044156962558183224L;
    public static final String FREE_QUESTION_TYPE = "free";
    public static final String OPTION_QUESTION_TYPE = "option";
    public static final String GEO_QUESTION_TYPE = "geo";
    public static final String VIDEO_QUESTION_TYPE = "video";
    public static final String PHOTO_QUESTION_TYPE = "photo";
    public static final String SCAN_QUESTION_TYPE = "scan";
    public static final String STRENGTH_QUESTION_TYPE = "strength";
    public static final String DATE_QUESTION_TYPE = "date";
    public static final String CASCADE_QUESTION_TYPE = "cascade";
    public static final String GEOSHAPE_QUESTION_TYPE = "geoshape";
    public static final String SIGNATURE_QUESTION_TYPE = "signature";
    public static final String CADDISFLY_QUESTION_TYPE = "caddisfly";
    private static final String SURVEY_UPLOAD_URL = "surveyuploadurl";
    private static final String SURVEY_UPLOAD_DIR = "surveyuploaddir";
    private static final String FORM_PUB_STATUS_KEY = "formPublication";
    private Random randomNumber = new Random();

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        SurveyAssemblyRequest restRequest = new SurveyAssemblyRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        RestResponse response = new RestResponse();
        SurveyAssemblyRequest importReq = (SurveyAssemblyRequest)req;
        if ("assembleSurvey".equalsIgnoreCase(importReq.getAction())) {
            Date start = new Date();
            Long id = importReq.getSurveyId();
            ProcessingStatusDao statusDao = new ProcessingStatusDao();
            ProcessingStatus status = statusDao.getStatusByCode(FORM_PUB_STATUS_KEY + (id != null ? ":" + id : ""));
            if (status == null) {
                status = new ProcessingStatus();
                status.setCode(FORM_PUB_STATUS_KEY + (id != null ? ":" + id : ""));
                status.setMaxDurationMs(0L);
            }
            status.setLastEventDate(start);
            Long maxDuration = status.getMaxDurationMs();
            if (maxDuration == null) {
                maxDuration = 0L;
            }
            status.setInError(true);
            status.setValue("inProgress");
            statusDao.save(status);
            boolean ok = this.assembleFormWithJackson(importReq.getSurveyId());
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(id);
            SurveyUtils.notifyReportService(ids, "invalidate");
            status.setInError(ok);
            status.setValue("finished");
            Long duration = new Date().getTime() - start.getTime();
            if (duration > maxDuration) {
                status.setMaxDurationMs(duration);
                status.setMaxDurationDate(start);
            }
            statusDao.save(status);
        }
        return response;
    }

    public static void runAsTask(Long surveyId) {
        SurveyGroup sg;
        log.info((Object)"Forking to task for long assembly");
        TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/surveyassembly").param("action", "assembleSurvey").param("surveyId", surveyId.toString());
        Queue queue = QueueFactory.getQueue((String)"surveyAssembly");
        queue.add(options);
        Survey s = new SurveyDAO().getById(surveyId);
        SurveyGroup surveyGroup = sg = s != null ? (SurveyGroup)new SurveyGroupDAO().getByKey(s.getSurveyGroupId()) : null;
        if (sg != null && sg.getNewLocaleSurveyId() != null && sg.getNewLocaleSurveyId().longValue() == surveyId.longValue()) {
            DataProcessorRestServlet.scheduleDatapointNameAssembly(sg.getKey().getId(), null);
        }
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        HttpServletResponse httpResp = this.getResponse();
        httpResp.setStatus(200);
        httpResp.getWriter().print("OK");
        httpResp.flushBuffer();
    }

    private boolean assembleFormWithJackson(Long formId) {
        String formXML;
        log.debug((Object)("Starting Jackson assembly of form " + formId));
        SurveyDAO surveyDao = new SurveyDAO();
        Survey form = surveyDao.loadFullForm(formId);
        SurveyGroupDAO surveyGroupDao = new SurveyGroupDAO();
        QuestionDao questionDao = new QuestionDao();
        SurveyGroup survey = (SurveyGroup)surveyGroupDao.getByKey(form.getSurveyGroupId());
        Long transactionId = this.randomNumber.nextLong();
        XmlForm jacksonForm = new XmlForm(form, survey, SystemProperty.applicationId.get());
        try {
            formXML = PublishedForm.generate(jacksonForm);
        }
        catch (IOException e) {
            log.error((Object)("Failed to convert form to XML: " + e.getMessage()));
            return false;
        }
        boolean uploadOk = false;
        log.debug((Object)("Uploading " + formId));
        UploadStatusContainer uc = this.uploadFormXML(Long.toString(formId), Long.toString(formId) + "v" + form.getVersion(), formXML.toString());
        Message message = new Message();
        message.setActionAbout("surveyAssembly");
        message.setObjectId(formId);
        message.setObjectTitle(survey.getCode() + " / " + form.getName());
        if (uc.getUploadedZip1().booleanValue() && uc.getUploadedZip2().booleanValue()) {
            log.debug((Object)("Finishing assembly of " + formId));
            form.setStatus(Survey.Status.PUBLISHED);
            boolean webForm = WebForm.validWebForm((SurveyGroup)surveyGroupDao.getByKey(form.getObjectId()), form, questionDao.listQuestionsBySurvey(form.getObjectId()));
            form.setWebForm(webForm);
            surveyDao.save(form);
            String messageText = "Published.  Please check: " + uc.getUrl();
            message.setShortMessage(messageText);
            message.setTransactionUUID(transactionId.toString());
            MessageDao messageDao = new MessageDao();
            messageDao.save(message);
            uploadOk = true;
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(formId);
            SurveyUtils.notifyReportService(ids, "invalidate");
        } else {
            String messageText = "Failed to publish: " + formId + "\n" + uc.getMessage();
            message.setTransactionUUID(transactionId.toString());
            message.setShortMessage(messageText);
            MessageDao messageDao = new MessageDao();
            messageDao.save(message);
            log.warn((Object)("Failed to upload assembled form, id " + formId + "\n" + uc.getMessage()));
        }
        log.debug((Object)("Completed form assembly for " + formId));
        return uploadOk;
    }

    public UploadStatusContainer uploadFormXML(String fileName1, String fileName2, String formXML) {
        Properties props = System.getProperties();
        String bucketName = props.getProperty("s3bucket");
        String directory = props.getProperty(SURVEY_UPLOAD_DIR);
        UploadStatusContainer uc = new UploadStatusContainer();
        uc.setUploadedZip1(this.uploadZippedXml(formXML, bucketName, directory, fileName1));
        uc.setUploadedZip2(this.uploadZippedXml(formXML, bucketName, directory, fileName2));
        uc.setUrl(props.getProperty(SURVEY_UPLOAD_URL) + props.getProperty(SURVEY_UPLOAD_DIR) + "/" + fileName1 + ".zip");
        return uc;
    }

    private boolean uploadZippedXml(String content, String bucketName, String directory, String fileName) {
        ByteArrayOutputStream os2 = ZipUtil.generateZip(content, fileName + ".xml");
        try {
            return S3Util.put(bucketName, directory + "/" + fileName + ".zip", os2.toByteArray(), "application/zip", true);
        }
        catch (IOException e) {
            log.error((Object)("Error uploading zipfile: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }
}

