/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.dto;

import com.gallatinsystems.framework.rest.RestRequest;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class SurveyManagerRequest
extends RestRequest {
    private static final long serialVersionUID = -1914332708852551948L;
    public static final String GET_AVAIL_DEVICE_SURVEY_ACTION = "getAvailableSurveysDevice";
    public static final String GET_SURVEY_HEADER_ACTION = "getSurveyHeader";
    public static final String GET_ZIP_FILE_URL_ACTION = "getZipFileUrls";
    private static final String SURVEY_INSTANCE_PARAM = "surveyInstanceId";
    private static final String SURVEY_ID_PARAM = "surveyId";
    private static final String VERSION_PARAM = "ver";
    private static final String SURVEY_DOC_PARAM = "surveyDocument";
    private static final String IMEI_PARAM = "imei";
    private static final String PHONE_NUM_PARAM = "devicePhoneNumber";
    @Deprecated
    private static final String PHONE_NUM_ALT_PARAM = "phoneNumber";
    private static final String FILE_START_DATE_PARAM = "startDate";
    private static final String DEVICE_ID_PARAM = "devId";
    private static final String ANDROID_ID = "androidId";
    public static final String GET_AVAIL_DEVICE_SURVEYGROUP_ACTION = "getAvailableSurveyGroupsDevice";
    private Long surveyId;
    private Long surveyInstanceId;
    private String surveyDoc;
    private String phoneNumber;
    private String imei;
    private Date startDate;
    private String deviceId;
    private String version;
    private String androidId;

    public String getImei() {
        return this.imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public Long getSurveyId() {
        return this.surveyId;
    }

    public void setSurveyId(Long surveyId) {
        this.surveyId = surveyId;
    }

    public Long getSurveyInstanceId() {
        return this.surveyInstanceId;
    }

    public void setSurveyInstanceId(Long surveyInstanceId) {
        this.surveyInstanceId = surveyInstanceId;
    }

    public String getSurveyDoc() {
        return this.surveyDoc;
    }

    public void setSurveyDoc(String surveyDoc) {
        this.surveyDoc = surveyDoc;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setStartDate(String dateString) throws Exception {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd");
            Date convertedDate = dateFormat.parse(dateString);
            this.setStartDate(convertedDate);
        }
        catch (Exception ex) {
            throw new Exception("Could not parse date param");
        }
    }

    @Override
    protected void populateFields(HttpServletRequest req) throws Exception {
        this.surveyInstanceId = this.parseLong(req.getParameter(SURVEY_INSTANCE_PARAM), SURVEY_INSTANCE_PARAM);
        this.phoneNumber = req.getParameter(PHONE_NUM_PARAM);
        if (this.phoneNumber == null || this.phoneNumber.trim().length() == 0) {
            this.phoneNumber = req.getParameter(PHONE_NUM_ALT_PARAM);
        }
        this.imei = req.getParameter(IMEI_PARAM);
        this.version = req.getParameter(VERSION_PARAM);
        this.androidId = req.getParameter(ANDROID_ID);
        this.deviceId = req.getParameter(DEVICE_ID_PARAM).trim();
        this.surveyId = this.parseLong(req.getParameter(SURVEY_ID_PARAM), SURVEY_ID_PARAM);
        this.surveyDoc = req.getParameter(SURVEY_DOC_PARAM);
        if (req.getParameter(FILE_START_DATE_PARAM) != null) {
            this.setStartDate(req.getParameter(FILE_START_DATE_PARAM));
        }
    }

    @Override
    public void populateErrors() {
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAndroidId() {
        return this.androidId;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }
}

