/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.xml;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.gallatinsystems.survey.domain.QuestionOption;
import com.gallatinsystems.survey.domain.Translation;
import java.util.ArrayList;
import java.util.List;
import org.akvo.flow.xml.XmlAltText;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionOptionDto;

public class XmlOption {
    @JacksonXmlProperty(localName="code", isAttribute=true)
    private String code;
    @JacksonXmlProperty(localName="value", isAttribute=true)
    private String value;
    @JacksonXmlProperty(localName="text", isAttribute=false)
    private String text;
    @JacksonXmlElementWrapper(localName="altText", useWrapping=false)
    private List<XmlAltText> altText;

    public XmlOption() {
    }

    public XmlOption(QuestionOption o) {
        this.setCode(o.getCode());
        this.setText(o.getText());
        this.setValue(o.getText());
        this.altText = new ArrayList<XmlAltText>();
        for (Translation t : o.getTranslationMap().values()) {
            this.altText.add(new XmlAltText(t));
        }
    }

    public QuestionOptionDto toDto() {
        QuestionOptionDto dto = new QuestionOptionDto();
        dto.setCode(this.code);
        dto.setText(this.text);
        return dto;
    }

    public String toString() {
        return "option{code='" + this.code + "',value='" + this.value + "',text='" + this.text + "'}";
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<XmlAltText> getAltText() {
        return this.altText;
    }

    public void setAltText(List<XmlAltText> altText) {
        this.altText = altText;
    }
}

