/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.xml;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Arrays;
import java.util.TreeMap;
import org.akvo.flow.xml.XmlQuestion;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;

public class XmlQuestionGroup {
    @JacksonXmlElementWrapper(localName="question", useWrapping=false)
    private XmlQuestion[] question;
    @JacksonXmlProperty(localName="heading", isAttribute=false)
    private String heading;
    @JacksonXmlProperty(localName="repeatable", isAttribute=true)
    private boolean repeatable;
    private int order;

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String h) {
        this.heading = h;
    }

    public XmlQuestion[] getQuestion() {
        return this.question;
    }

    public void setQuestion(XmlQuestion[] qs) {
        this.question = qs;
    }

    public boolean getRepeatable() {
        return this.repeatable;
    }

    public void setRepeatable(boolean repeatable) {
        this.repeatable = repeatable;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public QuestionGroupDto toDto() {
        QuestionGroupDto dto = new QuestionGroupDto();
        dto.setName(this.heading);
        dto.setCode(this.heading);
        dto.setOrder(this.order);
        dto.setRepeatable(this.repeatable);
        if (this.question != null) {
            TreeMap<Integer, QuestionDto> qMap = new TreeMap<Integer, QuestionDto>();
            for (XmlQuestion q : this.question) {
                qMap.put(q.getOrder(), q.toDto());
            }
            dto.setQuestionMap(qMap);
        }
        return dto;
    }

    public String toString() {
        return "questionGroup{order='" + this.order + "',heading='" + this.heading + "',questions=" + Arrays.toString(this.question) + "}";
    }
}

