/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyGroupDto;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;
import org.waterforpeople.mapping.app.web.rest.dto.SurveyGroupPayload;

@Controller
@RequestMapping(value={"/survey_groups"})
public class SurveyGroupRestService {
    private SurveyGroupDAO surveyGroupDao = new SurveyGroupDAO();
    private SurveyDAO surveyDao = new SurveyDAO();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listSurveyGroups(@RequestParam(value="preflight", defaultValue="") String preflight, @RequestParam(value="surveyGroupId", defaultValue="") Long surveyGroupId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<SurveyGroupDto> results = new ArrayList<SurveyGroupDto>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("");
        statusDto.setMessage("");
        if (preflight != null && preflight.equals("delete") && surveyGroupId != null) {
            SurveyDAO sDao = new SurveyDAO();
            statusDto.setStatus("preflight-delete-surveygroup");
            statusDto.setMessage("cannot_delete");
            if (sDao.listSurveysByGroup(surveyGroupId).size() == 0) {
                statusDto.setMessage("can_delete");
                statusDto.setKeyId(surveyGroupId);
            }
            response.put("survey_groups", results);
            response.put("meta", statusDto);
            return response;
        }
        List<SurveyGroup> surveyGroups = this.surveyGroupDao.listAllFilteredByUserAuthorization();
        List surveys = this.surveyDao.list("all");
        HashMap<Long, Survey> surveyGroupIdToSomeSurvey = new HashMap<Long, Survey>();
        if (surveys != null) {
            for (Survey s : surveys) {
                Long sgId = s.getSurveyGroupId();
                if (sgId == null) continue;
                surveyGroupIdToSomeSurvey.put(sgId, s);
            }
        }
        if (surveyGroups != null) {
            for (SurveyGroup sg : surveyGroups) {
                SurveyGroupDto dto = new SurveyGroupDto(sg);
                Survey survey = (Survey)surveyGroupIdToSomeSurvey.get(sg.getKey().getId());
                if (survey != null) {
                    dto.addSurvey(survey.getKey().getId());
                }
                results.add(dto);
            }
        }
        response.put("survey_groups", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, SurveyGroupDto> findSurveyGroupById(@PathVariable(value="id") Long id) {
        HashMap<String, SurveyGroupDto> response = new HashMap<String, SurveyGroupDto>();
        SurveyGroup s = (SurveyGroup)this.surveyGroupDao.getByKey(id);
        SurveyGroupDto dto = null;
        if (s != null) {
            dto = new SurveyGroupDto();
            DtoMarshaller.copyToDto(s, dto);
        }
        response.put("survey_group", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteSurveyGroupById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        SurveyGroup s = (SurveyGroup)this.surveyGroupDao.getByKey(id);
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (s != null) {
            boolean delete = false;
            switch (s.getProjectType()) {
                case PROJECT: {
                    List<Survey> surveys = this.surveyDao.listSurveysByGroup(id);
                    delete = surveys.size() == 0;
                    break;
                }
                case PROJECT_FOLDER: {
                    List<SurveyGroup> surveyGroups = this.surveyGroupDao.listByProjectFolderId(id);
                    boolean bl = delete = surveyGroups.size() == 0;
                }
            }
            if (delete) {
                this.surveyGroupDao.delete(s);
                statusDto.setStatus("ok");
            }
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingSurveyGroup(@RequestBody SurveyGroupPayload payLoad) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        response.put("meta", statusDto);
        SurveyGroupDto requestDto = payLoad.getSurvey_group();
        SurveyGroupDto responseDto = new SurveyGroupDto();
        response.put("survey_group", responseDto);
        if (requestDto == null || requestDto.getKeyId() == null) {
            return response;
        }
        SurveyGroup s = (SurveyGroup)this.surveyGroupDao.getByKey(requestDto.getKeyId());
        if (s == null) {
            return response;
        }
        boolean hasMoved = requestDto.getParentId() == null || s.getParentId() == null || !requestDto.getParentId().equals(s.getParentId());
        BeanUtils.copyProperties((Object)requestDto, (Object)s, (String[])new String[]{"createdDateTime", "lastUpdateDateTime", "displayName", "questionGroupList", "ancestorIds"});
        String name = s.getName();
        if (name != null) {
            String trimmedName = name.replaceAll(",", " ").trim();
            s.setName(trimmedName);
            s.setCode(trimmedName);
            s.setPath(SurveyUtils.fixPath(s.getPath(), trimmedName));
        }
        if (Boolean.FALSE.equals(s.getMonitoringGroup())) {
            s.setNewLocaleSurveyId(null);
        }
        s.setPublished(false);
        s.setAncestorIds(SurveyUtils.retrieveAncestorIds(s));
        if (hasMoved) {
            SurveyUtils.setChildObjects(s);
            this.surveyGroupDao.save(s.updateAncestorIds(true));
        }
        s = this.surveyGroupDao.save(s);
        DtoMarshaller.copyToDto(s, responseDto);
        statusDto.setStatus("ok");
        return response;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> saveNewSurveyGroup(@RequestBody SurveyGroupPayload payLoad) {
        SurveyGroupDto surveyGroupDto = payLoad.getSurvey_group();
        HashMap<String, Object> response = new HashMap<String, Object>();
        SurveyGroupDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (surveyGroupDto != null) {
            SurveyGroup s = new SurveyGroup();
            BeanUtils.copyProperties((Object)surveyGroupDto, (Object)s, (String[])new String[]{"createdDateTime", "lastUpdateDateTime", "displayName", "questionGroupList", "ancestorIds"});
            s.setAncestorIds(SurveyUtils.retrieveAncestorIds(s));
            s.setCode(s.getName());
            s = this.surveyGroupDao.save(s);
            dto = new SurveyGroupDto();
            DtoMarshaller.copyToDto(s, dto);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("survey_group", dto);
        return response;
    }
}

