/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.device.dao;

import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.framework.dao.BaseDAO;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class DeviceDAO
extends BaseDAO<Device> {
    private static final Logger log = Logger.getLogger(DeviceDAO.class.getName());

    public DeviceDAO() {
        super(Device.class);
    }

    public Device getDevice(String androidId, String imei, String phoneNumber) {
        Device device = null;
        if (StringUtils.isNotEmpty((String)androidId)) {
            device = (Device)super.findByProperty("androidId", androidId, "String");
        }
        if (device == null && StringUtils.isNotEmpty((String)imei) && !"NO_IMEI".equals(imei)) {
            device = (Device)super.findByProperty("esn", imei, "String");
        }
        if (device == null && StringUtils.isNotEmpty((String)phoneNumber)) {
            device = (Device)super.findByProperty("phoneNumber", phoneNumber, "String");
        }
        return device;
    }

    public void updateDevice(String phoneNumber, Double lat, Double lon, Double accuracy, String version, String deviceIdentifier, String imei, String osVersion, String androidId) {
        if (StringUtils.isEmpty((String)imei) && StringUtils.isEmpty((String)phoneNumber)) {
            return;
        }
        Device d = this.getDevice(androidId, imei, phoneNumber);
        if (d == null) {
            d = new Device();
            d.setCreatedDateTime(new Date());
            d.setDeviceType(Device.DeviceType.CELL_PHONE_ANDROID);
        }
        d.setPhoneNumber(phoneNumber);
        d.setAndroidId(androidId);
        d.setLastLocationBeaconTime(new Date());
        if (version != null && !version.trim().isEmpty()) {
            d.setGallatinSoftwareManifest(version);
        }
        if (lat != null && lon != null) {
            d.setLastKnownLat(lat);
            d.setLastKnownLon(lon);
            d.setLastKnownAccuracy(accuracy);
        }
        if (deviceIdentifier != null) {
            d.setDeviceIdentifier(deviceIdentifier);
        }
        if (imei != null && !"NO_IMEI".equals(imei)) {
            d.setEsn(imei);
        }
        if (osVersion != null) {
            d.setOsVersion(osVersion);
        }
        this.save(d);
    }

    public List<Device> listAllWithBeaconBefore(Date date) {
        return this.listByProperty("lastLocationBeaconTime", date, "Date", "lastLocationBeaconTime", null, " <= ", Device.class);
    }
}

