/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.exceptions.IllegalDeletionException;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.QuestionGroupDao;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyContainer;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.survey.xml.SurveyXMLAdapter;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Text;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.xml.bind.JAXBException;
import org.waterforpeople.mapping.domain.SurveyQuestion;

public class SurveyDAO
extends BaseDAO<Survey> {
    private static final Logger log = Logger.getLogger(SurveyDAO.class.getName());
    private QuestionGroupDao questionGroupDao = new QuestionGroupDao();

    public SurveyDAO() {
        super(Survey.class);
    }

    @Override
    public SurveyGroup save(SurveyGroup surveyGroup) {
        return super.save(surveyGroup);
    }

    public Survey save(Survey survey, Key surveyGroupKey) {
        survey = super.save(survey);
        return survey;
    }

    public Survey getById(Long key) {
        return (Survey)super.getByKey(key);
    }

    @Override
    public Survey getByKey(Key key) {
        return (Survey)super.getByKey(key);
    }

    public Survey loadFullForm(Long formId) {
        Survey form = this.getById(formId);
        TreeMap<Integer, QuestionGroup> qgMap = this.questionGroupDao.listQuestionGroupsBySurvey(formId);
        form.setQuestionGroupMap(qgMap);
        QuestionDao questionDao = new QuestionDao();
        List<Question> ql = questionDao.listQuestionsByForm(formId, true);
        HashMap<Long, TreeMap<Integer, Question>> mapMap = new HashMap<Long, TreeMap<Integer, Question>>();
        for (QuestionGroup qg : qgMap.values()) {
            TreeMap<Integer, Question> map = new TreeMap<Integer, Question>();
            qg.setQuestionMap(map);
            mapMap.put(qg.getKey().getId(), map);
        }
        for (Question q : ql) {
            ((Map)mapMap.get(q.getQuestionGroupId())).put(q.getOrder(), q);
        }
        return form;
    }

    public Long save(Long surveyId, String surveyDocument) {
        SurveyContainer sc = new SurveyContainer();
        sc.setSurveyId(surveyId);
        Text surveyText = new Text(surveyDocument);
        sc.setSurveyDocument(surveyText);
        sc = super.save(sc);
        return sc.getKey().getId();
    }

    public com.gallatinsystems.survey.domain.xml.Survey get(Long id) {
        SurveyContainer surveyContainer = this.getByKey(id, SurveyContainer.class);
        SurveyXMLAdapter sxa = new SurveyXMLAdapter();
        com.gallatinsystems.survey.domain.xml.Survey survey = null;
        try {
            survey = sxa.unmarshall(surveyContainer.getSurveyDocument().toString());
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, "Could not unmarshal xml", e);
        }
        return survey;
    }

    public String getSurveyDocument(Long id) {
        SurveyContainer surveyContainer = this.getByKey(id, SurveyContainer.class);
        return surveyContainer.getSurveyDocument().getValue();
    }

    public List<Survey> listAllFilteredByUserAuthorization() {
        List allSurveys = this.list("all");
        return this.filterByUserAuthorizationObjectId(allSurveys);
    }

    public List<SurveyContainer> listSurveyContainers() {
        return this.list(SurveyContainer.class, "all");
    }

    public List<SurveyQuestion> listQuestionByType(String questionType) {
        return this.listByProperty("type", (Object)questionType, "String", SurveyQuestion.class);
    }

    public List<SurveyGroup> listSurveyGroup(String cursorString) {
        return this.list(SurveyGroup.class, cursorString);
    }

    public List<Survey> listSurveysByGroup(Long surveyGroupId) {
        return this.listByProperty("surveyGroupId", surveyGroupId, "Long");
    }

    public Survey getByParentIdAndCode(String code, Long surveyGroupId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(Survey.class);
        query.setFilter(" code == codeParam && surveyGroupId == idParam");
        query.declareParameters("String codeParam, Long idParam");
        List results = (List)query.execute((Object)code, (Object)surveyGroupId);
        if (results != null && results.size() > 0) {
            return (Survey)results.get(0);
        }
        return null;
    }

    public Survey getByPath(String code, String path) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(Survey.class);
        query.setFilter(" path == pathParam && name == codeParam");
        query.declareParameters("String pathParam, String codeParam");
        List results = (List)query.execute((Object)path, (Object)code);
        if (results != null && results.size() > 0) {
            return (Survey)results.get(0);
        }
        return null;
    }

    @Override
    public void delete(Survey survey) throws IllegalDeletionException {
        QuestionGroupDao qgDao = new QuestionGroupDao();
        qgDao.deleteGroupsForSurvey(survey.getKey().getId());
        super.delete(survey);
    }

    public List<Key> listSurveyIds() {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery("select key from " + Survey.class.getName());
        List results = (List)query.execute();
        return results;
    }
}

